/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.channels;

import com.amazon.jdbc.communications.channels.AbstractMessagesSocketChannel;
import com.amazon.jdbc.communications.exceptions.MessageBoundarySyncronizationLostException;
import com.amazon.jdbc.communications.exceptions.MessagesFrameworkMessageKey;
import com.amazon.jdbc.communications.interfaces.AbstractInboundDataHandler;
import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class MessagesSocketChannel
extends AbstractMessagesSocketChannel {
    protected static final int READ_BUFFER_CAPACITY = 512000;
    private static int WRITE_BUFFER_CAPACITY = 64000;
    private ByteBuffer m_readBuffer;
    private ByteBuffer m_writeBuffer = ByteBuffer.allocateDirect(WRITE_BUFFER_CAPACITY);

    public MessagesSocketChannel(SocketChannel socketChannel, AbstractInboundDataHandler abstractInboundDataHandler, ILogger iLogger) throws ErrorException {
        super(socketChannel, abstractInboundDataHandler, iLogger);
        this.m_readBuffer = ByteBuffer.allocateDirect(512000);
        this.m_readBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    protected void writeMessages(AbstractOutboundMessage[] abstractOutboundMessageArray) throws ErrorException {
        if (null == this.m_internal || !this.m_internal.isConnected()) {
            throw EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name());
        }
        int n = 0;
        for (AbstractOutboundMessage abstractOutboundMessage : abstractOutboundMessageArray) {
            if (null == abstractOutboundMessage) continue;
            n += abstractOutboundMessage.getSize() + 1;
        }
        if (n > this.m_writeBuffer.capacity()) {
            this.m_writeBuffer = ByteBuffer.allocateDirect(n);
        }
        this.m_writeBuffer.clear();
        for (AbstractOutboundMessage abstractOutboundMessage : abstractOutboundMessageArray) {
            if (null == abstractOutboundMessage) continue;
            abstractOutboundMessage.serialize(this.m_writeBuffer);
        }
        this.m_writeBuffer.flip();
        while (this.m_writeBuffer.hasRemaining()) {
            try {
                int n2 = this.m_internal.write(this.m_writeBuffer);
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("Writing " + n2 + " bytes", this.m_log);
            }
            catch (IOException iOException) {
                String string;
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug(iOException, this.m_log);
                }
                if (null == (string = iOException.getMessage())) {
                    string = "The server closed the connection";
                }
                ErrorException errorException = EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), string);
                errorException.initCause(iOException);
                throw errorException;
            }
        }
    }

    @Override
    protected void readMessages() throws ErrorException, MessageBoundarySyncronizationLostException {
        int n = -2;
        do {
            try {
                n = this.m_internal.read(this.m_readBuffer);
            }
            catch (IOException iOException) {
                LogUtilities.logFatal(iOException, this.m_log);
                String string = iOException.getMessage();
                if (null == string) {
                    string = "The server closed the connection";
                }
                throw EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), string);
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Bytes read from channel: " + n, this.m_log);
            }
            if (-1 != n) continue;
            this.m_readBuffer.flip();
            this.m_dataHandler.handle(this.m_readBuffer);
            throw EXCEPTION_BUILDER.createGeneralException(MessagesFrameworkMessageKey.CONN_GENERAL_ERR.name(), "The server closed the connection");
        } while (n > 0);
        this.m_readBuffer.flip();
        this.m_dataHandler.handle(this.m_readBuffer);
    }

    @Override
    public int getReadBufferCapacity() {
        return 512000;
    }

    @Override
    public int getWriteBufferCapacity() {
        return WRITE_BUFFER_CAPACITY;
    }
}

