/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETATan2Fn
extends ETScalarFn {
    public ETATan2Fn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == list.size() && 2 == list2.size());
        assert (8 == list2.get(0).getTypeMetadata().getType());
        assert (8 == list2.get(1).getTypeMetadata().getType());
        assert (8 == iColumn.getTypeMetadata().getType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            double d = iSqlDataWrapper.getDouble();
            double d2 = iSqlDataWrapper2.getDouble();
            eTDataRequest.getData().setDouble(Math.atan2(d, d2));
        }
        return false;
    }
}

