/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable.column;

import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.amazon.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.math.BigDecimal;

public final class ExactNumColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 5227156909031151909L;
    private BigDecimal[] m_data;
    private final int m_columnNumber;

    public ExactNumColumnSlice(int n, int n2) {
        this.m_data = new BigDecimal[n];
        this.m_columnNumber = n2;
    }

    public int columnNumber() {
        return this.m_columnNumber;
    }

    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    public void setNull(int n) {
        this.m_data[n] = null;
    }

    public BigDecimal getExactNum(int n) {
        return this.m_data[n];
    }

    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.EXACT_NUM;
    }

    public void setExactNum(int n, BigDecimal bigDecimal) {
        this.m_data[n] = bigDecimal;
    }

    public int size() {
        return this.m_data.length;
    }

    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        ExactNumColumnSlice exactNumColumnSlice = (ExactNumColumnSlice)iColumnSlice;
        System.arraycopy(exactNumColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    public static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        int n = javaSize.getObjectShellSize();
        n += javaSize.getIntSize();
        n += 2 * javaSize.getLongSize();
        n += javaSize.getObjectRefSize();
        n += javaSize.getObjectShellSize();
        n += 5 * javaSize.getIntSize();
        n += javaSize.getObjectRefSize();
        return n += javaSize.estimateArraySize(javaSize.getIntSize(), 4);
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

