/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.ddl;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.AEUtils;
import com.amazon.sqlengine.dsiext.dataengine.ddl.TableConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSpecification {
    private String m_catalog;
    private String m_schema;
    private String m_name;
    private List<IColumn> m_columns;
    private List<TableConstraint> m_constraints;

    public TableSpecification(String string, String string2, String string3, List<IColumn> list, List<TableConstraint> list2) {
        if (string3 == null || string3.equals("")) {
            throw new IllegalArgumentException("Table must have a valid name.");
        }
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("A table must have at least one column");
        }
        this.m_catalog = string == null ? "" : string;
        this.m_schema = string2 == null ? "" : string2;
        this.m_name = string3;
        this.m_columns = list;
        this.m_constraints = list2 == null ? new ArrayList<TableConstraint>() : list2;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getTableName() {
        return this.m_name;
    }

    public List<IColumn> getColumns() {
        return Collections.unmodifiableList(this.m_columns);
    }

    public List<TableConstraint> getConstraints() {
        return Collections.unmodifiableList(this.m_constraints);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (0 < this.m_catalog.length()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.m_catalog)).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.m_schema)).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.m_name));
        } else if (0 < this.m_schema.length()) {
            stringBuilder.append(AEUtils.sqlQuoted(this.m_schema)).append(".");
            stringBuilder.append(AEUtils.sqlQuoted(this.m_name));
        } else {
            stringBuilder.append(AEUtils.sqlQuoted(this.m_name));
        }
        stringBuilder.append("(");
        for (IColumn object : this.m_columns) {
            stringBuilder.append(" ");
            stringBuilder.append(object.getName());
            stringBuilder.append(":");
            stringBuilder.append(object.getTypeMetadata().getTypeName());
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" )");
        if (!this.m_constraints.isEmpty()) {
            stringBuilder.append(" => TABLE CONSTRAINT(S): ");
            for (TableConstraint tableConstraint : this.m_constraints) {
                stringBuilder.append(tableConstraint);
                stringBuilder.append("; ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }
}

