/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.metadatautil;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.Searchable;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.Updatable;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.amazon.sqlengine.aeprocessor.metadatautil.AELiteralMetadataFactory;
import com.amazon.sqlengine.aeprocessor.metadatautil.AEMetadataCoercer;
import com.amazon.sqlengine.aeprocessor.metadatautil.AESqlTypeCoercer;
import com.amazon.sqlengine.aeprocessor.metadatautil.AETypeNormalizer;
import com.amazon.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.amazon.sqlengine.aeprocessor.metadatautil.MetadataUtilities;
import com.amazon.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.amazon.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.amazon.sqlengine.dsiext.dataengine.IColumnInfo;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEMetadataCoercionHandler
implements ICoercionHandler {
    private final AECoercionProperties m_properties = new AECoercionProperties.Builder().build();
    private AETypeNormalizer m_typeNormalizer = new AETypeNormalizer(this.m_properties);
    private AESqlTypeCoercer m_typeCoercer = new AESqlTypeCoercer();
    private AEMetadataCoercer m_metadataCoercer = new AEMetadataCoercer(this.m_properties);
    private AELiteralMetadataFactory m_literalMetadataFactory = new AELiteralMetadataFactory(this.m_typeNormalizer, this.m_properties);

    @Override
    public IColumn coerceComparisonColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.COMPARISON, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceConcatColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.CONCAT, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceInColumns(IColumnInfo iColumnInfo, List<? extends IColumnInfo> list) throws ErrorException {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("Can not coerce data type for IN expression: invalid argument.");
        }
        ArrayList<IColumnInfo> arrayList = new ArrayList<IColumnInfo>();
        for (IColumnInfo object2 : list) {
            if (IColumnInfo.ColumnType.NULL == object2.getColumnType()) continue;
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(list.get(0));
        }
        Object object3 = (IColumnInfo)arrayList.get(0);
        ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata((IColumnInfo)object3);
        for (int i = 1; i < arrayList.size(); ++i) {
            ColumnMetadata columnMetadata2 = this.generalizedCoercion(CoercionOperation.SET_OPERATION, (IColumnInfo)object3, (IColumnInfo)arrayList.get(i));
            object3 = new MetadataColumnInfo(columnMetadata2, IColumnInfo.ColumnType.COLUMN);
        }
        return this.generalizedCoercion(CoercionOperation.IN, iColumnInfo, (IColumnInfo)object3);
    }

    @Override
    public IColumn coerceLikeColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.LIKE, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceUnionColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.SET_OPERATION, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceDivisionColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.DIVISION, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceMinusColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.MINUS, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coercePlusColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.PLUS, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn coerceMultiplicationColumns(IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.generalizedCoercion(CoercionOperation.MULTIPLICATION, iColumnInfo, iColumnInfo2);
    }

    @Override
    public IColumn determineLiteralColumn(String string, ICoercionHandler.LiteralType literalType) throws ErrorException {
        return this.m_literalMetadataFactory.determineLiteralType(string, literalType);
    }

    @Override
    public IColumn coerceUnaryMinusColumn(IColumnInfo iColumnInfo) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(iColumnInfo.getType());
        if (sqlTypes.isInteger() || sqlTypes == SqlTypes.SQL_BIT) {
            SqlTypes sqlTypes2 = null;
            sqlTypes2 = sqlTypes == SqlTypes.SQL_BIT ? SqlTypes.SQL_INTEGER : AESqlTypeCoercer.upIntegerType(sqlTypes);
            if ((sqlTypes2 = this.m_typeNormalizer.normalizeType(sqlTypes2)) == null) {
                throw SQLEngineExceptionFactory.invalidOperationException("Can not normalize type: all available coercion type is disabled.");
            }
            ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(sqlTypes2.getSqlType(), true));
            columnMetadata.setNullable(iColumnInfo.getNullable());
            columnMetadata.setUpdatable(iColumnInfo.getUpdatable());
            columnMetadata.setName(null);
            return columnMetadata;
        }
        if (sqlTypes.isNumber()) {
            ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata(iColumnInfo);
            columnMetadata.getTypeMetadata().setSigned(true);
            columnMetadata.setName(null);
            return columnMetadata;
        }
        if (SqlTypes.SQL_DATE == sqlTypes || SqlTypes.SQL_TIMESTAMP == sqlTypes || SqlTypes.SQL_NULL == sqlTypes) {
            ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata(iColumnInfo);
            columnMetadata.setName(null);
            return columnMetadata;
        }
        throw SQLEngineExceptionFactory.incompatibleTypesException("NEGATION", sqlTypes.name());
    }

    protected long calcColumnLength(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.calcColumnLength(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected PrecisionScale calcPrecisionScale(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.calcPrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected int coerceType(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        return this.m_typeCoercer.coerceType(coercionOperation, iColumnInfo, iColumnInfo2);
    }

    protected boolean coerceIsCurrency(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsCurrency(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected boolean coerceIsSigned(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsSigned(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected Nullable coerceNullable(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceNullable(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected boolean coerceIsCaseSensitive(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsCaseSensitive(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected Searchable coerceSearchability(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceSearchability(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected Updatable coerceUpdatability(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceUpdatability(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected boolean coerceIsAutoUnique(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, IColumn iColumn) throws ErrorException {
        return this.m_metadataCoercer.coerceIsAutoUnique(coercionOperation, iColumnInfo, iColumnInfo2, iColumn);
    }

    protected final void disableCoercionTypes(Set<Integer> set) throws ErrorException {
        for (int n : set) {
            this.m_typeNormalizer.disableType(n);
        }
    }

    protected int normalizeCoercionType(int n) throws ErrorException {
        return this.m_typeNormalizer.normalizeType(n);
    }

    protected void finalizeCoercion(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2, ColumnMetadata columnMetadata) throws ErrorException {
        SqlTypes sqlTypes;
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(columnMetadata.getTypeMetadata().getType());
        if ((sqlTypes2.isChar() || sqlTypes2.isWChar() || sqlTypes2.isBinary()) && (sqlTypes = this.m_typeNormalizer.fitBinaryOrCharType(sqlTypes2, columnMetadata.getColumnLength())) != sqlTypes2) {
            columnMetadata.setTypeMetadata(this.getBinaryOrCharTypeReplacement(columnMetadata.getTypeMetadata(), sqlTypes));
        }
        columnMetadata.setName(null);
    }

    protected final void overrideCoercionType(CoercionOperation coercionOperation, int n, int n2, int n3) throws ErrorException {
        this.m_typeCoercer.overrideCoercionType(coercionOperation, n, n2, n3);
    }

    private ColumnMetadata generalizedCoercion(CoercionOperation coercionOperation, IColumnInfo iColumnInfo, IColumnInfo iColumnInfo2) throws ErrorException {
        if (coercionOperation == null || iColumnInfo == null || iColumnInfo2 == null) {
            throw new NullPointerException("Coercion handler are called with null argument.");
        }
        if (IColumnInfo.ColumnType.NULL == iColumnInfo.getColumnType()) {
            ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata(iColumnInfo2);
            this.finalizeCoercion(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata);
            return columnMetadata;
        }
        if (IColumnInfo.ColumnType.NULL == iColumnInfo2.getColumnType()) {
            ColumnMetadata columnMetadata = MetadataUtilities.createColumnMetadata(iColumnInfo);
            this.finalizeCoercion(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata);
            return columnMetadata;
        }
        int n = this.coerceType(coercionOperation, iColumnInfo, iColumnInfo2);
        n = this.normalizeCoercionType(n);
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
        ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata);
        PrecisionScale precisionScale = this.calcPrecisionScale(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata);
        typeMetadata.setPrecision(precisionScale.getPrecision());
        typeMetadata.setScale(precisionScale.getScale());
        typeMetadata.setSigned(this.coerceIsSigned(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        typeMetadata.setIsCurrency(this.coerceIsCurrency(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        try {
            columnMetadata.setColumnLength(this.calcColumnLength(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.numericOverflowException(numericOverflowException.getMessage());
        }
        columnMetadata.setNullable(this.coerceNullable(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setCaseSensitive(this.coerceIsCaseSensitive(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setSearchable(this.coerceSearchability(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setUpdatable(this.coerceUpdatability(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        columnMetadata.setAutoUnique(this.coerceIsAutoUnique(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata));
        this.finalizeCoercion(coercionOperation, iColumnInfo, iColumnInfo2, columnMetadata);
        return columnMetadata;
    }

    private TypeMetadata getBinaryOrCharTypeReplacement(TypeMetadata typeMetadata, SqlTypes sqlTypes) throws ErrorException {
        SqlTypes sqlTypes2 = SqlTypes.getValueOf(typeMetadata.getType());
        assert (sqlTypes2.isBinary() && sqlTypes.isBinary() || sqlTypes2.isChar() && sqlTypes.isChar() || sqlTypes2.isWChar() && sqlTypes.isWChar());
        TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(sqlTypes.getSqlType());
        typeMetadata2.setIsSortable(typeMetadata.isSortable());
        typeMetadata2.setPrecision(typeMetadata.getPrecision());
        return typeMetadata2;
    }

    protected static final class PrecisionScale {
        private short m_precision;
        private short m_scale;

        public PrecisionScale(short s, short s2) {
            this.m_precision = s;
            this.m_scale = s2;
        }

        public short getPrecision() {
            return this.m_precision;
        }

        public void setPrecision(short s) {
            this.m_precision = s;
        }

        public short getScale() {
            return this.m_scale;
        }

        public void setScale(short s) {
            this.m_scale = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CoercionOperation {
        COMPARISON,
        CONCAT,
        IN,
        LIKE,
        SET_OPERATION,
        DIVISION,
        MINUS,
        PLUS,
        MULTIPLICATION;

    }
}

