/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.List;

public class PGTablePrivilegesMetadatSourceFromQuery
extends PGResultSet
implements IMetadataSource {
    private List<GranteePrivileges> m_tablePrivileges;
    private GranteePrivileges m_currentGrantee;
    private int m_granteeIndex;
    private int m_granteesNumber = 1;
    private int m_privilegeIndex;
    private int m_privilegesNumber = 1;

    public PGTablePrivilegesMetadatSourceFromQuery(PGMessagingContext contexts, ILogger logger) {
        super(contexts, logger);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag columnTag, long offset, long maxSize, DataWrapper data) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{columnTag, offset, maxSize});
        switch (columnTag) {
            case CATALOG_NAME: {
                return super.getData(0, offset, maxSize, data);
            }
            case SCHEMA_NAME: {
                return super.getData(1, offset, maxSize, data);
            }
            case TABLE_NAME: {
                return super.getData(2, offset, maxSize, data);
            }
            case GRANTOR: {
                if (null != this.m_currentGrantee) {
                    data.setVarChar(this.m_currentGrantee.m_grantor);
                } else {
                    data.setVarChar("toto");
                }
                return false;
            }
            case GRANTEE: {
                if (null != this.m_currentGrantee) {
                    data.setVarChar(this.m_currentGrantee.m_grantee);
                } else {
                    data.setVarChar("tutu");
                }
                return false;
            }
            case PRIVILEGE: {
                if (null != this.m_currentGrantee) {
                    data.setVarChar(this.m_currentGrantee.m_privileges.get(this.m_privilegeIndex));
                } else {
                    data.setVarChar("pouet");
                }
                return false;
            }
            case ISGRANTABLE: {
                data.setNull(12);
                return false;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{columnTag.toString()}, ExceptionType.DEFAULT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean moveToNextRow() {
        boolean result = false;
        try {
            if (this.m_granteeIndex == this.m_granteesNumber - 1 && this.m_privilegeIndex == this.m_privilegesNumber - 1) {
                this.m_privilegeIndex = 0;
                this.m_privilegesNumber = 1;
                this.m_granteeIndex = 0;
                this.m_granteesNumber = 1;
                result = super.moveToNextRow();
                if (true != result) return result;
                DataWrapper wrapper = new DataWrapper();
                super.getData(4, 0L, -1L, wrapper);
                PGArray acl = (PGArray)wrapper.getArray();
                this.m_tablePrivileges = new ArrayList<GranteePrivileges>();
                GranteePrivileges granteePrivileges = null;
                if (null != acl) {
                    String[] subSets;
                    String privilegesValue = acl.getStringRepresentation();
                    privilegesValue = privilegesValue.substring(1, privilegesValue.length() - 1);
                    for (String currentSubSet : subSets = privilegesValue.split(",")) {
                        String grantee = currentSubSet.substring(0, currentSubSet.indexOf("="));
                        String grantor = currentSubSet.substring(currentSubSet.indexOf("/") + 1, currentSubSet.length());
                        String privileges = currentSubSet.substring(currentSubSet.indexOf("=") + 1, currentSubSet.indexOf("/"));
                        granteePrivileges = new GranteePrivileges(grantee, grantor, privileges);
                        this.m_tablePrivileges.add(granteePrivileges);
                    }
                } else {
                    wrapper = new DataWrapper();
                    super.getData(3, 0L, -1L, wrapper);
                    String owner = wrapper.getVarChar();
                    granteePrivileges = new GranteePrivileges(owner);
                    this.m_tablePrivileges.add(granteePrivileges);
                }
                this.m_granteesNumber = this.m_tablePrivileges.size();
                this.m_currentGrantee = this.m_tablePrivileges.get(this.m_granteeIndex);
                this.m_privilegesNumber = this.m_currentGrantee.m_privileges.size();
                return true;
            }
            if (this.m_privilegeIndex != this.m_privilegesNumber - 1) {
                ++this.m_privilegeIndex;
                return true;
            } else {
                ++this.m_granteeIndex;
                this.m_currentGrantee = this.m_tablePrivileges.get(this.m_granteeIndex);
                this.m_privilegeIndex = 0;
                this.m_privilegesNumber = this.m_currentGrantee.m_privileges.size();
            }
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private class GranteePrivileges {
        private static final String UNSET_GRANTEE = "PUBLIC";
        private static final String UNKNOWN = "UNKNOWN";
        public List<String> m_privileges;
        public String m_grantee;
        public String m_grantor;

        private GranteePrivileges(String grantee, String grantor, String privilegeString) {
            this.m_grantee = grantee;
            if (0 == grantee.length()) {
                this.m_grantee = UNSET_GRANTEE;
            }
            this.m_grantor = grantor;
            this.m_privileges = new ArrayList<String>();
            for (char currentPrivilege : privilegeString.toCharArray()) {
                Privilege privilege = Privilege.getPrivilegeFromId(currentPrivilege);
                if (null == privilege) continue;
                this.m_privileges.add(privilege.toString());
            }
            if (this.m_grantee.equals(UNSET_GRANTEE) && this.m_privileges.contains(Privilege.SELECT.toString())) {
                this.m_privileges.add(Privilege.DELETE.toString());
            }
            this.m_privileges.add(UNKNOWN);
        }

        private GranteePrivileges(String owner) {
            this.m_grantee = owner;
            this.m_grantor = owner;
            this.m_privileges = new ArrayList<String>();
            for (Privilege privilege : Privilege.values()) {
                this.m_privileges.add(privilege.toString());
            }
        }
    }

    private static enum Privilege {
        SELECT('r'),
        UPDATE('w'),
        INSERT('a'),
        DELETE('d'),
        RULE('R'),
        REFERENCES('x'),
        TRIGGER('t');

        private char m_id;

        private Privilege(char id) {
            this.m_id = id;
        }

        public static Privilege getPrivilegeFromId(char id) {
            for (Privilege current : Privilege.values()) {
                if (current.m_id != id) continue;
                return current;
            }
            return null;
        }
    }
}

