/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DSITypeUtilities;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.Searchable;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;

public class PGJDBCTypeInfoMetadataSource
implements IMetadataSource,
PGConstants {
    private boolean m_isFetching = false;
    private int m_currentIndex = 0;
    ArrayList<TypeInfo> m_dataTypes = new ArrayList();
    private ILogger m_logger;

    public PGJDBCTypeInfoMetadataSource(ILogger logger) {
        LogUtilities.logFunctionEntrance(logger, logger);
        this.m_logger = logger;
        this.initializeDataTypes();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isFetching = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long offset, long maxSize, DataWrapper data) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, offset, maxSize});
        switch (metadataSourceColumnTag) {
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_typeName, data, offset, maxSize);
            }
            case DATA_TYPE: {
                data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType);
                return false;
            }
            case COLUMN_SIZE: {
                data.setInteger(this.m_dataTypes.get((int)this.m_currentIndex).m_columnSize);
                return false;
            }
            case LITERAL_PREFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalPrefix, data, offset, maxSize);
            }
            case LITERAL_SUFFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalSuffix, data, offset, maxSize);
            }
            case CREATE_PARAM: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_createParams, data, offset, maxSize);
            }
            case NULLABLE: {
                data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_nullable.ordinal());
                return false;
            }
            case CASE_SENSITIVE: {
                if (this.m_dataTypes.get((int)this.m_currentIndex).m_caseSensitive) {
                    data.setSmallInt(1);
                } else {
                    data.setSmallInt(0);
                }
                return false;
            }
            case SEARCHABLE: {
                data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_searchable.ordinal());
                return false;
            }
            case UNSIGNED_ATTRIBUTE: {
                TypeInfo info = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(info.m_sqlType) || TypeUtilities.isExactNumericType(info.m_sqlType) || TypeUtilities.isIntegerType(info.m_sqlType))) {
                    data.setNull(5);
                } else if (this.m_dataTypes.get((int)this.m_currentIndex).m_unsignedAttr) {
                    data.setSmallInt(1);
                } else {
                    data.setSmallInt(0);
                }
                return false;
            }
            case FIXED_PREC_SCALE: {
                data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_fixedPrecScale);
                return false;
            }
            case AUTO_UNIQUE: {
                TypeInfo info = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(info.m_sqlType) || TypeUtilities.isExactNumericType(info.m_sqlType) || TypeUtilities.isIntegerType(info.m_sqlType))) {
                    data.setNull(5);
                } else if (-1 == this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique) {
                    data.setNull(5);
                } else {
                    data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique);
                }
                return false;
            }
            case LOCAL_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_typeName, data, offset, maxSize);
            }
            case MINIMUM_SCALE: {
                TypeInfo info = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(info.m_sqlType) || TypeUtilities.isIntegerType(info.m_sqlType) || -7 == info.m_sqlType || 92 == info.m_sqlType || 93 == info.m_sqlType) {
                    data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_minScale);
                } else {
                    data.setNull(5);
                }
                return false;
            }
            case MAXIMUM_SCALE: {
                TypeInfo info = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(info.m_sqlType) || TypeUtilities.isIntegerType(info.m_sqlType) || -7 == info.m_sqlType || 92 == info.m_sqlType || 93 == info.m_sqlType) {
                    data.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_maxScale);
                } else {
                    data.setNull(5);
                }
                return false;
            }
            case SQL_DATA_TYPE: {
                int sqlType = this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType;
                data.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(sqlType));
                return false;
            }
            case SQL_DATETIME_SUB: {
                TypeInfo info = this.m_dataTypes.get(this.m_currentIndex);
                short datetimeSub = TypeUtilities.getIntervalCodeFromConciseType(info.m_sqlType);
                if (0 == datetimeSub) {
                    data.setNull(5);
                } else {
                    data.setSmallInt(datetimeSub);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeInfo info = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isApproximateNumericType(info.m_sqlType)) {
                    data.setInteger(2L);
                } else if (TypeUtilities.isExactNumericType(info.m_sqlType) || TypeUtilities.isIntegerType(info.m_sqlType)) {
                    data.setInteger(10L);
                } else {
                    data.setNull(4);
                }
                return false;
            }
            case INTERVAL_PRECISION: {
                data.setNull(5);
                return false;
            }
            case USER_DATA_TYPE: {
                data.setSmallInt(0);
                return false;
            }
        }
        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_dataTypes.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            ++this.m_currentIndex;
        } else {
            this.m_isFetching = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_dataTypes.size();
    }

    private void initializeDataTypes() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TypeInfo typeInfo = new TypeInfo(1, "char", 255);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        typeInfo.m_createParams = "LENGTH";
        typeInfo.m_caseSensitive = true;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(12, "varchar", 510);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        typeInfo.m_createParams = "max length";
        typeInfo.m_caseSensitive = true;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-1, "LONGVARCHAR", 65500);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        typeInfo.m_createParams = "LENGTH";
        typeInfo.m_caseSensitive = true;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-3, "VARBINARY", Short.MAX_VALUE);
        typeInfo.m_literalPrefix = "0x";
        typeInfo.m_createParams = "max length";
        typeInfo.m_searchable = Searchable.PREDICATE_NONE;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-4, "bytea", 2147483000);
        typeInfo.m_literalPrefix = "0x";
        typeInfo.m_createParams = "LENGTH";
        typeInfo.m_searchable = Searchable.PREDICATE_NONE;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-7, "bit", 1);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(2, "numeric", 38);
        typeInfo.m_createParams = "precision,scale";
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        typeInfo.m_minScale = 0;
        typeInfo.m_maxScale = (short)38;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(8, "float8", 15);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(7, "float4", 7);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-6, "TINYINT", 3);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(5, "int2", 5);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(4, "int4", 10);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_unsignedAttr = false;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(93, "timestamp", 29);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(91, "date", 13);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(92, "time", 8);
        typeInfo.m_literalPrefix = "'";
        typeInfo.m_literalSuffix = "'";
        this.m_dataTypes.add(typeInfo);
    }

    private static class TypeInfo {
        public String m_typeName;
        public int m_sqlType;
        public int m_columnSize;
        public String m_literalPrefix;
        public String m_literalSuffix;
        public String m_createParams;
        public Nullable m_nullable;
        public boolean m_caseSensitive;
        public Searchable m_searchable;
        public boolean m_unsignedAttr;
        public short m_fixedPrecScale;
        public short m_autoUnique;
        public short m_minScale;
        public short m_maxScale;

        public TypeInfo(int type, String typeName, int columnSize) {
            this.m_sqlType = type;
            this.m_typeName = typeName;
            this.m_columnSize = columnSize;
            this.m_literalPrefix = null;
            this.m_literalSuffix = null;
            this.m_createParams = null;
            this.m_nullable = Nullable.NULLABLE;
            this.m_caseSensitive = false;
            this.m_searchable = Searchable.SEARCHABLE;
            this.m_unsignedAttr = true;
            this.m_fixedPrecScale = 0;
            this.m_autoUnique = (short)-1;
            this.m_minScale = 0;
            this.m_maxScale = 0;
        }
    }
}

