/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;

public class PGCatalogQueryBuilder {
    public static String BuildCatalogQuery(MetadataSourceID metadataSourceId, Map<MetadataSourceColumnTag, String> restrictions, PGJDBCSettings connSettings) throws ErrorException {
        String catalogQuery = null;
        switch (metadataSourceId) {
            case CATALOG_ONLY: {
                catalogQuery = PGCatalogQueryBuilder.BuildCatalogOnlyQuery();
                break;
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                catalogQuery = PGCatalogQueryBuilder.BuildCatalogSchemaOnlyQuery();
                break;
            }
            case TABLES: {
                catalogQuery = PGCatalogQueryBuilder.BuildTablesQuery(restrictions);
                break;
            }
            case TABLE_PRIVILEGES: {
                catalogQuery = PGCatalogQueryBuilder.BuildTablePriviledgesQuery(restrictions);
                break;
            }
            case COLUMNS: {
                catalogQuery = PGCatalogQueryBuilder.BuildColumnsQuery(restrictions, connSettings);
                break;
            }
            case FOREIGN_KEYS: {
                catalogQuery = PGCatalogQueryBuilder.BuildForeignKeysQuery(restrictions);
                break;
            }
            case PRIMARY_KEYS: {
                catalogQuery = PGCatalogQueryBuilder.BuildPrimaryKeysQuery(restrictions);
                break;
            }
            case PROCEDURES: {
                catalogQuery = PGCatalogQueryBuilder.BuildProceduresQuery(restrictions);
                break;
            }
            case PROCEDURE_COLUMNS: {
                catalogQuery = PGCatalogQueryBuilder.BuildProcedureColumnsQuery(restrictions);
                break;
            }
            case FUNCTIONS_JDBC4: {
                catalogQuery = PGCatalogQueryBuilder.BuildFunctionsQuery(restrictions);
                break;
            }
            default: {
                catalogQuery = "Query not support";
            }
        }
        return catalogQuery;
    }

    public static String buildProcedureColumnsQueryForOldPostgres(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String procFilter = restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String procColumnQuery = "SELECT current_database() AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, CAST( 'returnValue' AS VARCHAR(256)) AS COLUMN_NAME, CAST(5 AS SMALLINT) AS COLUMN_TYPE, prorettype AS DATA_TYPE, CAST(NULL AS SMALLINT) AS COLUMN_SIZE, CAST(NULL AS SMALLINT) AS BUFFER_LENGTH, CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS, CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX, CAST(2 AS SMALLINT) AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB, CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH, CAST(0 AS SMALLINT) AS ORDINAL_POSITION, CAST(''AS VARCHAR(256)) AS IS_NULLABLE, p.proname || '_' || p.oid AS SPECIFIC_NAME, p.proargtypes,  p.proargnames FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
        if (null != schemaFilter && !schemaFilter.equals("")) {
            procColumnQuery = procColumnQuery + " AND  n.nspname LIKE '" + schemaFilter + "' ";
            if (null != procFilter && !procFilter.equals("")) {
                procColumnQuery = procColumnQuery + " AND  proname LIKE '" + procFilter + "' ";
            }
        } else if (null != procFilter && !procFilter.equals("")) {
            procColumnQuery = procColumnQuery + " AND  proname LIKE '" + procFilter + "' ";
        }
        procColumnQuery = procColumnQuery + " ORDER BY n.nspname, p.proname, p.oid";
        return procColumnQuery;
    }

    private static String BuildCatalogOnlyQuery() {
        String catalogQuery = "SELECT * FROM(select CAST(current_database() AS VARCHAR(124)) AS \"TABLE_CAT\") S ";
        return catalogQuery;
    }

    private static String BuildCatalogSchemaOnlyQuery() {
        String schemaQuery = "SELECT * FROM (select CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, CAST(nspname AS VARCHAR(124)) AS TABLE_SCHEM, CAST(NULL AS VARCHAR(124)) AS TABLE_NAME, CAST(NULL AS VARCHAR(124)) AS TABLE_TYPE, CAST('' AS VARCHAR(250)) AS REMARKS FROM pg_catalog.pg_namespace n WHERE true AND nspname <> 'pg_toast' AND (nspname !~ '^pg_temp_' OR nspname = (pg_catalog.current_schemas(true))[1]) AND (nspname !~ '^pg_toast_temp_' OR nspname = replace((pg_catalog.current_schemas(true))[1], 'pg_temp_', 'pg_toast_temp_'))) S ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME";
        return schemaQuery;
    }

    private static String BuildColumnsQuery(Map<MetadataSourceColumnTag, String> restrictions, PGJDBCSettings connSettings) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String tableFilter = restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String columnFilter = restrictions.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        StringBuilder result = new StringBuilder();
        result.append("SELECT current_database() AS TABLE_CAT, ");
        result.append("n.nspname , ");
        result.append("c.relname as TABLE_NAME , ");
        result.append("a.attname as COLUMN_NAME, ");
        result.append("CAST(case typname ");
        result.append("when 'text' THEN 12 ");
        result.append("when 'bit' THEN -7 ");
        result.append("when 'bool' THEN -7 ");
        result.append("when 'varchar' THEN 12 ");
        result.append("when 'character varying' THEN 12 ");
        result.append("when 'char' THEN 1 ");
        result.append("when 'character' THEN 1 ");
        result.append("when 'nchar' THEN 1 ");
        result.append("when 'bpchar' THEN 1 ");
        result.append("when 'nvarchar' THEN 1 ");
        result.append("when 'date' THEN 91 ");
        result.append("when 'timestamp' THEN 93 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 4 ");
        result.append("when 'int' THEN 4 ");
        result.append("when 'int4' THEN 4 ");
        result.append("when 'bigint' THEN -5 ");
        result.append("when 'int8' THEN -5 ");
        result.append("when 'decimal' THEN 3 ");
        result.append("when 'real' THEN 7 ");
        result.append("when 'float4' THEN 7 ");
        result.append("when 'double precision' THEN 8 ");
        result.append("when 'float8' THEN 8 ");
        result.append("when 'float' THEN 6 ");
        result.append("when 'numeric' THEN 2 ");
        result.append("when '_float4' THEN 2003 ");
        result.append("when 'timestamptz' THEN 93 ");
        result.append("when '_aclitem' THEN 2003 ");
        result.append("when '_text' THEN 2003 ");
        result.append("when 'bytea' THEN -2 ");
        result.append("when 'oid' THEN -5 ");
        result.append("when 'name' THEN 12 ");
        result.append("when '_int4' THEN 2003 ");
        result.append("when '_int2' THEN 2003 ");
        result.append("else 1111 END as SMALLINT) AS DATA_TYPE, ");
        result.append("t.typname as TYPE_NAME, ");
        result.append("case typname ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bit' THEN 1 ");
        result.append("when 'bool' THEN 1 ");
        result.append("when 'varchar' THEN atttypmod -4 ");
        result.append("when 'character varying' THEN atttypmod -4 ");
        result.append("when 'char' THEN atttypmod -4 ");
        result.append("when 'character' THEN atttypmod -4 ");
        result.append("when 'nchar' THEN atttypmod -4 ");
        result.append("when 'bpchar' THEN atttypmod -4 ");
        result.append("when 'nvarchar' THEN atttypmod -4 ");
        result.append("when 'date' THEN 13 ");
        result.append("when 'timestamp' THEN 29 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 10 ");
        result.append("when 'int' THEN 10 ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bigint' THEN 19 ");
        result.append("when 'int8' THEN 19 ");
        result.append("when 'decimal' then (atttypmod - 4) >> 16 ");
        result.append("when 'real' THEN 8 ");
        result.append("when 'float4' THEN 8 ");
        result.append("when 'double precision' THEN 17 ");
        result.append("when 'float8' THEN 17 ");
        result.append("when 'float' THEN 17 ");
        result.append("when 'numeric' THEN (atttypmod - 4) >> 16 ");
        result.append("when '_float4' THEN 8 ");
        result.append("when 'timestamptz' THEN 35 ");
        result.append("when 'oid' THEN 10 ");
        result.append("when '_int4' THEN 10 ");
        result.append("when '_int2' THEN 5 ");
        if (connSettings.m_unknownLength == null) {
            result.append("else 2147483647 end as COLUMN_SIZE , ");
        } else {
            result.append("else ");
            result.append(connSettings.m_unknownLength);
            result.append(" end as COLUMN_SIZE , ");
        }
        result.append("null as BUFFER_LENGTH , ");
        result.append("case typname ");
        result.append("when 'float4' then 8 ");
        result.append("when 'float8' then 17 ");
        result.append("when 'numeric' then (atttypmod - 4) & 65535 ");
        result.append("when 'timestamp' then 6 ");
        result.append("else 0 end as DECIMAL_DIGITS, ");
        result.append("10 AS NUM_PREC_RADIX , ");
        result.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        result.append("when 'false' then 1 ");
        result.append("when NULL then 2 ");
        result.append("else 0 end AS NULLABLE , ");
        result.append("dsc.description as REMARKS , ");
        result.append("pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS COLUMN_DEF, ");
        result.append("CAST(case typname ");
        result.append("when 'int4' THEN 4 ");
        result.append("when 'text' THEN 12 ");
        result.append("when 'bit' THEN -7 ");
        result.append("when 'bool' THEN -7 ");
        result.append("when 'varchar' THEN 12 ");
        result.append("when 'character varying' THEN 12 ");
        result.append("when 'char' THEN 1 ");
        result.append("when 'character' THEN 1 ");
        result.append("when 'nchar' THEN 1 ");
        result.append("when 'bpchar' THEN 1 ");
        result.append("when 'nvarchar' THEN 1 ");
        result.append("when 'date' THEN 91 ");
        result.append("when 'timestamp' THEN 93 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 4 ");
        result.append("when 'int' THEN 4 ");
        result.append("when 'int4' THEN 4 ");
        result.append("when 'bigint' THEN -5 ");
        result.append("when 'int8' THEN -5 ");
        result.append("when 'decimal' THEN 3 ");
        result.append("when 'real' THEN 7 ");
        result.append("when 'float4' THEN 7 ");
        result.append("when 'double precision' THEN 8 ");
        result.append("when 'float8' THEN 8 ");
        result.append("when 'float' THEN 6 ");
        result.append("when 'numeric' THEN 2 ");
        result.append("when '_float4' THEN 2003 ");
        result.append("when 'timestamptz' THEN 93 ");
        result.append("when '_aclitem' THEN 2003 ");
        result.append("when '_text' THEN 2003 ");
        result.append("when 'bytea' THEN -2 ");
        result.append("when 'oid' THEN -5 ");
        result.append("when 'name' THEN 12 ");
        result.append("when '_int4' THEN 2003 ");
        result.append("when '_int2' THEN 2003 ");
        result.append("else 1111 END as SMALLINT) AS SQL_DATA_TYPE, ");
        result.append("CAST(NULL AS SMALLINT) as SQL_DATETIME_SUB , ");
        result.append("case typname ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bit' THEN 1 ");
        result.append("when 'bool' THEN 1 ");
        result.append("when 'varchar' THEN atttypmod -4 ");
        result.append("when 'character varying' THEN atttypmod -4 ");
        result.append("when 'char' THEN atttypmod -4 ");
        result.append("when 'character' THEN atttypmod -4 ");
        result.append("when 'nchar' THEN atttypmod -4 ");
        result.append("when 'bpchar' THEN atttypmod -4 ");
        result.append("when 'nvarchar' THEN atttypmod -4 ");
        result.append("when 'date' THEN 13 ");
        result.append("when 'timestamp' THEN 29 ");
        result.append("when 'smallint' THEN 5 ");
        result.append("when 'int2' THEN 5 ");
        result.append("when 'integer' THEN 10 ");
        result.append("when 'int' THEN 10 ");
        result.append("when 'int4' THEN 10 ");
        result.append("when 'bigint' THEN 19 ");
        result.append("when 'int8' THEN 19 ");
        result.append("when 'decimal' then ((atttypmod - 4) >> 16) & 65535 ");
        result.append("when 'real' THEN 8 ");
        result.append("when 'float4' THEN 8 ");
        result.append("when 'double precision' THEN 17 ");
        result.append("when 'float8' THEN 17 ");
        result.append("when 'float' THEN 17 ");
        result.append("when 'numeric' THEN ((atttypmod - 4) >> 16) & 65535 ");
        result.append("when '_float4' THEN 8 ");
        result.append("when 'timestamptz' THEN 35 ");
        result.append("when 'oid' THEN 10 ");
        result.append("when '_int4' THEN 10 ");
        result.append("when '_int2' THEN 5 ");
        if (connSettings.m_unknownLength == null) {
            result.append("else 2147483647 end as CHAR_OCTET_LENGTH , ");
        } else {
            result.append("else ");
            result.append(connSettings.m_unknownLength);
            result.append(" end as CHAR_OCTET_LENGTH , ");
        }
        result.append("a.attnum AS ORDINAL_POSITION, ");
        result.append("case a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) ");
        result.append("when 'false' then 'YES' ");
        result.append("else 'NO' end AS IS_NULLABLE, ");
        result.append("null as SCOPE_CATLOG , ");
        result.append("null as SCOPE_SCHEMA , ");
        result.append("null as SCOPE_TABLE, ");
        result.append("t.typbasetype AS SOURCE_DATA_TYPE , ");
        result.append("'NO' as IS_AUTOINCREMENT ");
        result.append("FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid) ");
        result.append("JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid) ");
        result.append("JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) ");
        result.append("LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum) ");
        result.append("LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid) ");
        result.append("LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class') ");
        result.append("LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog') ");
        result.append("WHERE a.attnum > 0 AND NOT a.attisdropped    ");
        if (null != schemaFilter && !schemaFilter.equals("")) {
            result.append(" AND n.nspname LIKE '" + schemaFilter + "' ");
        } else {
            result.append(" AND n.nspname LIKE '%' ");
        }
        if (null != tableFilter && !tableFilter.equals("")) {
            result.append(" AND c.relname LIKE '" + tableFilter + "' ");
        }
        if (null != columnFilter && !columnFilter.equals("")) {
            result.append(" AND attname LIKE '" + columnFilter + "' ");
        }
        result.append(" ORDER BY nspname,c.relname,attnum  ");
        return result.toString();
    }

    private static String BuildForeignKeysQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String tableNameFilter = restrictions.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String schemaNameFilter = restrictions.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String foreignTableFilter = null;
        String foreignSchemaFilter = null;
        if (null == tableNameFilter && null == schemaNameFilter) {
            tableNameFilter = restrictions.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            schemaNameFilter = restrictions.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        } else {
            foreignTableFilter = restrictions.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
            foreignSchemaFilter = restrictions.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        }
        String foreignKeyQuery = "SELECT current_database() AS PKTABLE_CAT,  n2.nspname AS PKTABLE_SCHEM,  c2.relname AS PKTABLE_NAME,  a2.attname AS PKCOLUMN_NAME,  current_database() AS FKTABLE_CAT,  n1.nspname AS FKTABLE_SCHEM,  c1.relname AS FKTABLE_NAME,  a1.attname AS FKCOLUMN_NAME,  i::int2 AS KEY_SEQ,  CASE ref.confupdtype  WHEN 'c' THEN 0::int2  WHEN 'n' THEN 2::int2  WHEN 'd' THEN 4::int2  WHEN 'r' THEN 1::int2  ELSE 3::int2  END AS UPDATE_RULE,  CASE ref.confdeltype  WHEN 'c' THEN 0::int2  WHEN 'n' THEN 2::int2  WHEN 'd' THEN 4::int2  WHEN 'r' THEN 1::int2  ELSE 3::int2  END AS DELETE_RULE,  ref.conname AS FK_NAME,  cn.conname AS PK_NAME,  CASE  WHEN ref.condeferrable THEN  CASE  WHEN ref.condeferred THEN 5::int2  ELSE 6::int2  END  ELSE 7::int2  END AS DEFERRABILITY  FROM  ((((((((SELECT cn.oid, conrelid, conkey, confrelid, confkey,  GENERATE_SERIES(ARRAY_LOWER(conkey, 1), ARRAY_UPPER(conkey, 1)) AS i,  confupdtype, confdeltype, conname,  condeferrable, condeferred  FROM pg_catalog.pg_constraint cn,  pg_catalog.pg_class c,  pg_catalog.pg_namespace n  WHERE contype = 'f'  AND  conrelid = c.oid ";
        if (null != tableNameFilter && !tableNameFilter.equals("")) {
            foreignKeyQuery = foreignKeyQuery + " AND  relname = '" + tableNameFilter.toLowerCase() + "' ";
        }
        if (null != schemaNameFilter && !schemaNameFilter.equals("")) {
            foreignKeyQuery = foreignKeyQuery + " AND  n.nspname LIKE '" + schemaNameFilter + "' ";
        }
        foreignKeyQuery = foreignKeyQuery + " ) ref INNER JOIN pg_catalog.pg_class c1  ON c1.oid = ref.conrelid)  INNER JOIN pg_catalog.pg_namespace n1  ON  n1.oid = c1.relnamespace)  INNER JOIN pg_catalog.pg_attribute a1  ON  a1.attrelid = c1.oid  AND  a1.attnum = conkey[i])  INNER JOIN pg_catalog.pg_class c2  ON  c2.oid = ref.confrelid)  INNER JOIN pg_catalog.pg_namespace n2  ON  n2.oid = c2.relnamespace)  INNER JOIN pg_catalog.pg_attribute a2  ON  a2.attrelid = c2.oid  AND  a2.attnum = confkey[i])  LEFT OUTER JOIN pg_catalog.pg_constraint cn  ON cn.conrelid = ref.confrelid  AND cn.contype = 'p') ";
        if (null != foreignTableFilter && !foreignTableFilter.equals("")) {
            foreignKeyQuery = foreignKeyQuery + " WHERE c2.relname = '" + foreignTableFilter + "' ";
        }
        if (null != foreignSchemaFilter && !foreignSchemaFilter.equals("")) {
            foreignKeyQuery = null == foreignTableFilter || foreignTableFilter.equals("") ? foreignKeyQuery + " WHERE c2.relname = '" + foreignTableFilter + "' " : foreignKeyQuery + " AND c2.relname = '" + foreignTableFilter + "' ";
        }
        foreignKeyQuery = foreignKeyQuery + " ORDER BY ref.oid, ref.i";
        return foreignKeyQuery;
    }

    private static String BuildPrimaryKeysQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String tableFilter = restrictions.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String primaryKeyQuery = "SELECT current_database() AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  ct.relname AS TABLE_NAME,   a.attname AS COLUMN_NAME,   a.attnum AS KEY_SEQ,   ci.relname AS PK_NAME   FROM  pg_catalog.pg_namespace n,  pg_catalog.pg_class ct,  pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid  AND a.attrelid=ci.oid AND i.indisprimary  AND ct.relnamespace = n.oid ";
        if (null != tableFilter) {
            primaryKeyQuery = primaryKeyQuery + " AND ct.relname='" + tableFilter.toLowerCase() + "' ";
        }
        if (null != schemaFilter && !schemaFilter.equals("")) {
            primaryKeyQuery = primaryKeyQuery + " AND  n.nspname = '" + schemaFilter.toLowerCase() + "' ";
        }
        primaryKeyQuery = primaryKeyQuery + " ORDER BY table_name, pk_name, key_seq";
        return primaryKeyQuery;
    }

    private static String BuildProceduresQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String procFilter = restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String procQuery = "SELECT current_database() AS PROCEDURE_CAT,  n.nspname AS PROCEDURE_SCHEM,  p.proname AS PROCEDURE_NAME,  CAST(NULL AS VARCHAR(256)) AS NUM_INPUT_PARAMS,  CAST(NULL AS VARCHAR(256)) AS NUM_OUTPUT_PARAMS,  CAST(NULL AS VARCHAR(256)) AS NUM_RESULT_SETS,  d.description AS REMARKS,  2 AS PROCEDURE_TYPE,  p.proname || '_' || p.oid AS SPECIFIC_NAME FROM pg_catalog.pg_namespace n,  pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid) LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc') LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog') WHERE p.pronamespace=n.oid ";
        if (null != schemaFilter && !schemaFilter.equals("")) {
            procQuery = procQuery + " AND n.nspname LIKE '" + schemaFilter + "' ";
            if (null != procFilter && !procFilter.equals("")) {
                procQuery = procQuery + " AND p.proname LIKE '" + procFilter + "' ";
            }
        } else if (null != procFilter && !procFilter.equals("")) {
            procQuery = procQuery + " AND n.nspname LIKE '" + procFilter + "' ";
        }
        procQuery = procQuery + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, p.oid::text";
        return procQuery;
    }

    private static String BuildFunctionsQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String procFilter = restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String funcQuery = "SELECT routine_catalog AS FUNCTION_CAT,  routine_schema AS FUNCTION_SCHEM,  routine_name AS FUNCTION_NAME, CAST('' AS VARCHAR(256)) AS REMARKS,  0 AS FUNCTION_TYPE, specific_name AS SPECIFIC_NAME FROM INFORMATION_SCHEMA.ROUTINES";
        if (null != schemaFilter && !schemaFilter.equals("")) {
            funcQuery = funcQuery + " WHERE  routine_schema LIKE '" + schemaFilter + "' ";
            if (null != procFilter && !procFilter.equals("")) {
                funcQuery = funcQuery + " AND  routine_name LIKE '" + procFilter + "' ";
            }
        } else if (null != procFilter && !procFilter.equals("")) {
            funcQuery = funcQuery + " WHERE  routine_name LIKE '" + procFilter + "' ";
        }
        funcQuery = funcQuery + " ORDER BY routine_catalog, routine_schema, routine_name";
        return funcQuery;
    }

    private static String BuildProcedureColumnsQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String procFilter = restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String procColumnQuery = "SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CAST( '' AS VARCHAR(256)) AS COLUMN_NAME,  CAST(5 AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  WHEN '_float4' THEN 2003  WHEN 'timestamptz' THEN 93  WHEN '_aclitem' THEN 2003  WHEN '_text' THEN 2003  WHEN 'bytea' THEN -2  WHEN 'oid' THEN -5  WHEN 'name' THEN 12  WHEN '_int4' THEN 2003  WHEN '_int2' THEN 2003  ELSE 1111  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(p.prorettype, NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(p.prorettype, NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS BUFFER_LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF,  CAST(CASE  pg_catalog.format_type(p.prorettype, NULL) WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE, p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace  UNION ALL  SELECT current_database() AS PROCEDURE_CAT,  n.nspname as PROCEDURE_SCHEM,  proname AS PROCEDURE_NAME,  CAST( '' AS VARCHAR(256)) AS COLUMN_NAME,  CAST(1 AS SMALLINT) AS COLUMN_TYPE,  CAST(CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN -1  WHEN 'bit' THEN  12  WHEN 'boolean' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 7  WHEN 'real' THEN 7  WHEN 'float4' THEN 7  WHEN 'double precision' THEN 6  WHEN 'float8' THEN 6  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS DATA_TYPE,  pg_catalog.format_type(unnest(p.proargtypes), NULL) AS TYPE_NAME,  CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'text' THEN NULL  WHEN 'date' THEN NULL  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 10  WHEN 'int' THEN 10  WHEN 'int4' THEN 10  WHEN 'bigint' THEN 19  WHEN 'int8' THEN 19  WHEN 'decimal' THEN 38  WHEN 'real' THEN 24  WHEN 'float4' THEN 53  WHEN 'double precision' THEN 53  WHEN 'float8' THEN 53  WHEN 'float' THEN 53  END AS COLUMN_SIZE,  CASE pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN NULL  WHEN 'varchar' THEN NULL  WHEN 'character varying' THEN NULL  WHEN '\"char\"' THEN NULL  WHEN 'character' THEN NULL  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 6  WHEN 'timestamp' THEN 6  WHEN 'smallint' THEN 2  WHEN 'int2' THEN 2  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN 20  WHEN 'int8' THEN 20  WHEN 'decimal' THEN 8  WHEN 'real' THEN 4  WHEN 'float4' THEN 8  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN  8  END AS BUFFER_LENGTH,  CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS,  CAST(NULL AS SMALLINT) AS NUM_PREC_RADIX,  CAST(2 AS SMALLINT) AS NULLABLE,  CAST(''AS VARCHAR(256)) AS REMARKS,  NULL AS COLUMN_DEF, CAST(CASE  pg_catalog.format_type(unnest(p.proargtypes), NULL)  WHEN 'text' THEN - 1  WHEN 'bit' THEN  12  WHEN 'varchar' THEN 12  WHEN 'character varying' THEN  12  WHEN 'char' THEN  1  WHEN 'character' THEN  1  WHEN 'nchar' THEN NULL  WHEN 'bpchar' THEN NULL  WHEN 'nvarchar' THEN NULL  WHEN 'date' THEN 91  WHEN 'timestamp' THEN 93  WHEN 'smallint' THEN 5  WHEN 'int2' THEN 5  WHEN 'integer' THEN 4  WHEN 'int' THEN 4  WHEN 'int4' THEN 4  WHEN 'bigint' THEN -5  WHEN 'int8' THEN -5  WHEN 'decimal' THEN 3  WHEN 'real' THEN 7  WHEN 'float4' THEN 6  WHEN 'double precision' THEN 8  WHEN 'float8' THEN 8  WHEN 'float' THEN 6  WHEN 'numeric' THEN 2  END AS SMALLINT) AS SQL_DATA_TYPE,  CAST(NULL AS SMALLINT) AS SQL_DATETIME_SUB,  CAST(NULL AS SMALLINT) AS CHAR_OCTET_LENGTH,  CAST(0 AS SMALLINT) AS ORDINAL_POSITION,  CAST(''AS VARCHAR(256)) AS IS_NULLABLE,  p.proname || '_' || p.oid AS SPECIFIC_NAME  FROM pg_catalog.pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace";
        if (null != schemaFilter && !schemaFilter.equals("")) {
            procColumnQuery = procColumnQuery + " WHERE  n.nspname LIKE '" + schemaFilter + "' ";
            if (null != procFilter && !procFilter.equals("")) {
                procColumnQuery = procColumnQuery + " AND  proname LIKE '" + procFilter + "' ";
            }
        } else if (null != procFilter && !procFilter.equals("")) {
            procColumnQuery = procColumnQuery + " WHERE  proname LIKE '" + procFilter + "' ";
        }
        return procColumnQuery;
    }

    private static String BuildTablePriviledgesQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String tableFilter = restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append("CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT,");
        sb.append("n.nspname AS TABLE_SCHEM,");
        sb.append("c.relname AS TABLE_NAME,");
        sb.append("u.usename,");
        sb.append("c.relacl ");
        sb.append("FROM ");
        sb.append("pg_catalog.pg_namespace n, ");
        sb.append("pg_catalog.pg_class c, ");
        sb.append("pg_catalog.pg_user u ");
        sb.append("WHERE ");
        sb.append("c.relnamespace = n.oid");
        sb.append(" AND u.usesysid = c.relowner");
        sb.append(" AND c.relkind = 'r'");
        sb.append(" AND n.nspname LIKE '%'");
        sb.append(" AND c.relname LIKE '%'");
        if (null != schemaFilter && !schemaFilter.equals("")) {
            sb.append(" AND n.nspname LIKE '");
            sb.append(schemaFilter);
            sb.append("' ");
        }
        if (null != tableFilter && !tableFilter.equals("")) {
            sb.append(" AND c.relname LIKE '");
            sb.append(tableFilter);
            sb.append("' ");
        }
        sb.append(" ORDER BY nspname, relname");
        return sb.toString();
    }

    private static String BuildTablesQuery(Map<MetadataSourceColumnTag, String> restrictions) {
        String schemaFilter = restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String tableFilter = restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String tableTypeFilter = restrictions.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        String tableQuery = "SELECT * FROM( SELECT  CAST(current_database() AS VARCHAR(124)) AS TABLE_CAT, n.nspname AS TABLE_SCHEM,  c.relname AS TABLE_NAME, CAST( CASE c.relkind WHEN 'r' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM TABLE'  WHEN n.nspname = 'pg_toast' THEN 'SYSTEM TOAST TABLE' WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY TABLE'  ELSE 'TABLE'  END  WHEN 'v' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM VIEW'  WHEN n.nspname = 'pg_toast' THEN NULL  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY VIEW' ELSE 'VIEW'  END  WHEN 'i' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN 'SYSTEM INDEX'  WHEN n.nspname = 'pg_toast' THEN 'SYSTEM TOAST INDEX'  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY INDEX'  ELSE 'INDEX'  END  WHEN 'S' THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN NULL  WHEN n.nspname = 'pg_toast' THEN NULL  WHEN n.nspname ~ '^pg_' AND n.nspname != 'pg_toast' THEN 'TEMPORARY SEQUENCE'  ELSE 'SEQUENCE'  END  END  AS VARCHAR(124)) AS TABLE_TYPE, d.description AS REMARKS FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)WHERE c.relnamespace = n.oid ";
        if (null != schemaFilter && !schemaFilter.equals("")) {
            tableQuery = tableQuery + "AND n.nspname like '" + schemaFilter + "' ";
        } else if (null != tableFilter && !tableFilter.equals("")) {
            tableQuery = tableQuery + "AND n.nspname like current_schema() ";
        }
        if (null != tableFilter && !tableFilter.equals("")) {
            tableQuery = tableQuery + "AND c.relname like '" + tableFilter + "' ";
        }
        tableQuery = tableQuery + ") S ";
        if (null != tableTypeFilter && !tableTypeFilter.equals("")) {
            String tableTypesAsList = PGCatalogQueryBuilder.convertTableTypesListToInClause(tableTypeFilter);
            tableQuery = tableQuery + " WHERE TABLE_TYPE IN (" + tableTypesAsList + ") ";
        }
        tableQuery = tableQuery + "ORDER BY TABLE_TYPE, TABLE_CAT, TABLE_SCHEM, TABLE_NAME";
        return tableQuery;
    }

    private static String convertTableTypesListToInClause(String tableTypeFilter) {
        String[] tableList = tableTypeFilter.split(",");
        StringBuilder typeResult = new StringBuilder();
        if (tableList.length > 1) {
            for (int i = 0; i < tableList.length; ++i) {
                if (i != tableList.length - 1) {
                    typeResult.append("'").append(tableList[i]).append("'").append(", ");
                    continue;
                }
                typeResult.append("'").append(tableList[i]).append("'");
            }
        } else {
            typeResult.append("'").append(tableList[0]).append("'");
        }
        return typeResult.toString();
    }

    private static String PGNamespaceQueryBuilder() {
        return "SELECT n.nspname,    c.relname,    a.attname,    a.atttypid,    a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) AS attnotnull,    a.atttypmod,    a.attlen,    a.attnum,    pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS adsrc,    dsc.description,    t.typbasetype,    t.typtype,    c.relnameFROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE a.attnum > 0 AND NOT a.attisdropped  AND attname LIKE '%'  AND   (    c.relname LIKE 'pg_attribute'        OR    c.relname LIKE 'pg_type'  ) ORDER BY nspname,c.relname,attnum";
    }

    public static String PGAttNotNullBuilder(List<String> tableOID, List<String> colIndex) {
        StringBuilder str = new StringBuilder();
        str.append("SELECT a.attrelid, a.attnum, a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) FROM pg_catalog.pg_attribute a JOIN pg_catalog.pg_type t ON (a.atttypid = t.oid) WHERE ");
        for (int i = 0; i < tableOID.size(); ++i) {
            if (i > 0) {
                str.append(" OR ");
            }
            str.append("(a.attrelid = ");
            str.append(tableOID.get(i));
            str.append(" AND a.attnum = ");
            str.append(colIndex.get(i));
            str.append(")");
        }
        return str.toString();
    }

    private static String PGAttrDefBuilder(byte[] tableOID, byte[] colIndex) {
        return "SELECT 1 FROM pg_catalog.pg_attrdef WHERE adrelid = " + PGDataTypeUtilities.toUTF8String(tableOID) + " AND adnum = " + PGDataTypeUtilities.toUTF8String(colIndex) + " AND pg_catalog.pg_get_expr(adbin, adrelid) LIKE '%nextval(%' ";
    }

    private static String PGTypeNameBuilder(byte[] typeOID) {
        return "SELECT typname FROM pg_catalog.pg_type WHERE oid = " + PGDataTypeUtilities.toUTF8String(typeOID);
    }

    private static String PGRegProcBuilder() {
        return "SELECT typinput='array_in'::regproc, typtype FROM pg_catalog.pg_type WHERE typname = 'regproc'";
    }
}

