/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.exceptions.BadDefaultParamException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGBatchExecutionResults;
import com.amazon.redshift.dataengine.PGExecutionResults;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PGAbstractQueryExecutor
implements IQueryExecutor,
SocketCloseListener {
    protected List<PGMessagingContext> m_contexts = new ArrayList<PGMessagingContext>();
    protected int m_currentExecuteIndex = -1;
    protected boolean m_isDirectExecute;
    protected ExecutionResults m_results;
    protected PGClient m_client;
    protected ILogger m_log;
    protected PGJDBCStatement m_statement;
    protected ErrorException m_fatalException = null;
    protected int m_socketTimeoutMS;
    protected boolean m_batchRowCountExpected = false;
    private Map<Integer, TypeMetadata> m_setParameterMetadata = null;
    private Map<PGMessagingContext, List<Integer>> m_numericParamIndxs = new HashMap<PGMessagingContext, List<Integer>>();
    private List<Integer> m_parameterOIDs = new ArrayList<Integer>();
    protected boolean m_prepareStage = true;

    protected abstract int getParamCountForContext(PGMessagingContext var1);

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        this.m_client.cancelQuery();
        for (PGMessagingContext context : this.m_contexts) {
            context.m_isCanceled.set(true);
        }
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext context : this.m_contexts) {
            context.m_isCanceled.set(false);
        }
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext context : this.m_contexts) {
            context.closeOperation();
            context.removeSocketCloseListener(this);
        }
        this.m_results = null;
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (null == this.m_contexts) {
            return null;
        }
        this.m_results = this.m_contexts.get((int)0).m_batchMode ? new PGBatchExecutionResults(this.m_contexts, this.m_log, this.m_socketTimeoutMS) : new PGExecutionResults(this.m_contexts, this.m_currentExecuteIndex, this.m_log, this.m_statement.getExpectedResult(), this.m_socketTimeoutMS, this.m_batchRowCountExpected, this.m_prepareStage);
        return this.m_results;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> setParameterMetadata) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (!this.m_statement.isCallableStatement()) {
            boolean reprepareNeeded = false;
            boolean initialized = true;
            if (null == this.m_setParameterMetadata) {
                reprepareNeeded = true;
                initialized = false;
                this.m_setParameterMetadata = setParameterMetadata;
            }
            TypeMetadata paramMeta = null;
            int overallNbParams = 0;
            for (Map.Entry<PGMessagingContext, List<Integer>> curr : this.m_numericParamIndxs.entrySet()) {
                PGMessagingContext currCtx = curr.getKey();
                for (int index : curr.getValue()) {
                    short currentType = setParameterMetadata.get(index).getType();
                    short previousType = this.m_setParameterMetadata.get(index).getType();
                    if (initialized && currentType == previousType) continue;
                    reprepareNeeded = true;
                    paramMeta = setParameterMetadata.get(index);
                    this.m_setParameterMetadata.put(index, paramMeta);
                    int paramOid = PGDataTypeUtilities.SQLTypeToOid(paramMeta.getType());
                    this.m_parameterOIDs.set(overallNbParams + index, paramOid);
                    try {
                        if (1700 == paramOid) {
                            paramOid = 1043;
                        }
                        currCtx.m_parameterMetadata.set(index, PGDataTypeUtilities.createParameter(paramOid, index, currCtx));
                    }
                    catch (NumericOverflowException ex) {
                        LogUtilities.logFatal(ex, this.m_log);
                        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), ex.getMessage(), (Throwable)ex);
                    }
                }
                overallNbParams += currCtx.m_parameterMetadata.size();
            }
            if (reprepareNeeded) {
                try {
                    int currParamIndex = 0;
                    int nbParams = 0;
                    this.checkCancelled();
                    for (PGMessagingContext context : this.m_contexts) {
                        ArrayList<Integer> paramOIDs = null;
                        nbParams = this.getParamCountForContext(context);
                        if (0 == nbParams) continue;
                        paramOIDs = new ArrayList<Integer>();
                        for (int i = 0; i < nbParams; ++i) {
                            paramOIDs.add(this.m_parameterOIDs.get(currParamIndex));
                            ++currParamIndex;
                        }
                        this.m_client.reprepareStatement(context, paramOIDs, this.m_statement.getWarningListener());
                    }
                }
                catch (ErrorException e) {
                    this.m_setParameterMetadata = null;
                    throw e;
                }
            }
        }
    }

    @Override
    public void pushParamData(int parameterSet, ParameterInputValue value) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, parameterSet, value);
    }

    @Override
    public void socketClosed(ErrorException exception) {
        this.m_fatalException = exception;
    }

    protected List<ParameterMetadata> getMetadataForParameters(PGMessagingContext context) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ArrayList<ParameterMetadata> parameterColumnMetadata = new ArrayList();
        List<Integer> numericParamIndexForCurrCtx = this.m_numericParamIndxs.get(context);
        if (null == numericParamIndexForCurrCtx) {
            numericParamIndexForCurrCtx = new ArrayList<Integer>();
        }
        this.m_parameterOIDs.addAll(context.m_parameterOids);
        if (this.m_statement.isCallableStatement()) {
            int outPutType = PGDataTypeUtilities.oidToSQLType(context.getRowDescription().getFieldDescriptions()[0].getDataTypeObjectID());
            if (this.m_statement.hasReturnQuestionMark()) {
                PGParameterMetadata result = new PGParameterMetadata(1, ParameterType.OUTPUT, outPutType, context);
                parameterColumnMetadata.add(result);
                for (ParameterMetadata meta : context.m_parameterMetadata) {
                    PGParameterMetadata param = new PGParameterMetadata(meta.getParameterNumber() + 1, meta.getParameterType(), (int)meta.getTypeMetadata().getType(), context);
                    int paramIndex = meta.getParameterNumber();
                    parameterColumnMetadata.add(param);
                    if (2 != param.getTypeMetadata().getType() && 3 != param.getTypeMetadata().getType()) continue;
                    numericParamIndexForCurrCtx.add(paramIndex - 1);
                }
            } else {
                for (int i = 0; i < context.m_parameterMetadata.size(); ++i) {
                    ParameterMetadata meta = context.m_parameterMetadata.get(i);
                    PGParameterMetadata param = null;
                    int paramIndex = meta.getParameterNumber();
                    param = i == 0 ? new PGParameterMetadata(paramIndex + 1, ParameterType.INPUT_OUTPUT, (int)meta.getTypeMetadata().getType(), context) : new PGParameterMetadata(paramIndex + 1, meta.getParameterType(), (int)meta.getTypeMetadata().getType(), context);
                    parameterColumnMetadata.add(param);
                    if (2 != param.getTypeMetadata().getType() && 3 != param.getTypeMetadata().getType()) continue;
                    numericParamIndexForCurrCtx.add(paramIndex - 1);
                }
                if (parameterColumnMetadata.isEmpty()) {
                    PGParameterMetadata result = new PGParameterMetadata(1, ParameterType.OUTPUT, outPutType, context);
                    parameterColumnMetadata.add(result);
                }
            }
        } else {
            for (int i = 0; i < context.m_parameterMetadata.size(); ++i) {
                ParameterMetadata meta = context.m_parameterMetadata.get(i);
                int paramIndex = meta.getParameterNumber();
                if (2 != meta.getTypeMetadata().getType() && 3 != meta.getTypeMetadata().getType()) continue;
                numericParamIndexForCurrCtx.add(paramIndex - 1);
            }
            parameterColumnMetadata = context.m_parameterMetadata;
        }
        this.m_numericParamIndxs.put(context, numericParamIndexForCurrCtx);
        return parameterColumnMetadata;
    }

    protected void checkCancelled() throws ErrorException {
        for (PGMessagingContext context : this.m_contexts) {
            if (!context.m_isCanceled.get()) continue;
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_CANCELLED.name());
        }
    }
}

