/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SWarningListener;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.TypeNames;
import com.amazon.utilities.conversion.TypeConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PGDSIOverrideHelper {
    public static void checkValidParameterIndex(int validParameterNumber, int parameterIndex, PGJDBCStatement statement, SWarningListener Listener) throws SQLException {
        if (statement.hasReturnQuestionMark() && statement.isCallableStatement()) {
            ++validParameterNumber;
        }
        if (1 > parameterIndex || validParameterNumber < parameterIndex) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, (IWarningListener)Listener, ExceptionType.DEFAULT, String.valueOf(parameterIndex));
        }
    }

    public static synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale, SWarningListener m_warningListener, List<ParameterType> m_parameterTypes, Map<Integer, Integer> m_parameterScale, int registeredType, ArrayList<ParameterMetadata> m_parameterMetadata) throws SQLException {
        if (0 > scale) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SCALE, (IWarningListener)m_warningListener, ExceptionType.DEFAULT, String.valueOf(scale), "0");
        }
        if (ParameterType.INPUT == m_parameterTypes.get(parameterIndex - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_REGISTER_TYPE, (IWarningListener)m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(parameterIndex));
        }
        ParameterMetadata paramMeta = m_parameterMetadata.get(parameterIndex - 1);
        short paramType = paramMeta.getTypeMetadata().getType();
        if (!TypeConverter.canConvert(paramType, sqlType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex), TypeNames.getTypeName(sqlType));
        }
        if (TypeUtilities.isExactNumericType(sqlType)) {
            m_parameterScale.put(parameterIndex, scale);
        }
    }

    public static DataWrapper getOutputParameterValue(int parameterIndex, ResultSet resultSet, int registeredType, ArrayList<ParameterMetadata> m_parameterMetadata, int NOT_REGISTERED) throws SQLException {
        if (parameterIndex != 1) {
            return null;
        }
        if (null == resultSet) {
            return null;
        }
        resultSet.next();
        ParameterMetadata meta = m_parameterMetadata.get(0);
        DataWrapper dataWrapper = new DataWrapper();
        TypeMetadata tmeta = meta.getTypeMetadata();
        int SQLType2 = tmeta.getType();
        if (registeredType != NOT_REGISTERED && registeredType != SQLType2) {
            SQLType2 = registeredType;
        }
        switch (SQLType2) {
            case -5: {
                dataWrapper.setBigInt(resultSet.getLong(1));
                break;
            }
            case 4: {
                dataWrapper.setInteger(resultSet.getInt(1));
                break;
            }
            case 12: {
                dataWrapper.setVarChar(resultSet.getString(1));
                break;
            }
            case 5: {
                dataWrapper.setSmallInt(resultSet.getShort(1));
                break;
            }
            case 3: {
                dataWrapper.setDouble(resultSet.getDouble(1));
                break;
            }
            case 7: {
                dataWrapper.setReal(resultSet.getFloat(1));
                break;
            }
            case 8: {
                dataWrapper.setDouble(resultSet.getDouble(1));
                break;
            }
            case 16: {
                dataWrapper.setBoolean(resultSet.getBoolean(1));
                break;
            }
            case 1: {
                dataWrapper.setChar(resultSet.getString(1));
                break;
            }
            case 91: {
                dataWrapper.setDate(resultSet.getDate(1));
                break;
            }
            case 93: {
                dataWrapper.setTimestamp(resultSet.getTimestamp(1));
                break;
            }
            default: {
                dataWrapper.setVarChar(resultSet.getString(1));
            }
        }
        return dataWrapper;
    }

    public static synchronized void execute(ArrayList<ParameterMetadata> m_parameterMetadata, List<Boolean> m_parameterRegistered, ILogger m_logger, SWarningListener m_warningListener, ParameterMetadata output, int registeredType) throws SQLException {
        LogUtilities.logFunctionEntrance(m_logger, new Object[0]);
        if (m_parameterRegistered.contains(Boolean.FALSE)) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(exception, m_logger);
            throw exception;
        }
        if (output.getParameterType() == ParameterType.OUTPUT && output.getTypeMetadata().getType() != (short)registeredType) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException("INCONSISTENT TYPE REGISTERED", "EXPECTED java.sql.type=" + output.getTypeMetadata().getType() + " HOWEVER java.sql.type=" + registeredType + " REGISTERED", 0, ExceptionType.NON_TRANSIENT);
            LogUtilities.logError(exception, m_logger);
            throw exception;
        }
    }
}

