/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Close
extends AbstractOutboundMessage
implements PGConstants {
    private static byte CLOSE_TYPE_PORTAL = (byte)80;
    private static byte CLOSE_TYPE_PREPARED_STATEMENT = (byte)83;
    private final byte[] m_portalOrPreparedStatementName;
    private final CloseType m_type;

    public Close(byte[] portalOrPreparedStatementName, CloseType type, IPGLogger logger) {
        this.m_portalOrPreparedStatementName = portalOrPreparedStatementName;
        this.m_type = type;
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, byte[] sizebytes) {
        buffer.put((byte)67);
        buffer.put(sizebytes);
        switch (this.m_type) {
            case PORTAL: {
                buffer.put(CLOSE_TYPE_PORTAL);
                break;
            }
            case PREPARED_STATEMENT: {
                buffer.put(CLOSE_TYPE_PREPARED_STATEMENT);
            }
        }
        if (null != this.m_portalOrPreparedStatementName) {
            buffer.put(this.m_portalOrPreparedStatementName);
        }
        buffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 5 + (this.m_portalOrPreparedStatementName != null ? this.m_portalOrPreparedStatementName.length : 0) + 1;
    }

    public void logMessageContent(IPGLogger logger) {
        String typeName = this.m_type.name().toLowerCase();
        String portalorStatementName = null;
        if (null != this.m_portalOrPreparedStatementName) {
            portalorStatementName = new String(this.m_portalOrPreparedStatementName);
        }
        String message = "=>FE Close(" + typeName + "=" + portalorStatementName + ")";
        logger.logDebugExternal(message);
    }

    public static enum CloseType {
        PORTAL,
        PREPARED_STATEMENT;

    }
}

