/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.impl.DSIDriverSingleton;
import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.interfaces.IDriver;
import com.amazon.dsi.core.interfaces.IEnvironment;
import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.ConnSettingResponseMap;
import com.amazon.dsi.core.utilities.ConnectionSetting;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageBuilder;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.JDBCObjectFactory;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SWarningListener;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Pair;
import com.amazon.support.SettingReader;
import com.amazon.support.Warning;
import com.amazon.support.exceptions.ExceptionBuilder;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.support.exceptions.ExceptionUtilities;
import com.amazon.support.security.ICredentialFactory;
import com.amazon.utilities.FunctionID;
import com.amazon.utilities.PropertyTypeConverter;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class BaseConnectionFactory {
    public static final String URL_SEPARATOR = ":";
    public static final String CONNECTION_LOCALE_KEY = "Locale";
    public static ExceptionBuilder s_Messages = new ExceptionBuilder(1);

    protected boolean acceptsSubProtocol(String string) {
        String string2 = this.getSubProtocol();
        if (null == string2) {
            return false;
        }
        return string2.equals(string);
    }

    protected final boolean acceptsURL(String string, Properties properties) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, URL_SEPARATOR);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if ("jdbc".equals(string2) && this.acceptsSubProtocol(string3)) {
                int n = string.indexOf(string3) + string3.length() + 1;
                String string4 = "";
                if (n < string.length()) {
                    string4 = string.substring(n);
                }
                SettingReader.clearAllSettings();
                if (SettingReader.isSuccessfulLoad()) {
                    properties.putAll((Map<?, ?>)SettingReader.retrieveAllSettings());
                }
                return this.parseSubName(string4, properties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected abstract JDBCObjectFactory createJDBCObjectFactory();

    protected SConnection doConnect(Pair<IConnection, ConnSettingRequestMap> pair, String string) throws SQLException {
        assert (null != pair);
        IConnection iConnection = pair.key();
        IWarningListener iWarningListener = iConnection.getWarningListener();
        try {
            if (null == JDBCObjectFactory.getInstance()) {
                JDBCObjectFactory.setInstance(this.createJDBCObjectFactory());
            }
            ConnSettingResponseMap connSettingResponseMap = null;
            if (null == iWarningListener) {
                iWarningListener = new SWarningListener(iConnection.getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                iConnection.registerWarningListener(iWarningListener);
            }
            connSettingResponseMap = iConnection.updateConnectionSettings(pair.value());
            this.checkResponseMap(connSettingResponseMap, iWarningListener);
            iConnection.connect(pair.value());
            for (Warning warning : iWarningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            return JDBCObjectFactory.getInstance().createConnection(iConnection, string);
        }
        catch (Exception exception) {
            ILogger iLogger = null;
            try {
                iLogger = pair.key().getConnectionLog();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (null == iLogger) {
                throw ExceptionConverter.getInstance().toSQLException(exception, iWarningListener);
            }
            throw ExceptionConverter.getInstance().toSQLException(exception, iWarningListener, iLogger);
        }
    }

    protected Pair<IConnection, ConnSettingRequestMap> getConnection(Properties properties) throws SQLException {
        assert (null != properties);
        IDriver iDriver = DSIDriverSingleton.getInstance();
        SWarningListener sWarningListener = new SWarningListener(iDriver.getMessageSource(), FunctionID.BEFORE_CONNECTION);
        try {
            ILogger iLogger;
            this.mapJDBCtoODBCAuthentication(properties);
            this.saveLoggingAttributes(properties);
            PrintWriter printWriter = DriverManager.getLogWriter();
            if (null != printWriter) {
                SettingReader.storeAdditionalSetting("LogPrintWriter", printWriter);
            }
            if ((iLogger = iDriver.getDriverLog()) instanceof DSILogger) {
                ((DSILogger)iLogger).prepareSettings(((DSILogger)iLogger).getFileName());
            }
            IConnection iConnection = null;
            try {
                ICredentialFactory iCredentialFactory;
                long l = iDriver.getProperty(20).getLong();
                IEnvironment iEnvironment = iDriver.createEnvironment();
                iEnvironment.registerWarningListener(sWarningListener);
                iConnection = (l & 1L) != 0L ? ((iCredentialFactory = iDriver.createCredentialFactory()) != null ? iEnvironment.createConnection(iCredentialFactory.getLocalCredentials()) : iEnvironment.createConnection()) : iEnvironment.createConnection();
            }
            catch (Exception exception) {
                try {
                    throw ExceptionConverter.getInstance().toSQLException(exception, sWarningListener, iLogger);
                }
                catch (Exception exception2) {
                    throw exception;
                }
            }
            ConnSettingRequestMap connSettingRequestMap = PropertyTypeConverter.toConnSettingRequestMap(properties);
            SettingReader.storeSettings(properties);
            if (connSettingRequestMap.containsKey(CONNECTION_LOCALE_KEY)) {
                Variant variant = connSettingRequestMap.getProperty(CONNECTION_LOCALE_KEY);
                iConnection.setLocale(ExceptionUtilities.createLocale(variant.getString()));
            }
            return new Pair<IConnection, ConnSettingRequestMap>(iConnection, connSettingRequestMap);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, sWarningListener);
        }
    }

    protected abstract String getSubProtocol();

    protected abstract boolean parseSubName(String var1, Properties var2);

    private void checkResponseMap(ConnSettingResponseMap connSettingResponseMap, IWarningListener iWarningListener) throws SQLException {
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Iterator<String> iterator = connSettingResponseMap.getKeysIterator();
        while (iterator.hasNext()) {
            charSequence = iterator.next();
            ConnectionSetting connectionSetting = connSettingResponseMap.getProperty((String)charSequence);
            if (connectionSetting.isRequired()) {
                arrayList.add((String)charSequence);
                continue;
            }
            if (connectionSetting.isOptional()) {
                arrayList2.add((String)charSequence);
                continue;
            }
            arrayList3.add((String)charSequence);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        charSequence = new StringBuilder(JDBCMessageBuilder.getMessage(JDBCMessageKey.REQUIRED_KEYS_MSG, iWarningListener, false, false));
        ((StringBuilder)charSequence).append(": ");
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)charSequence).append(iterator.next());
            if (!iterator.hasNext()) continue;
            ((StringBuilder)charSequence).append(", ");
        }
        if (!arrayList2.isEmpty()) {
            ((StringBuilder)charSequence).append("; ");
            ((StringBuilder)charSequence).append(JDBCMessageBuilder.getMessage(JDBCMessageKey.OPTIONAL_KEYS_MSG, iWarningListener, false, false));
            ((StringBuilder)charSequence).append(": ");
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)charSequence).append(", ");
            }
        }
        if (!arrayList3.isEmpty()) {
            ((StringBuilder)charSequence).append("; ");
            ((StringBuilder)charSequence).append(JDBCMessageBuilder.getMessage(JDBCMessageKey.PROCESSED_KEYS_MSG, iWarningListener, false, false));
            ((StringBuilder)charSequence).append(": ");
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)charSequence).append(", ");
            }
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_REFUSED, iWarningListener, ExceptionType.NON_TRANSIENT_CONNECTION, ((StringBuilder)charSequence).toString());
    }

    private void mapJDBCtoODBCAuthentication(Properties properties) {
        Object object;
        IDriver iDriver = DSIDriverSingleton.getInstance();
        assert (null != iDriver);
        try {
            object = iDriver.getProperty(1000);
            if (1 != ((Variant)object).getShort()) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        object = properties.keys();
        while (object.hasMoreElements()) {
            String string;
            String string2 = (String)object.nextElement();
            if (string2.equalsIgnoreCase("USER")) {
                string = properties.getProperty(string2);
                properties.remove(string2);
                properties.setProperty("UID", string);
                continue;
            }
            if (!string2.equalsIgnoreCase("PASSWORD")) continue;
            string = properties.getProperty(string2);
            properties.remove(string2);
            properties.setProperty("PWD", string);
        }
    }

    private void saveLoggingAttributes(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.regionMatches(true, 0, "log", 0, 3)) continue;
            SettingReader.storeSetting(string, properties.get(string).toString());
        }
    }
}

