/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dsi.dataengine.impl;

import com.amazon.dsi.dataengine.impl.DSIArray;
import com.amazon.dsi.dataengine.interfaces.IArray;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.support.exceptions.ErrorException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DSISimpleArray
extends DSIArray {
    protected Object m_array;
    protected int m_length;
    private IColumn m_arrayMetadata;
    private IColumn m_nestedMetadata;

    public DSISimpleArray(Object object, IColumn iColumn, IColumn iColumn2) {
        if (!object.getClass().isArray()) {
            throw new ClassCastException("Not an array: " + object.getClass());
        }
        this.m_arrayMetadata = iColumn;
        this.m_nestedMetadata = iColumn2;
        this.m_array = object;
        this.m_length = Array.getLength(object);
    }

    @Override
    public Object createArray(long l, int n) throws ErrorException {
        if (0L > l) {
            throw new IndexOutOfBoundsException(String.valueOf(l));
        }
        int n2 = this.m_length;
        if (l >= (long)n2) {
            if (this.isMultidimensional()) {
                return new DSISimpleArray[0];
            }
            return Array.newInstance(this.m_array.getClass().getComponentType(), 0);
        }
        int n3 = (int)l;
        int n4 = n2 - n3;
        if (-1L != (long)n && n < n4) {
            n4 = n;
        }
        Object object = this.m_array;
        if (this.isMultidimensional()) {
            DSISimpleArray[] dSISimpleArrayArray = new DSISimpleArray[n4];
            IColumn iColumn = this.getArrayColumn();
            IColumn iColumn2 = this.getNestedColumn();
            for (int i = 0; i < n4; ++i) {
                Object object2 = Array.get(object, n3 + i);
                dSISimpleArrayArray[i] = new DSISimpleArray(object2, iColumn, iColumn2);
            }
            return dSISimpleArrayArray;
        }
        Class<?> clazz = object.getClass().getComponentType();
        Object object3 = Array.newInstance(clazz, n4);
        System.arraycopy(object, n3, object3, 0, n4);
        return object3;
    }

    @Override
    public IColumn getBaseColumn() {
        if (this.isMultidimensional()) {
            return this.getArrayColumn();
        }
        return this.getNestedColumn();
    }

    @Override
    protected Iterator<?> createIterator(long l, int n) {
        int n2 = this.m_length;
        if (l >= (long)n2) {
            return Collections.emptyList().iterator();
        }
        int n3 = (int)l;
        int n4 = n2 - n3;
        if (-1L != (long)n && n < n4) {
            n4 = n;
        }
        return new DSISimpleArrayIterator(this.m_array, n3, n4);
    }

    protected IColumn getArrayColumn() {
        return this.m_arrayMetadata;
    }

    protected IColumn getNestedColumn() {
        return this.m_nestedMetadata;
    }

    protected boolean isMultidimensional() {
        return this.m_array.getClass().getComponentType().isArray();
    }

    @Override
    public String getStringRepresentation() {
        return this.toString();
    }

    protected final class DSISimpleArrayIterator
    implements Iterator<Object> {
        private int m_offset;
        private int m_count;
        private Object m_data;
        private boolean m_isNested;

        public DSISimpleArrayIterator(Object object, int n, int n2) {
            this.m_data = object;
            this.m_offset = n;
            this.m_count = n2;
            this.m_isNested = DSISimpleArray.this.isMultidimensional();
        }

        @Override
        public boolean hasNext() {
            return 0 < this.m_count;
        }

        @Override
        public Object next() {
            if (0 >= this.m_count) {
                throw new NoSuchElementException();
            }
            --this.m_count;
            Object object = Array.get(this.m_data, this.m_offset++);
            assert (!(object instanceof IArray)) : "IArray provided.";
            assert (!(object instanceof java.sql.Array)) : "java.sql.Array provided.";
            if (!this.m_isNested) {
                return object;
            }
            return new DSISimpleArray(object, DSISimpleArray.this.getArrayColumn(), DSISimpleArray.this.getNestedColumn());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

