/*
 * Decompiled with CFR 0.152.
 */
package boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class App {
    private static File[] podjars = new File[0];
    private static File[] corejars = new File[0];
    private static File[] workerjars = new File[0];
    private static File bootdir = null;
    private static File aetherfile = null;
    private static HashMap<String, File[]> depsCache = null;
    private static String cljversion = null;
    private static String bootversion = null;
    private static String localrepo = null;
    private static String appversion = null;
    private static String channel = "RELEASE";
    private static String booturl = "https://github.com/boot-clj/boot";
    private static ClojureRuntimeShim aethershim = null;
    private static final String aetherjar = "aether.uber.jar";
    private static final AtomicLong counter = new AtomicLong(0L);
    private static final ExecutorService ex = Executors.newCachedThreadPool();

    private static long nextId() {
        return counter.addAndGet(1L);
    }

    public static File getBootDir() {
        return bootdir;
    }

    public static String getVersion() {
        return appversion;
    }

    public static String getBootVersion() {
        return bootversion;
    }

    public static String propComment() {
        return booturl;
    }

    private static String jarVersion(File f, String prefix) throws Exception {
        String n = f.getName();
        if (!n.startsWith(prefix)) {
            return null;
        }
        return n.substring(prefix.length()).replaceAll(".jar$", "");
    }

    private static Properties writeProps(File f) throws Exception {
        ClojureRuntimeShim a = App.aetherShim();
        Properties p = new Properties();
        String c = cljversion;
        String t = null;
        if (c == null) {
            c = "1.6.0";
        }
        if (bootversion != null) {
            p.setProperty("BOOT_VERSION", bootversion);
        } else {
            for (File x : App.resolveDepJars(a, "boot", channel, c)) {
                t = App.jarVersion(x, "boot-");
                if (null == t) continue;
                p.setProperty("BOOT_VERSION", t);
            }
        }
        p.setProperty("BOOT_CLOJURE_VERSION", c);
        try (FileOutputStream file = new FileOutputStream(f);){
            p.store(file, App.propComment());
        }
        return p;
    }

    private static boolean isWindows() throws Exception {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProps(File f, boolean create) throws Exception {
        FileLock lock = null;
        if (!App.isWindows() && f.exists()) {
            lock = new RandomAccessFile(f, "rw").getChannel().lock();
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(f));
            if (p.getProperty("BOOT_CLOJURE_VERSION") == null || p.getProperty("BOOT_VERSION") == null) {
                throw new Exception("missing info");
            }
            Properties properties = p;
            return properties;
        }
        catch (Throwable e) {
            if (!create) {
                Properties properties = null;
                return properties;
            }
            Properties properties = App.writeProps(f);
            return properties;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private static HashMap<String, File[]> seedCache() throws Exception {
        if (depsCache != null) {
            return depsCache;
        }
        ClojureRuntimeShim a = App.aetherShim();
        HashMap<String, File[]> cache = new HashMap<String, File[]>();
        cache.put("boot/pod", App.resolveDepJars(a, "boot/pod"));
        cache.put("boot/core", App.resolveDepJars(a, "boot/core"));
        cache.put("boot/worker", App.resolveDepJars(a, "boot/worker"));
        depsCache = cache;
        return depsCache;
    }

    private static Object validateCache(File f, Object cache) throws Exception {
        Iterator iterator = ((HashMap)cache).values().iterator();
        while (iterator.hasNext()) {
            File[] fs;
            for (File d : fs = (File[])iterator.next()) {
                if (d.exists() && f.lastModified() >= d.lastModified()) continue;
                throw new Exception("dep jar doesn't exist");
            }
        }
        return cache;
    }

    private static Object writeCache(File f, Object m) throws Exception {
        try (FileOutputStream file = new FileOutputStream(f);){
            new ObjectOutputStream(file).writeObject(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readCache(File f) throws Exception {
        FileLock lock = null;
        if (!App.isWindows()) {
            lock = new RandomAccessFile(f, "rw").getChannel().lock();
        }
        try {
            long max = 64800000L;
            long age = System.currentTimeMillis() - f.lastModified();
            if (age > max) {
                throw new Exception("cache age exceeds TTL");
            }
            Object object = App.validateCache(f, new ObjectInputStream(new FileInputStream(f)).readObject());
            return object;
        }
        catch (Throwable e) {
            Object object = App.writeCache(f, App.seedCache());
            return object;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    public static ClojureRuntimeShim newShim(File[] jarFiles) throws Exception {
        File[] hooks;
        URL[] urls = new URL[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            urls[i] = jarFiles[i].toURI().toURL();
        }
        URLClassLoader cl = new URLClassLoader(urls, App.class.getClassLoader());
        ClojureRuntimeShim rt = ClojureRuntimeShim.newRuntime((ClassLoader)cl);
        for (File hook : hooks = new File[]{new File(bootdir, "boot-shim.clj"), new File("boot-shim.clj")}) {
            if (!hook.exists()) continue;
            rt.invoke("clojure.core/load-file", (Object)hook.getPath());
        }
        rt.require(new String[]{"boot.pod"});
        rt.invoke("boot.pod/seal-app-classloader");
        return rt;
    }

    public static ClojureRuntimeShim newPod() throws Exception {
        return App.newShim(podjars);
    }

    public static ClojureRuntimeShim newPod(File[] jarFiles) throws Exception {
        int i;
        File[] files = new File[jarFiles.length + podjars.length];
        for (i = 0; i < podjars.length; ++i) {
            files[i] = podjars[i];
        }
        for (i = 0; i < jarFiles.length; ++i) {
            files[i + App.podjars.length] = jarFiles[i];
        }
        return App.newShim(files);
    }

    private static ClojureRuntimeShim aetherShim() throws Exception {
        if (aethershim == null) {
            App.ensureResourceFile(aetherjar, aetherfile);
            aethershim = App.newShim(new File[]{aetherfile});
        }
        return aethershim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResource(String resource, File outfile) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream(resource);
        FileOutputStream out = new FileOutputStream(outfile);
        int n = 0;
        byte[] buf = new byte[4096];
        try {
            while ((n = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, n);
            }
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
    }

    public static void ensureResourceFile(String r, File f) throws Exception {
        if (!f.exists()) {
            App.extractResource(r, f);
        }
    }

    public static File[] resolveDepJars(ClojureRuntimeShim shim, String sym) {
        return App.resolveDepJars(shim, sym, bootversion, cljversion);
    }

    public static File[] resolveDepJars(ClojureRuntimeShim shim, String sym, String bootversion, String cljversion) {
        shim.require(new String[]{"boot.aether"});
        if (localrepo != null) {
            shim.invoke("boot.aether/set-local-repo!", (Object)localrepo);
        }
        shim.invoke("boot.aether/update-always!");
        return (File[])shim.invoke("boot.aether/resolve-dependency-jars", (Object)sym, (Object)bootversion, (Object)cljversion);
    }

    public static Future<ClojureRuntimeShim> newShimFuture(final File[] jars) throws Exception {
        return ex.submit(new Callable(){

            public ClojureRuntimeShim call() throws Exception {
                return App.newShim(jars);
            }
        });
    }

    public static Future<ClojureRuntimeShim> newCore() throws Exception {
        return App.newShimFuture(corejars);
    }

    public static Future<ClojureRuntimeShim> newWorker() throws Exception {
        return App.newShimFuture(workerjars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int runBoot(Future<ClojureRuntimeShim> core, Future<ClojureRuntimeShim> worker, String[] args) throws Exception {
        Iterator iterator;
        int n;
        ConcurrentLinkedQueue hooks = new ConcurrentLinkedQueue();
        try {
            if (localrepo != null) {
                worker.get().require(new String[]{"boot.aether"});
                worker.get().invoke("boot.aether/set-local-repo!", (Object)localrepo);
            }
            core.get().require(new String[]{"boot.main"});
            core.get().invoke("boot.main/-main", (Object)App.nextId(), (Object)worker.get(), hooks, (Object)args);
            n = -1;
            iterator = hooks.iterator();
        }
        catch (Throwable t) {
            try {
                int n2 = t instanceof Exit ? Integer.parseInt(t.getMessage()) : -2;
                return n2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                for (Runnable h : hooks) {
                    h.run();
                }
                try {
                    core.get().invoke("clojure.core/shutdown-agents");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        while (iterator.hasNext()) {
            Runnable h = (Runnable)iterator.next();
            h.run();
        }
        try {
            core.get().invoke("clojure.core/shutdown-agents");
            return n;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return n;
    }

    public static void usage() throws Exception {
        System.out.printf("Boot App Version: %s\n", appversion);
        System.out.printf("Boot Lib Version: %s\n", bootversion);
        System.out.printf("Clojure Version:  %s\n", cljversion);
    }

    public static String readVersion() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = cl.getResourceAsStream("boot/base/version.properties");
        Properties p = new Properties();
        p.load(in);
        return p.getProperty("version");
    }

    public static Map<String, String> latestReleaseTag() throws Exception {
        Future<ClojureRuntimeShim> worker = App.newWorker();
        worker.get().require(new String[]{"boot.github"});
        return (Map)worker.get().invoke("boot.github/latest-boot-release");
    }

    public static void printVersion() throws Exception {
        Properties p = new Properties();
        p.setProperty("BOOT_VERSION", bootversion);
        p.setProperty("BOOT_CLOJURE_VERSION", cljversion);
        p.store(System.out, App.propComment());
        System.err.printf("#App version: %s\n", appversion);
    }

    public static void main(String[] args) throws Exception {
        String dir_l;
        appversion = App.readVersion();
        localrepo = System.getenv("BOOT_LOCAL_REPO");
        String bhome = System.getenv("BOOT_HOME");
        String homed = System.getProperty("user.home");
        String uname = System.getProperty("user.name");
        String boot_v = System.getenv("BOOT_VERSION");
        String clj_v = System.getenv("BOOT_CLOJURE_VERSION");
        String asroot = System.getenv("BOOT_AS_ROOT");
        boolean isUpdate = false;
        if (uname.equals("root") && (asroot == null || !asroot.equals("yes"))) {
            throw new Exception("refusing to run as root (set BOOT_AS_ROOT=yes env var to force)");
        }
        String string = dir_l = localrepo == null ? "boot/default" : "boot/custom" + new File(localrepo).getCanonicalFile().getPath();
        if (clj_v != null) {
            cljversion = clj_v;
        }
        if (boot_v != null) {
            bootversion = boot_v;
        }
        bootdir = bhome != null ? new File(bhome) : new File(new File(homed), ".boot");
        File bootcache = new File(bootdir, "cache");
        bootcache.mkdirs();
        File projectprops = new File("boot.properties");
        File bootprops = new File(bootcache, "boot.properties");
        File jardir = new File(new File(bootcache, "lib"), appversion);
        aetherfile = new File(jardir, aetherjar);
        jardir.mkdirs();
        if (args.length > 0 && (args[0].equals("-u") || args[0].equals("--update"))) {
            isUpdate = true;
            Properties p = App.writeProps(bootprops);
            p.store(System.out, App.propComment());
            System.err.printf("#App version: %s\n", appversion);
        }
        if (cljversion == null || bootversion == null) {
            Properties q = App.readProps(bootprops, true);
            Properties p = App.readProps(projectprops, false);
            Properties properties = p = p == null ? q : p;
            if (cljversion == null) {
                cljversion = p.getProperty("BOOT_CLOJURE_VERSION");
            }
            if (bootversion == null) {
                bootversion = p.getProperty("BOOT_VERSION");
            }
        }
        if (args.length > 0 && (args[0].equals("-V") || args[0].equals("--version"))) {
            App.printVersion();
            System.exit(0);
        }
        File cachedir = new File(new File(new File(new File(bootcache, "cache"), dir_l), cljversion), bootversion);
        File cachefile = new File(cachedir, "deps.cache");
        cachedir.mkdirs();
        HashMap cache = (HashMap)App.readCache(cachefile);
        podjars = (File[])cache.get("boot/pod");
        corejars = (File[])cache.get("boot/core");
        workerjars = (File[])cache.get("boot/worker");
        if (!isUpdate) {
            Thread shutdown = new Thread(){

                @Override
                public void run() {
                    ex.shutdown();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdown);
            System.exit(App.runBoot(App.newCore(), App.newWorker(), args));
        } else {
            try {
                Map<String, String> release = App.latestReleaseTag();
                if (appversion.compareTo(release.get("tag")) < 0) {
                    System.err.printf("#New boot executable available:\n", new Object[0]);
                    System.err.printf("#%s\n", release.get("url"));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public static class Exit
    extends Exception {
        public Exit(String m) {
            super(m);
        }

        public Exit(String m, Throwable c) {
            super(m, c);
        }
    }
}

