(ns boot-figwheel.core
  {:boot/export-tasks true}
  (:require
   [boot.core :as boot :refer [deftask boot]]
   [boot.util]
   [boot.file]
   [boot-figwheel.config :refer :all]
   ))

(def ^:dynamic *target-path* "target")

(deftask ^{:style/indent [0]}
  figwheel
  [c config        CONFIG edn   "figwheel config data or config constructor symbol"
   a autobuild-ids IDS    [str] "autobuild ids"
   o once-ids      IDS    [str] "build-once ids"
   t target-path   PATH   str   "target path"]
  (require '[figwheel-sidecar.repl-api :refer :all])
  (fn [next-task]
    (fn [fileset]
      (let [config (cond
                     (symbol? config) ((resolve config))
                     :else            config)
            config (update-fw-config config (or target-path *target-path*))
            builds (:builds config)]
        (apply (resolve 'start-figwheel!) config
          (or autobuild-ids (if (map? builds)
                              (into [] (comp (map key) (map name)) builds)
                              (mapv :id builds))))
        (when (and once-ids ((resolve 'figwheel-running?)))
          (apply (resolve 'build-once) once-ids))
        (next-task fileset)))))
