/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc.UInts;

import ai.z7.blockchain_misc.UInts.Arrays;
import ai.z7.blockchain_misc.UInts.UInt;
import ai.z7.blockchain_misc.UInts.UInt128;
import java.math.BigInteger;

public final class UInt256
extends UInt<UInt256> {
    static final int MAX_WIDTH = 8;
    public static UInt256 MAX_VALUE = new UInt256(Arrays.maxValue(8));
    public static UInt256 ZERO = new UInt256(Arrays.ZERO);
    public static UInt256 ONE = new UInt256(Arrays.ONE);
    public static UInt256 TWO = new UInt256(Arrays.TWO);

    public UInt256(int[] nArray) {
        super(nArray, 8);
    }

    public UInt256(byte[] byArray) {
        super(byArray, MAX_VALUE);
    }

    public UInt256(UInt128 uInt128) {
        super(uInt128, 8);
    }

    public UInt256(String string) {
        this(string, 10);
    }

    public UInt256(String string, int n) {
        super(string, n, 8);
    }

    public UInt256(BigInteger bigInteger) {
        super(bigInteger, 8);
    }

    public UInt256(long l) {
        super(l);
    }

    @Override
    public UInt256 not() {
        return new UInt256(Arrays.not(this.ints, UInt256.MAX_VALUE.ints));
    }

    @Override
    public UInt256 and(UInt256 uInt256) {
        return new UInt256(Arrays.and(this.ints, uInt256.ints));
    }

    @Override
    public UInt256 or(UInt256 uInt256) {
        return new UInt256(Arrays.or(this.ints, uInt256.ints));
    }

    @Override
    public UInt256 xor(UInt256 uInt256) {
        return new UInt256(Arrays.xor(this.ints, uInt256.ints));
    }

    @Override
    public UInt256 setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return 8 <= n >>> 5 ? this : new UInt256(Arrays.setBit(this.ints, n));
    }

    @Override
    public UInt256 clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return this.ints.length <= n >>> 5 ? this : new UInt256(Arrays.clearBit(this.ints, n));
    }

    @Override
    public UInt256 flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return 8 <= n >>> 5 ? this : new UInt256(Arrays.flipBit(this.ints, n));
    }

    @Override
    public UInt256 shiftLeft(int n) {
        return new UInt256(0 < n ? Arrays.lshift(this.ints, n, 8) : Arrays.rshift(this.ints, -n, 8));
    }

    @Override
    public UInt256 shiftRight(int n) {
        return new UInt256(0 < n ? Arrays.rshift(this.ints, n, 8) : Arrays.lshift(this.ints, -n, 8));
    }

    @Override
    public UInt256 inc() {
        return new UInt256(Arrays.inc(this.ints, 8));
    }

    @Override
    public UInt256 dec() {
        return this.isZero() ? MAX_VALUE : new UInt256(Arrays.dec(this.ints));
    }

    @Override
    public UInt256 add(UInt256 uInt256) {
        return this.isZero() ? uInt256 : (uInt256.isZero() ? this : new UInt256(Arrays.add(this.ints, uInt256.ints, 8)));
    }

    @Override
    public UInt256 addmod(UInt256 uInt256, UInt256 uInt2562) {
        if (uInt2562.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero() && uInt256.isZero()) {
            return ZERO;
        }
        return new UInt256(Arrays.addmod(this.ints, uInt256.ints, uInt2562.ints));
    }

    @Override
    public UInt256 subtract(UInt256 uInt256) {
        if (uInt256.isZero()) {
            return this;
        }
        int n = this.compareTo(uInt256);
        return n == 0 ? ZERO : new UInt256(n < 0 ? Arrays.subgt(this.ints, uInt256.ints, UInt256.MAX_VALUE.ints) : Arrays.sub(this.ints, uInt256.ints));
    }

    @Override
    public UInt256 multiply(UInt256 uInt256) {
        if (this.ints.length == 0 || uInt256.ints.length == 0) {
            return ZERO;
        }
        return new UInt256(Arrays.multiply(this.ints, uInt256.ints, 8));
    }

    @Override
    public UInt256 mulmod(UInt256 uInt256, UInt256 uInt2562) {
        if (uInt2562.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        return new UInt256(Arrays.mulmod(this.ints, uInt256.ints, uInt2562.ints));
    }

    @Override
    public UInt256 pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (n == 0) {
            return ONE;
        }
        if (this.isZero()) {
            return this;
        }
        return n == 1 ? this : new UInt256(Arrays.pow(this.ints, this.getLowestSetBit(), n, 8));
    }

    @Override
    public UInt256 divide(UInt256 uInt256) {
        if (uInt256.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero()) {
            return ZERO;
        }
        int n = this.compareTo(uInt256);
        return n < 0 ? ZERO : (n == 0 ? ONE : new UInt256(Arrays.divide(this.ints, uInt256.ints)));
    }

    @Override
    public UInt256 mod(UInt256 uInt256) {
        if (uInt256.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero()) {
            return ZERO;
        }
        int n = this.compareTo(uInt256);
        return n < 0 ? this : (n == 0 ? ZERO : new UInt256(Arrays.mod(this.ints, uInt256.ints)));
    }

    public UInt256[] divmod(UInt256 uInt256) {
        if (uInt256.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero()) {
            return new UInt256[]{ZERO, ZERO};
        }
        int n = this.compareTo(uInt256);
        if (n < 0) {
            return new UInt256[]{ZERO, this};
        }
        if (n == 0) {
            return new UInt256[]{ONE, ZERO};
        }
        int[][] nArray = Arrays.divmod(this.ints, uInt256.ints);
        return new UInt256[]{new UInt256(nArray[0]), new UInt256(nArray[1])};
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BigInteger) {
            return Arrays.compare(this.ints, (BigInteger)object, 8) == 0;
        }
        return super.equals(object);
    }
}

