/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class TUID {
    private static final long START_EPOCH = TUID.startEpochTime();
    private static final AtomicLong lastTimestamp = new AtomicLong(0L);
    private static final long NODE_CURRENT = TUID.makeNode();

    private static long startEpochTime() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1, 1582);
        calendar.set(2, 9);
        calendar.set(5, 15);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    private static long makeMSB(long l) {
        long l2 = 0L;
        l2 |= (0xFFFFFFFFL & l) << 32;
        l2 |= (0xFFFF00000000L & l) >>> 16;
        l2 |= (0xFFF000000000000L & l) >>> 48;
        return l2 |= 0x1000L;
    }

    public static long toTimestamp(UUID uUID) {
        if (uUID == null || uUID.version() != 1) {
            throw new IllegalArgumentException("Can only retrieve the unix timestamp for v1-like UUIDs");
        }
        long l = uUID.timestamp();
        return l / 10000L + START_EPOCH;
    }

    static long fromTimestamp(long l) {
        return (l - START_EPOCH) * 10000L;
    }

    private static long millisOf(long l) {
        return l / 10000L;
    }

    private static long getCurrentTimestamp() {
        long l;
        while (true) {
            long l2;
            long l3;
            if ((l3 = TUID.fromTimestamp(System.currentTimeMillis())) > (l2 = lastTimestamp.get())) {
                if (!lastTimestamp.compareAndSet(l2, l3)) continue;
                return l3;
            }
            long l4 = TUID.millisOf(l2);
            if (TUID.millisOf(l3) < TUID.millisOf(l2)) {
                return lastTimestamp.incrementAndGet();
            }
            l = l2 + 1L;
            if (TUID.millisOf(l) == l4 && lastTimestamp.compareAndSet(l2, l)) break;
        }
        return l;
    }

    private static Set<String> getAllLocalAddresses() {
        InetAddress[] inetAddressArray;
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            object = InetAddress.getLocalHost();
            hashSet.add(((InetAddress)object).toString());
            hashSet.add(((InetAddress)object).getCanonicalHostName());
            inetAddressArray = InetAddress.getAllByName(((InetAddress)object).getCanonicalHostName());
            if (inetAddressArray != null) {
                for (InetAddress inetAddress : inetAddressArray) {
                    hashSet.add(inetAddress.toString());
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                inetAddressArray = ((NetworkInterface)object.nextElement()).getInetAddresses();
                while (inetAddressArray.hasMoreElements()) {
                    hashSet.add(((InetAddress)inetAddressArray.nextElement()).toString());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return hashSet;
    }

    private static void update(MessageDigest messageDigest, String string) {
        if (string != null) {
            messageDigest.update(string.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static String getProcessID() {
        Object object;
        Integer n = null;
        try {
            object = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            n = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == null) {
            n = new Random().nextInt();
        }
        int n2 = (object = TUID.class.getClassLoader()) != null ? System.identityHashCode(object) : 0;
        return Integer.toHexString(n) + Integer.toHexString(n2);
    }

    private static long makeNode() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            for (String object2 : TUID.getAllLocalAddresses()) {
                TUID.update(messageDigest, object2);
            }
            Properties properties = System.getProperties();
            TUID.update(messageDigest, properties.getProperty("java.vendor"));
            TUID.update(messageDigest, properties.getProperty("java.vendor.url"));
            TUID.update(messageDigest, properties.getProperty("java.version"));
            TUID.update(messageDigest, properties.getProperty("os.arch"));
            TUID.update(messageDigest, properties.getProperty("os.name"));
            TUID.update(messageDigest, properties.getProperty("os.version"));
            TUID.update(messageDigest, TUID.getProcessID());
            byte[] byArray = messageDigest.digest();
            long l = 0L;
            for (int i = 0; i < 6; ++i) {
                l |= (0xFFL & (long)byArray[i]) << i * 8;
            }
            return l | 0x10000000000L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    private static long makeClockSeqAndNode() {
        long l = System.nanoTime();
        long l2 = 0L;
        l2 |= (l & 0x3FFFL) << 48;
        l2 |= Long.MIN_VALUE;
        return l2 |= NODE_CURRENT;
    }

    public static UUID timeUID() {
        return new UUID(TUID.makeMSB(TUID.getCurrentTimestamp()), TUID.makeClockSeqAndNode());
    }

    public static class TUIDComparator
    implements Comparator<UUID> {
        @Override
        public int compare(UUID uUID, UUID uUID2) {
            if (uUID.version() == 1 && uUID2.version() == 1) {
                long l;
                long l2 = uUID.timestamp();
                if (l2 == (l = uUID2.timestamp())) {
                    long l3;
                    long l4 = uUID.getLeastSignificantBits();
                    if (l4 == (l3 = uUID2.getLeastSignificantBits())) {
                        return 0;
                    }
                    return l4 < l3 ? -1 : 1;
                }
                return l2 < l ? -1 : 1;
            }
            return uUID.compareTo(uUID2);
        }
    }
}

