/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc.UInts;

import ai.z7.blockchain_misc.UInts.Arrays;
import ai.z7.blockchain_misc.UInts.UInt;
import ai.z7.blockchain_misc.UInts.UInt256;
import java.math.BigInteger;

public final class UInt128
extends UInt<UInt128> {
    static final int MAX_WIDTH = 4;
    public static UInt128 MAX_VALUE = new UInt128(Arrays.maxValue(4));
    public static UInt128 ZERO = new UInt128(Arrays.ZERO);
    public static UInt128 ONE = new UInt128(Arrays.ONE);
    public static UInt128 TWO = new UInt128(Arrays.TWO);

    public UInt128(int[] nArray) {
        super(nArray, 4);
    }

    public UInt128(byte[] byArray) {
        super(byArray, MAX_VALUE);
    }

    public UInt128(UInt256 uInt256) {
        super(uInt256, 4);
    }

    public UInt128(String string) {
        this(string, 10);
    }

    public UInt128(String string, int n) {
        super(string, n, 4);
    }

    public UInt128(BigInteger bigInteger) {
        super(bigInteger, 4);
    }

    public UInt128(long l) {
        super(l);
    }

    @Override
    public UInt128 not() {
        return new UInt128(Arrays.not(this.ints, UInt128.MAX_VALUE.ints));
    }

    @Override
    public UInt128 and(UInt128 uInt128) {
        return new UInt128(Arrays.and(this.ints, uInt128.ints));
    }

    @Override
    public UInt128 or(UInt128 uInt128) {
        return new UInt128(Arrays.or(this.ints, uInt128.ints));
    }

    @Override
    public UInt128 xor(UInt128 uInt128) {
        return new UInt128(Arrays.xor(this.ints, uInt128.ints));
    }

    @Override
    public UInt128 setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return 4 <= n >>> 5 ? this : new UInt128(Arrays.setBit(this.ints, n));
    }

    @Override
    public UInt128 clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return this.ints.length <= n >>> 5 ? this : new UInt128(Arrays.clearBit(this.ints, n));
    }

    @Override
    public UInt128 flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return 4 <= n >>> 5 ? this : new UInt128(Arrays.flipBit(this.ints, n));
    }

    @Override
    public UInt128 shiftLeft(int n) {
        return new UInt128(0 < n ? Arrays.lshift(this.ints, n, 4) : Arrays.rshift(this.ints, -n, 4));
    }

    @Override
    public UInt128 shiftRight(int n) {
        return new UInt128(0 < n ? Arrays.rshift(this.ints, n, 4) : Arrays.lshift(this.ints, -n, 4));
    }

    @Override
    public UInt128 inc() {
        return new UInt128(Arrays.inc(this.ints, 4));
    }

    @Override
    public UInt128 dec() {
        return this.isZero() ? MAX_VALUE : new UInt128(Arrays.dec(this.ints));
    }

    @Override
    public UInt128 add(UInt128 uInt128) {
        return this.isZero() ? uInt128 : (uInt128.isZero() ? this : new UInt128(Arrays.add(this.ints, uInt128.ints, 4)));
    }

    @Override
    public UInt128 addmod(UInt128 uInt128, UInt128 uInt1282) {
        if (uInt1282.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        return new UInt128(Arrays.addmod(this.ints, uInt128.ints, uInt1282.ints));
    }

    @Override
    public UInt128 subtract(UInt128 uInt128) {
        if (uInt128.isZero()) {
            return this;
        }
        int n = this.compareTo(uInt128);
        return n == 0 ? ZERO : new UInt128(n < 0 ? Arrays.subgt(this.ints, uInt128.ints, UInt128.MAX_VALUE.ints) : Arrays.sub(this.ints, uInt128.ints));
    }

    @Override
    public UInt128 multiply(UInt128 uInt128) {
        if (this.ints.length == 0 || uInt128.ints.length == 0) {
            return ZERO;
        }
        return new UInt128(Arrays.multiply(this.ints, uInt128.ints, 4));
    }

    @Override
    public UInt128 mulmod(UInt128 uInt128, UInt128 uInt1282) {
        if (uInt1282.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        return new UInt128(Arrays.mulmod(this.ints, uInt128.ints, uInt1282.ints));
    }

    @Override
    public UInt128 pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (n == 0) {
            return ONE;
        }
        if (this.isZero()) {
            return this;
        }
        return n == 1 ? this : new UInt128(Arrays.pow(this.ints, this.getLowestSetBit(), n, 4));
    }

    @Override
    public UInt128 divide(UInt128 uInt128) {
        if (uInt128.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero()) {
            return ZERO;
        }
        int n = this.compareTo(uInt128);
        return n < 0 ? ZERO : (n == 0 ? ONE : new UInt128(Arrays.divide(this.ints, uInt128.ints)));
    }

    @Override
    public UInt128 mod(UInt128 uInt128) {
        if (uInt128.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero()) {
            return ZERO;
        }
        int n = this.compareTo(uInt128);
        return n < 0 ? this : (n == 0 ? ZERO : new UInt128(Arrays.mod(this.ints, uInt128.ints)));
    }

    public UInt128[] divmod(UInt128 uInt128) {
        if (uInt128.isZero()) {
            throw new ArithmeticException("div/mod by zero");
        }
        if (this.isZero()) {
            return new UInt128[]{ZERO, ZERO};
        }
        int n = this.compareTo(uInt128);
        if (n < 0) {
            return new UInt128[]{ZERO, this};
        }
        if (n == 0) {
            return new UInt128[]{ONE, ZERO};
        }
        int[][] nArray = Arrays.divmod(this.ints, uInt128.ints);
        return new UInt128[]{new UInt128(nArray[0]), new UInt128(nArray[1])};
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BigInteger) {
            return Arrays.compare(this.ints, (BigInteger)object, 4) == 0;
        }
        return super.equals(object);
    }
}

