/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc.UInts;

import ai.z7.blockchain_misc.UInts.Arrays;

final class StringUtil {
    private static final int[] BITS_PER_DIGIT = new int[]{1024, 1624, 2048, 2378, 2648, 2875, 3072, 3247, 3402, 3543, 3672, 3790, 3899, 4001, 4096, 4186, 4271, 4350, 4426, 4498, 4567, 4633, 4696, 4756, 4814, 4870, 4923, 4975, 5025, 5074, 5120, 5166, 5210, 5253, 5295};
    private static final int[] DIGITS_PER_INT = new int[]{30, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
    private static final int[] RADIX_LENGTH_LONG = new int[]{62, 39, 31, 27, 24, 22, 20, 19, 18, 18, 17, 17, 16, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] RADIX_INT = new int[]{0x40000000, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};
    private static final long[] RADIX_LONG = new long[]{0x4000000000000000L, 4052555153018976267L, 0x4000000000000000L, 7450580596923828125L, 4738381338321616896L, 3909821048582988049L, 0x1000000000000000L, 1350851717672992089L, 1000000000000000000L, 5559917313492231481L, 2218611106740436992L, 8650415919381337933L, 2177953337809371136L, 6568408355712890625L, 0x1000000000000000L, 2862423051509815793L, 6746640616477458432L, 799006685782884121L, 1638400000000000000L, 3243919932521508681L, 6221821273427820544L, 504036361936467383L, 876488338465357824L, 1490116119384765625L, 2481152873203736576L, 4052555153018976267L, 6502111422497947648L, 353814783205469041L, 531441000000000000L, 787662783788549761L, 0x1000000000000000L, 1667889514952984961L, 2386420683693101056L, 3379220508056640625L, 4738381338321616896L};
    static String ZEROES = "000000000000000000000000000000000000000000000000000000000000000";

    StringUtil() {
    }

    static int[] fromString(String string, int n, int n2) {
        String string2;
        if (n < 2 || 36 < n) {
            throw new NumberFormatException("Radix out of range");
        }
        if (-1 < string.lastIndexOf(45)) {
            throw new NumberFormatException("Invalid sign");
        }
        int n3 = 0;
        int n4 = string.length();
        int n5 = string.lastIndexOf(43);
        if (-1 < n5) {
            if (0 < n5) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            ++n3;
        }
        if (n4 == n3) {
            throw new NumberFormatException("Zero-length");
        }
        while (n3 < n4 && Character.digit(string.charAt(n3), n) == 0) {
            ++n3;
        }
        if (n3 == n4) {
            return Arrays.ZERO;
        }
        int n6 = n4 - n3;
        int n7 = DIGITS_PER_INT[n - 2];
        long l = ((long)n6 * (long)BITS_PER_DIGIT[n - 2] >>> 10) + 1L;
        int n8 = Math.min((int)(l + 31L) >>> 5, n2);
        int[] nArray = new int[n8];
        int n9 = n6 % n7;
        if (n9 == 0) {
            n9 = n7;
        }
        if ((nArray[n8 - 1] = Integer.parseInt(string2 = string.substring(n3, n3 += n9), n)) < 0) {
            throw new NumberFormatException("Illegal digit");
        }
        int n10 = RADIX_INT[n - 2];
        int n11 = 0;
        while (n3 < n4) {
            if ((n11 = Integer.parseInt(string2 = string.substring(n3, n3 += n7), n)) < 0) {
                throw new NumberFormatException("Illegal digit");
            }
            StringUtil.muladd(nArray, n10, n11);
        }
        return Arrays.stripLeadingZeroes(nArray);
    }

    private static void muladd(int[] nArray, int n, int n2) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        int n3 = nArray.length;
        long l3 = 0L;
        for (int i = n3 - 1; 0 <= i; --i) {
            long l4 = l * ((long)nArray[i] & 0xFFFFFFFFL) + l3;
            nArray[i] = (int)l4;
            l3 = l4 >>> 32;
        }
        long l5 = ((long)nArray[n3 - 1] & 0xFFFFFFFFL) + l2;
        nArray[n3 - 1] = (int)l5;
        l3 = l5 >>> 32;
        for (int i = n3 - 2; l3 != 0L && 0 <= i; --i) {
            l5 = ((long)nArray[i] & 0xFFFFFFFFL) + l3;
            nArray[i] = (int)l5;
            l3 = l5 >>> 32;
        }
    }

    static String toString(int[] nArray, int n) {
        String[] stringArray = new String[(4 * nArray.length + 6) / 7];
        long l = RADIX_LONG[n - 2];
        int n2 = 0;
        int[] nArray2 = nArray;
        int[] nArray3 = null;
        do {
            int[][] nArray4 = Arrays.divmod(nArray2, l);
            nArray2 = nArray4[0];
            nArray3 = nArray4[1];
            if (nArray3.length == 0) {
                stringArray[n2++] = "0";
                continue;
            }
            long l2 = nArray3.length == 1 ? (long)nArray3[0] & 0xFFFFFFFFL : ((long)nArray3[0] & 0xFFFFFFFFL) << 32 | (long)nArray3[1] & 0xFFFFFFFFL;
            stringArray[n2++] = Long.toString(l2, n);
        } while (0 < nArray2.length);
        int n3 = RADIX_LENGTH_LONG[n - 2];
        StringBuilder stringBuilder = new StringBuilder(n2 * n3);
        stringBuilder.append(stringArray[n2 - 1]);
        for (int i = n2 - 2; 0 <= i; --i) {
            int n4 = n3 - stringArray[i].length();
            if (n4 != 0) {
                stringBuilder.append(ZEROES, 0, n4);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }
}

