/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc.UInts;

import ai.z7.blockchain_misc.UInts.Arrays;
import ai.z7.blockchain_misc.UInts.StringUtil;
import java.math.BigInteger;

public abstract class UInt<T extends UInt>
extends Number
implements Comparable<T> {
    final int[] ints;
    static final int DEFAULT_RADIX = 10;

    UInt(long l) {
        this.ints = Arrays.valueOf(l);
    }

    UInt(int[] nArray) {
        this.ints = nArray;
    }

    UInt(int[] nArray, int n) {
        this(Arrays.stripLeadingZeroes(nArray, Math.max(0, nArray.length - n)));
    }

    UInt(UInt uInt, int n) {
        this(uInt.ints, n);
    }

    UInt(String string, int n, int n2) {
        this.ints = StringUtil.fromString(string, n, n2);
    }

    UInt(BigInteger bigInteger, int n) {
        this(Arrays.from(bigInteger, n), n);
    }

    UInt(byte[] byArray, UInt uInt) {
        this(Arrays.from(byArray, uInt.ints), uInt.ints.length);
    }

    public abstract T[] divmod(T var1);

    public abstract T divide(T var1);

    public abstract T mod(T var1);

    public abstract T multiply(T var1);

    public abstract T mulmod(T var1, T var2);

    public abstract T pow(int var1);

    public abstract T not();

    public abstract T and(T var1);

    public abstract T or(T var1);

    public abstract T xor(T var1);

    public abstract T inc();

    public abstract T dec();

    public abstract T add(T var1);

    public abstract T addmod(T var1, T var2);

    public abstract T subtract(T var1);

    public abstract T shiftLeft(int var1);

    public abstract T shiftRight(int var1);

    public abstract T setBit(int var1);

    public abstract T clearBit(int var1);

    public abstract T flipBit(int var1);

    public final boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int n2 = n >>> 5;
        return n2 < this.ints.length && 0 != (this.ints[this.ints.length - n2 - 1] & 1 << (n & 0x1F));
    }

    public final T[] divideAndRemainder(T t) {
        return this.divmod((UInt)t);
    }

    public final T remainder(T t) {
        return this.mod(t);
    }

    public final int bitLength() {
        return Arrays.bitLength(this.ints);
    }

    public final boolean isZero() {
        return this.ints.length == 0;
    }

    public final int getLowestSetBit() {
        int n;
        for (int i = n = this.ints.length - 1; 0 <= i; --i) {
            if (this.ints[i] == 0) continue;
            return (n - i) * 32 + Integer.numberOfTrailingZeros(this.ints[i]);
        }
        return -1;
    }

    public int hashCode() {
        int n = 0;
        for (int n2 : this.ints) {
            n = (int)((long)(31 * n) + ((long)n2 & 0xFFFFFFFFL));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof UInt) {
            return Arrays.compare(this.ints, ((UInt)object).ints) == 0;
        }
        return false;
    }

    @Override
    public final int compareTo(T t) {
        return Arrays.compare(this.ints, ((UInt)t).ints);
    }

    public final T max(T t) {
        return (T)(0 < this.compareTo(t) ? this : t);
    }

    public final T min(T t) {
        return (T)(this.compareTo(t) < 0 ? this : t);
    }

    @Override
    public final int intValue() {
        return this.ints.length == 0 ? 0 : this.ints[this.ints.length - 1];
    }

    @Override
    public final long longValue() {
        int n = this.ints.length;
        if (n == 0) {
            return 0L;
        }
        long l = (long)this.ints[n - 1] & 0xFFFFFFFFL;
        return this.ints.length == 1 ? l : ((long)this.ints[n - 2] & 0xFFFFFFFFL) << 32 | l;
    }

    @Override
    public final float floatValue() {
        return Float.parseFloat(this.toString());
    }

    @Override
    public final double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public final int intValueExact() {
        if (this.ints.length <= 1 && this.bitLength() < 32) {
            return this.intValue();
        }
        throw new ArithmeticException("Out of int range");
    }

    public final long longValueExact() {
        if (this.ints.length <= 2 && this.bitLength() < 64) {
            return this.longValue();
        }
        throw new ArithmeticException("Out of long range");
    }

    public final short shortValueExact() {
        int n;
        if (this.ints.length <= 1 && this.bitLength() < 32 && Short.MIN_VALUE <= (n = this.intValue()) && n <= Short.MAX_VALUE) {
            return this.shortValue();
        }
        throw new ArithmeticException("Out of short range");
    }

    public final byte byteValueExact() {
        int n;
        if (this.ints.length <= 1 && this.bitLength() < 32 && -128 <= (n = this.intValue()) && n <= 127) {
            return this.byteValue();
        }
        throw new ArithmeticException("Out of byte range");
    }

    public final BigInteger toBigInteger() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int n : this.ints) {
            bigInteger = bigInteger.shiftLeft(32).or(BigInteger.valueOf((long)n & 0xFFFFFFFFL));
        }
        return bigInteger;
    }

    public final byte[] toByteArray() {
        int n = (int)Math.ceil((double)this.bitLength() / 8.0);
        byte[] byArray = new byte[n];
        int n2 = this.ints.length - 1;
        int n3 = 0;
        int n4 = n - 1;
        int n5 = 0;
        while (0 <= n4) {
            n3 = n5 % 4 == 0 ? this.ints[n2--] : n3 >>> 8;
            byArray[n4] = (byte)n3;
            --n4;
            ++n5;
        }
        return byArray;
    }

    public final int[] toIntArray() {
        return java.util.Arrays.copyOf(this.ints, this.ints.length);
    }

    public final String toString() {
        return this.toString(10);
    }

    public final String toString(int n) {
        if (this.isZero()) {
            return "0";
        }
        if (n < 2 || 36 < n) {
            n = 10;
        }
        if (this.ints.length == 1) {
            return Integer.toUnsignedString(this.ints[0], n);
        }
        if (this.ints.length == 2) {
            return Long.toUnsignedString(((long)this.ints[0] & 0xFFFFFFFFL) << 32 | (long)this.ints[1] & 0xFFFFFFFFL, n);
        }
        return StringUtil.toString(this.ints, n);
    }
}

