/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc.UInts;

import ai.z7.blockchain_misc.UInts.Division;
import java.math.BigInteger;

final class Arrays {
    static final long LONG = 0xFFFFFFFFL;
    static final int MAX_CACHE = 28;
    static final int[][] CACHE = new int[28][1];
    static final int[] ZERO;
    static final int[] ONE;
    static final int[] TWO;
    private static final BigInteger BIG_INT;

    Arrays() {
    }

    static int[] valueOf(long l) {
        int[] nArray;
        if (0L <= l && l < 28L) {
            return CACHE[(int)l];
        }
        int n = (int)(l >>> 32);
        if (n == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = (int)l;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = n;
            nArray = nArray3;
            nArray3[1] = (int)l;
        }
        return nArray;
    }

    static int compare(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        if (n < nArray2.length) {
            return -1;
        }
        if (n > nArray2.length) {
            return 1;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return Integer.compareUnsigned(nArray[i], nArray2[i]);
        }
        return 0;
    }

    static int compare(int[] nArray, BigInteger bigInteger, int n) {
        int n2;
        int n3 = Arrays.bitLength(nArray);
        if (n3 < (n2 = bigInteger.bitLength())) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        return Arrays.compare(nArray, Arrays.from(bigInteger, n));
    }

    static int[] stripLeadingZeroes(int[] nArray, int n) {
        int n2 = nArray.length;
        while (n < n2 && nArray[n] == 0) {
            ++n;
        }
        return n == 0 ? nArray : java.util.Arrays.copyOfRange(nArray, n, n2);
    }

    static int[] stripLeadingZeroes(int[] nArray) {
        return Arrays.stripLeadingZeroes(nArray, 0);
    }

    static byte[] stripLeadingZeroes(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 0; n < n2 && byArray[n] == 0; ++n) {
        }
        return n == 0 ? byArray : java.util.Arrays.copyOfRange(byArray, n, n2);
    }

    static int[] not(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        if (nArray.length == 0) {
            return nArray2;
        }
        int n3 = 0;
        if (nArray[0] == -1) {
            for (n3 = 1; n3 < n && nArray[n3] == -1; ++n3) {
            }
        }
        if (n3 == n2) {
            return ZERO;
        }
        int[] nArray3 = new int[n < n2 ? n2 : n2 - n3];
        int n4 = n2 - n;
        java.util.Arrays.fill(nArray3, 0, n4, -1);
        for (int i = nArray3.length - 1; n4 <= i; --i) {
            nArray3[i] = ~nArray[--n];
        }
        return nArray3;
    }

    static int[] and(int[] nArray, int[] nArray2) {
        int n;
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        if ((n = nArray2.length) == 0) {
            return ZERO;
        }
        int[] nArray4 = java.util.Arrays.copyOf(nArray2, n);
        int n2 = nArray.length;
        while (0 < n) {
            int n3 = --n;
            nArray4[n3] = nArray4[n3] & nArray[--n2];
        }
        return nArray4[0] == 0 ? Arrays.stripLeadingZeroes(nArray4, 1) : nArray4;
    }

    static int[] or(int[] nArray, int[] nArray2) {
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray4 = java.util.Arrays.copyOf(nArray, n);
        while (0 < n2) {
            int n3 = --n;
            nArray4[n3] = nArray4[n3] | nArray2[--n2];
        }
        return nArray4;
    }

    static int[] xor(int[] nArray, int[] nArray2) {
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        if (nArray.length == 0) {
            return ZERO;
        }
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray4 = java.util.Arrays.copyOf(nArray, n);
        while (0 < n2) {
            int n3 = --n;
            nArray4[n3] = nArray4[n3] ^ nArray2[--n2];
        }
        return nArray4[0] == 0 ? Arrays.stripLeadingZeroes(nArray4, 1) : nArray4;
    }

    static int[] setBit(int[] nArray, int n) {
        int n2 = n >>> 5;
        int n3 = nArray.length;
        if (n2 <= n3 - 1) {
            int n4 = n3 - n2 - 1;
            int n5 = nArray[n4] | 1 << (n & 0x1F);
            if (n5 == nArray[n4]) {
                return nArray;
            }
            int[] nArray2 = java.util.Arrays.copyOf(nArray, n3);
            nArray2[n4] = n5;
            return nArray2;
        }
        int[] nArray3 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray3, nArray3.length - n3, n3);
        nArray3[0] = 1 << (n & 0x1F);
        return nArray3;
    }

    static int[] clearBit(int[] nArray, int n) {
        int n2 = nArray.length;
        int n3 = n2 - (n >>> 5) - 1;
        int n4 = nArray[n3] & ~(1 << (n & 0x1F));
        if (n4 == nArray[n3]) {
            return nArray;
        }
        if (n3 != 0 || n4 != 0) {
            int[] nArray2 = java.util.Arrays.copyOf(nArray, n2);
            nArray2[n3] = n4;
            return nArray2;
        }
        return Arrays.stripLeadingZeroes(nArray, 1);
    }

    static int[] flipBit(int[] nArray, int n) {
        int n2 = n >>> 5;
        int n3 = nArray.length;
        if (n2 < n3 - 1) {
            int n4 = n3 - n2 - 1;
            int n5 = nArray[n4] ^ 1 << (n & 0x1F);
            if (n5 == nArray[n4]) {
                return nArray;
            }
            int[] nArray2 = java.util.Arrays.copyOf(nArray, n3);
            nArray2[n4] = n5;
            return nArray2;
        }
        int[] nArray3 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray3, nArray3.length - n3, n3);
        nArray3[0] = nArray3[0] ^ 1 << (n & 0x1F);
        return nArray3[0] == 0 ? Arrays.stripLeadingZeroes(nArray3, 1) : nArray3;
    }

    static int[] lshift(int[] nArray, int n, int n2) {
        int[] nArray2;
        if (n == 0) {
            return nArray;
        }
        int n3 = nArray.length;
        int n4 = n >>> 5;
        if (n3 == 0 || n2 < n4) {
            return ZERO;
        }
        int n5 = n & 0x1F;
        int n6 = n3 + n4;
        int n7 = 0;
        if (n2 < n6) {
            n7 = n6 - n2;
            n6 = n2;
            while (n7 < n3 && nArray[n7] == 0) {
                ++n7;
                --n6;
            }
        }
        if (n7 == n3) {
            return ZERO;
        }
        if (n5 == 0) {
            int[] nArray3 = new int[n6];
            System.arraycopy(nArray, n7, nArray3, 0, n3 - n7);
            return nArray3;
        }
        int n8 = 0;
        int n9 = 32 - n5;
        int n10 = nArray[n7] >>> n9;
        if (n10 != 0 && n6 < n2) {
            nArray2 = new int[n6 + 1];
            nArray2[n8++] = n10;
        } else {
            nArray2 = new int[n6];
        }
        while (n7 < n3 - 1) {
            nArray2[n8++] = nArray[n7++] << n5 | nArray[n7] >>> n9;
        }
        nArray2[n8] = nArray[n7] << n5;
        return nArray2[0] == 0 ? Arrays.stripLeadingZeroes(nArray2, 1) : nArray2;
    }

    static int[] rshift(int[] nArray, int n, int n2) {
        int[] nArray2;
        int n3 = nArray.length;
        int n4 = n >>> 5;
        if (n3 <= n4) {
            return ZERO;
        }
        int n5 = n & 0x1F;
        int n6 = n3 - n4;
        if (n5 == 0) {
            return java.util.Arrays.copyOf(nArray, n6);
        }
        int n7 = 32 - n5;
        int n8 = nArray[0] >>> n5;
        int n9 = 0;
        int n10 = 0;
        if (n8 != 0) {
            nArray2 = new int[n6];
            nArray2[n9++] = n8;
        } else {
            nArray2 = new int[n6 - 1];
        }
        while (n10 < n6 - 1) {
            nArray2[n9++] = nArray[n10++] << n7 | nArray[n10] >>> n5;
        }
        return nArray2;
    }

    static int[] inc(int[] nArray, int n) {
        return Arrays.inc(nArray, false, n);
    }

    static int[] inc(int[] nArray, boolean bl, int n) {
        int[] nArray2;
        int n2 = nArray.length;
        if (n2 == 0) {
            return ONE;
        }
        int n3 = n2 - 1;
        int[] nArray3 = nArray2 = bl ? nArray : java.util.Arrays.copyOf(nArray, n2);
        while (0 <= n3) {
            int n4 = n3--;
            nArray2[n4] = nArray2[n4] + 1;
            if (nArray2[n4] == 0) continue;
            return nArray2;
        }
        if (n2 == n) {
            return Arrays.stripLeadingZeroes(nArray2);
        }
        int[] nArray4 = new int[n2 + 1];
        System.arraycopy(nArray2, 0, nArray4, 1, n2);
        nArray4[0] = 1;
        return nArray4;
    }

    static int[] dec(int[] nArray) {
        int n = nArray.length;
        int n2 = n - 1;
        int[] nArray2 = java.util.Arrays.copyOf(nArray, n);
        int n3 = n2;
        int n4 = nArray2[n3] - 1;
        nArray2[n3] = n4;
        int n5 = n4;
        if (n4 != -1) {
            return n2 == 0 && n5 == 0 ? Arrays.stripLeadingZeroes(nArray2, 1) : nArray2;
        }
        while (0 <= --n2) {
            int n6 = n2;
            int n7 = nArray2[n6] - 1;
            nArray2[n6] = n7;
            n5 = n7;
            if (n7 == -1) continue;
        }
        return n5 == 0 && n2 == 0 ? Arrays.stripLeadingZeroes(nArray2, 1) : nArray2;
    }

    static int[] add(int[] nArray, int[] nArray2, int n) {
        boolean bl;
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int[] nArray4 = java.util.Arrays.copyOf(nArray, n2);
        long l = 0L;
        while (0 < n3) {
            l = ((long)nArray4[--n2] & 0xFFFFFFFFL) + ((long)nArray2[--n3] & 0xFFFFFFFFL) + (l >>> 32);
            nArray4[n2] = (int)l;
        }
        boolean bl2 = bl = l >>> 32 != 0L;
        while (bl && 0 < n2) {
            int n4 = --n2;
            int n5 = nArray4[n4] + 1;
            nArray4[n4] = n5;
            bl = n5 == 0;
        }
        if (bl && (nArray4.length < n || n == -1)) {
            int[] nArray5 = new int[nArray4.length + 1];
            nArray5[0] = 1;
            System.arraycopy(nArray4, 0, nArray5, 1, nArray4.length);
            return nArray5;
        }
        return nArray4[0] == 0 ? Arrays.stripLeadingZeroes(nArray4, 1) : nArray4;
    }

    static int[] subgt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length == 0) {
            return Arrays.inc(Arrays.not(nArray2, nArray3), true, nArray3.length);
        }
        return Arrays.inc(Arrays.not(Arrays.sub(nArray2, nArray), nArray3), true, nArray3.length);
    }

    static int[] sub(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        if (n2 == 0) {
            return nArray;
        }
        int[] nArray3 = java.util.Arrays.copyOf(nArray, n);
        long l = 0L;
        while (0 < n2) {
            l = ((long)nArray3[--n] & 0xFFFFFFFFL) - ((long)nArray2[--n2] & 0xFFFFFFFFL) + (l >> 32);
            nArray3[n] = (int)l;
        }
        if (l >> 32 != 0L) {
            while (0 < n) {
                int n3 = --n;
                nArray3[n3] = nArray3[n3] - 1;
                if (nArray3[n3] == -1) continue;
            }
        }
        return nArray3[0] == 0 ? Arrays.stripLeadingZeroes(nArray3, 1) : nArray3;
    }

    static int[] mulmod(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4;
        if (nArray.length < nArray2.length) {
            nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray4;
        }
        if (nArray2.length == 0) {
            return ZERO;
        }
        nArray4 = Arrays.mul(nArray, nArray.length, nArray2, nArray2.length);
        int n = Arrays.compare(nArray4, nArray3);
        return n < 0 ? nArray4 : (n == 0 ? ZERO : Arrays.mod(nArray4, nArray3));
    }

    static int[] addmod(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4;
        if (nArray.length < nArray2.length) {
            nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray4;
        }
        return (n = Arrays.compare(nArray4 = nArray2.length == 0 ? nArray : Arrays.add(nArray, nArray2, -1), nArray3)) < 0 ? nArray4 : (n == 0 ? ZERO : Arrays.mod(nArray4, nArray3));
    }

    static int[] multiply(int[] nArray, int[] nArray2, int n) {
        if (nArray.length < nArray2.length) {
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n2 = nArray.length;
        int n3 = nArray2.length;
        if (n3 == 1) {
            return Arrays.mul(nArray, n2, nArray2[0], n);
        }
        if (n3 == 2) {
            return Arrays.mul(nArray, n2, nArray2[0], nArray2[1], n);
        }
        int n4 = n2 + n3;
        if (n < n4) {
            return Arrays.mul(nArray, n2, nArray2, n3, n, n4 - n);
        }
        return Arrays.mul(nArray, n2, nArray2, n3);
    }

    static int[] mul(int[] nArray, int n, int n2, int n3) {
        if (Integer.bitCount(n2) == 1) {
            return Arrays.lshift(nArray, Integer.numberOfTrailingZeros(n2), n3);
        }
        int[] nArray2 = new int[n == n3 ? n3 : n + 1];
        long l = 0L;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        int n4 = n - 1;
        int n5 = nArray2.length - 1;
        while (0 <= n4) {
            long l3 = ((long)nArray[n4] & 0xFFFFFFFFL) * l2 + l;
            nArray2[n5] = (int)l3;
            l = l3 >>> 32;
            --n4;
            --n5;
        }
        return n != n3 && (nArray2[0] = (int)l) != 0 ? nArray2 : (nArray2[0] == 0 ? Arrays.stripLeadingZeroes(nArray2, 1) : nArray2);
    }

    static int[] mul(int[] nArray, int n, int n2, int n3, int n4) {
        long l;
        int n5;
        int n6 = n + 2;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = (long)n3 & 0xFFFFFFFFL;
        int[] nArray2 = new int[n6];
        int n7 = n6 - 1;
        long l4 = 0L;
        for (n5 = n - 1; 0 <= n5; --n5) {
            l = ((long)nArray[n5] & 0xFFFFFFFFL) * l3 + l4;
            nArray2[n7--] = (int)l;
            l4 = l >>> 32;
        }
        nArray2[n7] = (int)l4;
        l4 = 0L;
        n7 = nArray2.length - 2;
        for (n5 = n - 1; 0 <= n5; --n5) {
            l = ((long)nArray[n5] & 0xFFFFFFFFL) * l2 + ((long)nArray2[n7] & 0xFFFFFFFFL) + l4;
            nArray2[n7--] = (int)l;
            l4 = l >>> 32;
        }
        nArray2[0] = (int)l4;
        if (n6 <= n4) {
            return l4 == 0L ? Arrays.stripLeadingZeroes(nArray2, 1) : nArray2;
        }
        return Arrays.stripLeadingZeroes(nArray2, n6 - n4);
    }

    static int[] mul(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = n + n2;
        int n4 = n - 1;
        int n5 = n2 - 1;
        int[] nArray3 = new int[n3];
        long l = 0L;
        int n6 = n5;
        int n7 = n3 - 1;
        while (0 <= n6) {
            long l2 = ((long)nArray2[n6] & 0xFFFFFFFFL) * ((long)nArray[n4] & 0xFFFFFFFFL) + l;
            nArray3[n7] = (int)l2;
            l = l2 >>> 32;
            --n6;
            --n7;
        }
        nArray3[n4] = (int)l;
        for (n6 = n4 - 1; 0 <= n6; --n6) {
            l = 0L;
            n7 = n5;
            int n8 = n5 + n6 + 1;
            while (0 <= n7) {
                long l3 = ((long)nArray2[n7] & 0xFFFFFFFFL) * ((long)nArray[n6] & 0xFFFFFFFFL) + ((long)nArray3[n8] & 0xFFFFFFFFL) + l;
                nArray3[n8] = (int)l3;
                l = l3 >>> 32;
                --n7;
                --n8;
            }
            nArray3[n6] = (int)l;
        }
        return l == 0L ? Arrays.stripLeadingZeroes(nArray3, 1) : nArray3;
    }

    static int[] mul(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        int n5 = n - 1;
        int n6 = n2 - 1;
        int[] nArray3 = new int[n3];
        long l = 0L;
        int n7 = n6;
        int n8 = n3 - 1;
        while (0 <= n7) {
            long l2 = ((long)nArray2[n7] & 0xFFFFFFFFL) * ((long)nArray[n5] & 0xFFFFFFFFL) + l;
            nArray3[n8] = (int)l2;
            l = l2 >>> 32;
            --n7;
            --n8;
        }
        if (n4 <= n5) {
            nArray3[n5 - n4] = (int)l;
        }
        n7 = n3 - 2;
        for (n8 = n5 - 1; 0 <= n8; --n8) {
            l = 0L;
            int n9 = n6;
            for (int i = n7--; 0 <= n9 && 0 <= i; --n9, --i) {
                long l3 = ((long)nArray2[n9] & 0xFFFFFFFFL) * ((long)nArray[n8] & 0xFFFFFFFFL) + ((long)nArray3[i] & 0xFFFFFFFFL) + l;
                nArray3[i] = (int)l3;
                l = l3 >>> 32;
            }
            if (n4 > n8) continue;
            nArray3[n8 - n4] = (int)l;
        }
        return Arrays.stripLeadingZeroes(nArray3);
    }

    static int bitLength(int[] nArray) {
        return nArray.length == 0 ? 0 : (nArray.length - 1) * 32 + (32 - Integer.numberOfLeadingZeros(nArray[0]));
    }

    static int[] square(int[] nArray, int n) {
        long l;
        int n2;
        int n3;
        int n4 = nArray.length;
        int n5 = n4 << 1;
        if (n < n5) {
            n3 = n5 - n >>> 1;
            n5 = n;
        } else {
            n3 = 0;
        }
        int[] nArray2 = new int[n5];
        int n6 = 0;
        int n7 = 0;
        for (n2 = n3; n2 < n4; ++n2) {
            l = (long)nArray[n2] & 0xFFFFFFFFL;
            long l2 = l * l;
            nArray2[n7++] = n6 << 31 | (int)(l2 >>> 33);
            nArray2[n7++] = (int)(l2 >>> 1);
            n6 = (int)l2;
        }
        n2 = n4;
        block1: for (n7 = 1; n3 < n2 && n7 < n5; --n2, n7 += 2) {
            int n8;
            l = 0L;
            int n9 = n5 - n7 - 1;
            long l3 = (long)nArray[n2 - 1] & 0xFFFFFFFFL;
            for (n8 = n2 - 2; 0 <= n8 && 0 <= n9; --n8) {
                long l4 = ((long)nArray[n8] & 0xFFFFFFFFL) * l3 + ((long)nArray2[n9] & 0xFFFFFFFFL) + l;
                nArray2[n9--] = (int)l4;
                l = l4 >>> 32;
            }
            if (0 > n9) continue;
            nArray2[n9] = (int)(l += (long)nArray2[n9] & 0xFFFFFFFFL);
            if (l >> 32 == 0L) continue;
            for (n8 = n2 - 1; 0 <= n8 && 0 <= --n9; --n8) {
                int n10 = n9;
                nArray2[n10] = nArray2[n10] + 1;
                if (nArray2[n10] != 0) continue block1;
            }
        }
        Division.lshunt(nArray2, 1);
        int n11 = n5 - 1;
        nArray2[n11] = nArray2[n11] | nArray[n4 - 1] & 1;
        return nArray2[0] == 0 ? Arrays.stripLeadingZeroes(nArray2, 1) : nArray2;
    }

    static int[] pow(int[] nArray, int n, int n2, int n3) {
        int n4;
        if (n2 == 2) {
            return Arrays.multiply(nArray, nArray, n3);
        }
        long l = (long)n * (long)n2;
        if (Integer.MAX_VALUE < l) {
            throw new ArithmeticException("Overflow");
        }
        if (0 < n) {
            nArray = Arrays.rshift(nArray, n, n3);
        }
        if ((n4 = Arrays.bitLength(nArray)) == 1) {
            return 0 < n ? Arrays.lshift(ONE, n * n2, n3) : ONE;
        }
        long l2 = (long)n4 * (long)n2;
        if (nArray.length == 1 && l2 < 63L) {
            long l3 = 1L;
            long l4 = (long)nArray[0] & 0xFFFFFFFFL;
            while (n2 != 0) {
                if ((n2 & 1) == 1) {
                    l3 *= l4;
                }
                if ((n2 >>>= 1) == 0) continue;
                l4 *= l4;
            }
            if (0 < n) {
                return l + l2 < 63L ? Arrays.valueOf(l3 << (int)l) : Arrays.lshift(Arrays.valueOf(l3), (int)l, n3);
            }
            return Arrays.valueOf(l3);
        }
        int n5 = n * n2;
        int[] nArray2 = ONE;
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                nArray2 = Arrays.multiply(nArray2, nArray, n3);
            }
            if ((n2 >>>= 1) == 0) continue;
            nArray = Arrays.multiply(nArray, nArray, n3);
        }
        return 0 < n5 ? Arrays.lshift(nArray2, n5, n3) : nArray2;
    }

    static int[] divide(int[] nArray, int[] nArray2) {
        int[] nArray3;
        switch (nArray2.length) {
            case 1: {
                nArray3 = Division.div(nArray, nArray2[0])[0];
                break;
            }
            case 2: {
                long l = ((long)nArray2[0] & 0xFFFFFFFFL) << 32 | (long)nArray2[1] & 0xFFFFFFFFL;
                nArray3 = Division.div(nArray, l)[0];
                break;
            }
            default: {
                nArray3 = Division.div(nArray, nArray2)[0];
            }
        }
        return nArray3[0] == 0 ? Arrays.stripLeadingZeroes(nArray3) : nArray3;
    }

    static int[] mod(int[] nArray, int[] nArray2) {
        int[] nArray3;
        switch (nArray2.length) {
            case 1: {
                nArray3 = Division.div(nArray, nArray2[0])[1];
                break;
            }
            case 2: {
                long l = ((long)nArray2[0] & 0xFFFFFFFFL) << 32 | (long)nArray2[1] & 0xFFFFFFFFL;
                nArray3 = Division.div(nArray, l)[1];
                break;
            }
            default: {
                nArray3 = Division.div(nArray, nArray2)[1];
            }
        }
        return nArray3[0] == 0 ? Arrays.stripLeadingZeroes(nArray3) : nArray3;
    }

    static int[][] divmod(int[] nArray, long l) {
        int[][] nArray2 = Division.div(nArray, l);
        if (0 < nArray2[0].length && nArray2[0][0] == 0) {
            nArray2[0] = Arrays.stripLeadingZeroes(nArray2[0]);
        }
        if (nArray2[1][0] == 0) {
            nArray2[1] = Arrays.stripLeadingZeroes(nArray2[1]);
        }
        return nArray2;
    }

    static int[][] divmod(int[] nArray, int[] nArray2) {
        int[][] nArray3;
        switch (nArray2.length) {
            case 1: {
                nArray3 = Division.div(nArray, nArray2[0]);
                break;
            }
            case 2: {
                long l = ((long)nArray2[0] & 0xFFFFFFFFL) << 32 | (long)nArray2[1] & 0xFFFFFFFFL;
                nArray3 = Division.div(nArray, l);
                break;
            }
            default: {
                nArray3 = Division.div(nArray, nArray2);
            }
        }
        if (0 < nArray3[0].length && nArray3[0][0] == 0) {
            nArray3[0] = Arrays.stripLeadingZeroes(nArray3[0]);
        }
        if (nArray3[1][0] == 0) {
            nArray3[1] = Arrays.stripLeadingZeroes(nArray3[1]);
        }
        return nArray3;
    }

    static int[] from(BigInteger bigInteger, int n) {
        int n2 = Math.min((bigInteger.bitLength() >>> 5) + 1, n);
        int[] nArray = new int[n2];
        while (0 < n2) {
            nArray[--n2] = bigInteger.and(BIG_INT).intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return 0 < nArray.length && nArray[0] == 0 ? Arrays.stripLeadingZeroes(nArray) : nArray;
    }

    static int[] from(byte[] byArray, int[] nArray) {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return ZERO;
        }
        for (n = 0; n < n2 && byArray[n] == 0; ++n) {
        }
        int n3 = Math.min(nArray.length, n2 - n + 3 >>> 2);
        int[] nArray2 = new int[n3];
        int n4 = n2 - 1;
        for (int i = n3 - 1; 0 <= i; --i) {
            nArray2[i] = byArray[n4--] & 0xFF;
            int n5 = Math.min(3, n4 - n + 1);
            for (int j = 8; j <= n5 << 3; j += 8) {
                int n6 = i;
                nArray2[n6] = nArray2[n6] | (byArray[n4--] & 0xFF) << j;
            }
        }
        return nArray2;
    }

    static int[] maxValue(int n) {
        int[] nArray = new int[n];
        java.util.Arrays.fill(nArray, -1);
        return nArray;
    }

    static {
        Arrays.CACHE[0] = new int[0];
        for (int i = 1; i < 28; ++i) {
            Arrays.CACHE[i] = new int[]{i};
        }
        ZERO = CACHE[0];
        ONE = CACHE[1];
        TWO = CACHE[2];
        BIG_INT = BigInteger.valueOf(0xFFFFFFFFL);
    }
}

