/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc.Binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class Primitives {
    public static boolean readBoolean(ByteArrayInputStream byteArrayInputStream) {
        return byteArrayInputStream.read() == 1;
    }

    public static void writeBoolean(ByteArrayOutputStream byteArrayOutputStream, boolean bl) {
        byteArrayOutputStream.write(bl ? 1 : 0);
    }

    public static int readVarint32(ByteArrayInputStream byteArrayInputStream) {
        byte by = (byte)byteArrayInputStream.read();
        if (0 <= by) {
            return by;
        }
        int n = by & 0x7F;
        by = (byte)byteArrayInputStream.read();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = (byte)byteArrayInputStream.read();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = (byte)byteArrayInputStream.read();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    n |= (by & 0x7F) << 21;
                    by = (byte)byteArrayInputStream.read();
                    n |= by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (0 > (byte)byteArrayInputStream.read()) continue;
                            return n;
                        }
                        throw new RuntimeException("Invalid varint.");
                    }
                }
            }
        }
        return n;
    }

    public static void writeVarint32(ByteArrayOutputStream byteArrayOutputStream, int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                byteArrayOutputStream.write(n);
                return;
            }
            byteArrayOutputStream.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int readUnsigned32(ByteArrayInputStream byteArrayInputStream) {
        return Primitives.readVarint32(byteArrayInputStream);
    }

    public static void writeUnsigned32(ByteArrayOutputStream byteArrayOutputStream, int n) {
        Primitives.writeVarint32(byteArrayOutputStream, n);
    }

    public static long readVarint64(ByteArrayInputStream byteArrayInputStream) {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = (byte)byteArrayInputStream.read();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw new RuntimeException("Invalid varint.");
    }

    public static void writeVarint64(ByteArrayOutputStream byteArrayOutputStream, long l) {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                byteArrayOutputStream.write((int)l);
                return;
            }
            byteArrayOutputStream.write((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static long readInt64(ByteArrayInputStream byteArrayInputStream) {
        return Primitives.readVarint64(byteArrayInputStream);
    }

    public static void writeInt64(ByteArrayOutputStream byteArrayOutputStream, long l) {
        Primitives.writeVarint64(byteArrayOutputStream, l);
    }

    public static long readUnsigned64(ByteArrayInputStream byteArrayInputStream) {
        return Primitives.readVarint64(byteArrayInputStream);
    }

    public static void writeUnsigned64(ByteArrayOutputStream byteArrayOutputStream, long l) {
        Primitives.writeVarint64(byteArrayOutputStream, l);
    }

    public static int readInt32(ByteArrayInputStream byteArrayInputStream) {
        return Primitives.readVarint32(byteArrayInputStream);
    }

    public static void writeInt32(ByteArrayOutputStream byteArrayOutputStream, int n) {
        if (0 <= n) {
            Primitives.writeVarint32(byteArrayOutputStream, n);
        } else {
            Primitives.writeVarint64(byteArrayOutputStream, n);
        }
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }

    public static int readSigned32(ByteArrayInputStream byteArrayInputStream) {
        return Primitives.decodeZigZag32(Primitives.readVarint32(byteArrayInputStream));
    }

    public static void writeSigned32(ByteArrayOutputStream byteArrayOutputStream, int n) {
        Primitives.writeVarint32(byteArrayOutputStream, Primitives.encodeZigZag32(n));
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    public static long readSigned64(ByteArrayInputStream byteArrayInputStream) {
        return Primitives.decodeZigZag64(Primitives.readVarint64(byteArrayInputStream));
    }

    public static void writeSigned64(ByteArrayOutputStream byteArrayOutputStream, long l) {
        Primitives.writeVarint64(byteArrayOutputStream, Primitives.encodeZigZag64(l));
    }

    public static int readFixed32(ByteArrayInputStream byteArrayInputStream) {
        return byteArrayInputStream.read() | byteArrayInputStream.read() << 8 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 24;
    }

    public static void writeFixed32(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n >> 16 & 0xFF);
        byteArrayOutputStream.write(n >> 24 & 0xFF);
    }

    public static long readFixed64(ByteArrayInputStream byteArrayInputStream) {
        return (long)byteArrayInputStream.read() & 0xFFL | ((long)byteArrayInputStream.read() & 0xFFL) << 8 | ((long)byteArrayInputStream.read() & 0xFFL) << 16 | ((long)byteArrayInputStream.read() & 0xFFL) << 24 | ((long)byteArrayInputStream.read() & 0xFFL) << 32 | ((long)byteArrayInputStream.read() & 0xFFL) << 40 | ((long)byteArrayInputStream.read() & 0xFFL) << 48 | ((long)byteArrayInputStream.read() & 0xFFL) << 56;
    }

    public static void writeFixed64(ByteArrayOutputStream byteArrayOutputStream, long l) {
        byteArrayOutputStream.write((int)l & 0xFF);
        byteArrayOutputStream.write((int)(l >> 8) & 0xFF);
        byteArrayOutputStream.write((int)(l >> 16) & 0xFF);
        byteArrayOutputStream.write((int)(l >> 24) & 0xFF);
        byteArrayOutputStream.write((int)(l >> 32) & 0xFF);
        byteArrayOutputStream.write((int)(l >> 40) & 0xFF);
        byteArrayOutputStream.write((int)(l >> 48) & 0xFF);
        byteArrayOutputStream.write((int)(l >> 56) & 0xFF);
    }

    public static double readDouble(ByteArrayInputStream byteArrayInputStream) {
        return Double.longBitsToDouble(Primitives.readFixed64(byteArrayInputStream));
    }

    public static void writeDouble(ByteArrayOutputStream byteArrayOutputStream, double d) {
        Primitives.writeFixed64(byteArrayOutputStream, Double.doubleToLongBits(d));
    }

    public static float readFloat(ByteArrayInputStream byteArrayInputStream) {
        return Float.intBitsToFloat(Primitives.readFixed32(byteArrayInputStream));
    }

    public static void writeFloat(ByteArrayOutputStream byteArrayOutputStream, float f) {
        Primitives.writeFixed32(byteArrayOutputStream, Float.floatToIntBits(f));
    }
}

