/*
 * Decompiled with CFR 0.152.
 */
package ai.z7.blockchain_misc;

import java.io.IOException;
import java.util.Arrays;

public class Base58 {
    public static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final char ENCODED_ZERO = ALPHABET[0];
    private static final int[] INDEXES = new int[128];

    public static String encode(byte[] byArray) {
        int n;
        if (byArray.length == 0) {
            return "";
        }
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byArray = Arrays.copyOf(byArray, byArray.length);
        char[] cArray = new char[byArray.length * 2];
        int n2 = cArray.length;
        int n3 = n;
        while (n3 < byArray.length) {
            cArray[--n2] = ALPHABET[Base58.divmod(byArray, n3, 256, 58)];
            if (byArray[n3] != 0) continue;
            ++n3;
        }
        while (n2 < cArray.length && cArray[n2] == ENCODED_ZERO) {
            ++n2;
        }
        while (--n >= 0) {
            cArray[--n2] = ENCODED_ZERO;
        }
        return new String(cArray, n2, cArray.length - n2);
    }

    public static byte[] decode(String string) throws IOException {
        int n;
        int n2;
        if (string.length() == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length()];
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            int n3 = n = c < '\u0080' ? INDEXES[c] : -1;
            if (n < 0) {
                throw new IOException();
            }
            byArray[n2] = (byte)n;
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        byte[] byArray2 = new byte[string.length()];
        n = byArray2.length;
        int n4 = n2;
        while (n4 < byArray.length) {
            byArray2[--n] = Base58.divmod(byArray, n4, 58, 256);
            if (byArray[n4] != 0) continue;
            ++n4;
        }
        while (n < byArray2.length && byArray2[n] == 0) {
            ++n;
        }
        return Arrays.copyOfRange(byArray2, n - n2, byArray2.length);
    }

    private static byte divmod(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i < byArray.length; ++i) {
            int n5 = byArray[i] & 0xFF;
            int n6 = n4 * n2 + n5;
            byArray[i] = (byte)(n6 / n3);
            n4 = n6 % n3;
        }
        return (byte)n4;
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

