/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.Map;

public final class MethodImplCache {
    public final IPersistentMap protocol;
    public final Keyword methodk;
    public final int shift;
    public final int mask;
    public final Object[] table;
    public final Map map;
    Entry mre = null;

    public MethodImplCache(IPersistentMap protocol, Keyword methodk) {
        this(protocol, methodk, 0, 0, RT.EMPTY_ARRAY);
    }

    public MethodImplCache(IPersistentMap protocol, Keyword methodk, int shift, int mask, Object[] table2) {
        this.protocol = protocol;
        this.methodk = methodk;
        this.shift = shift;
        this.mask = mask;
        this.table = table2;
        this.map = null;
    }

    public MethodImplCache(IPersistentMap protocol, Keyword methodk, Map map2) {
        this.protocol = protocol;
        this.methodk = methodk;
        this.shift = 0;
        this.mask = 0;
        this.table = null;
        this.map = map2;
    }

    public IFn fnFor(Class c) {
        Entry last = this.mre;
        if (last != null && last.c == c) {
            return last.fn;
        }
        return this.findFnFor(c);
    }

    IFn findFnFor(Class c) {
        if (this.map != null) {
            Entry e2;
            this.mre = e2 = (Entry)this.map.get(c);
            return e2 != null ? e2.fn : null;
        }
        int idx = (Util.hash(c) >> this.shift & this.mask) << 1;
        if (idx < this.table.length && this.table[idx] == c) {
            Entry e3;
            this.mre = e3 = (Entry)this.table[idx + 1];
            return e3 != null ? e3.fn : null;
        }
        return null;
    }

    public static class Entry {
        public final Class c;
        public final IFn fn;

        public Entry(Class c, IFn fn2) {
            this.c = c;
            this.fn = fn2;
        }
    }
}

