(ns ags799.boot-docker
  {:boot/export-tasks true}
  (:require [boot.core :as boot]
            [clojure.java.shell :refer [sh]]
            [clojure.java.io :as io]))

(defn- default-dockerfile [jar-path]
  (let [entrypoint (format "ENTRYPOINT [\"java\",\"-jar\",\"%s\"]" jar-path)]
    (clojure.string/join "\n" ["FROM openjdk:8-jre"
                               (format "COPY %s ." jar-path)
                               entrypoint])))

(defn- spit-default-dockerfile [dockerfile jar-path]
  (spit dockerfile (default-dockerfile jar-path)))

(defn- find-jar [files]
  (boot/tmp-path (first (boot/by-ext [".jar"] files))))

(boot/deftask dockerfile
  "Creates a generic Dockerfile at the root of the project.

  Note that your application may require a custom Dockerfile, in which case
  you shouldn't use this step at all.

  The generated Dockerfile loads a jar onto a Java 8 JRE image and sets the
  entrypoint to `java -jar the-jar.jar`."
  []
  (boot/with-pre-wrap fileset
    (let [jar-path (find-jar (boot/output-files fileset))
          tmp (boot/tmp-dir!)
          dockerfile (io/file tmp "Dockerfile")]
      (spit-default-dockerfile dockerfile jar-path)
      (boot/commit! (boot/add-resource fileset tmp)))))
