(ns aft.reframe.core
  (:require
    [re-frame.core :as reframe]
    [re-frame.db :as db]

    ;; not used but required for auto-registration
    ;; https://github.com/Day8/re-frame-async-flow-fx#step-3-registration-and-use
    [day8.re-frame.async-flow-fx]

    [aft.reframe.interceptors :as intc]
    )
  (:require-macros
    [aft.logging.core :refer [error]]
    )
  )

(def set-schema! intc/set-schema!)

(defn reg-sub-raw
  [& args]
  (apply reframe/reg-sub-raw args))

(defn reg-sub
  [& args]
  (apply reframe/reg-sub args))

(defn reg-fx
  [& args]
  (apply reframe/reg-fx args))

(defn subscribe
  [& args]
  (apply reframe/subscribe args))

(defn dispatch
 [& args]
 (apply reframe/dispatch args))

(defn dispatch-sync
 [& args]
 (apply reframe/dispatch-sync args))

(defn reg-event-db
  "Register a db handler that automatically uses app-wide default interceptors.
  Optionally provide additional interceptors (as a vec) to include after the
  default."
  ([id handler]
    (reframe/reg-event-db id intc/default-interceptors handler))
  ([id more handler]
    (if-not (vector? more)
      (error "re-frame: registering a handler with additional
                   interception requires that interceptor to be inside a vector.")
      ;; re-frame will flatten and remove nil, so nested vecs is fine
      (reframe/reg-event-db id [intc/default-interceptors more] handler))))

(defn reg-event-fx
  "Register an fx handler that automatically uses app-wide default interceptors.
  Optionally provide additional interceptors (as a vec) to include after the
  default."
  ([id handler]
     (reframe/reg-event-fx id intc/default-interceptors handler))
  ([id more handler]
   (if-not (vector? more)
     (error "re-frame: registering a handler with additional
                     middleware requires that middleware to be inside a vector.")
      ;; re-frame will flatten and remove nil, so nested vecs is fine
     (reframe/reg-event-fx id [intc/default-interceptors more] handler))))

(defn db
  "Return the reframe db (a ratom). Mostly useful for debugging."
  []
  db/app-db)
