(ns afrey.ring-htm5-handler
  (:require [ring.util.response :refer [file-response]]
            [ring.middleware
             [file :refer [wrap-file]]
             [resource :refer [wrap-resource]]]))

(defonce dir "target/")

(defn- handler
  "Route any unhandled requests to index.html"
  [request]
  (assoc-in (file-response (str dir "index.html"))
            [:headers "Content-Type"]
            "text/html;charset=ISO-8859-1"))

(def app-handler (-> handler
                     (wrap-resource "")
                     (wrap-file dir {:index-files? false})))
