(ns aerial.saite.templates
  (:require [aerial.hanami.templates :as ht]
            [aerial.hanami.common :as hc]))



(def stacked-sq-cnt-chart
  {:background :BACKGROUND

   :data {:values :DATA}

   :title  {:text :TEXT :offset 5}

   :vconcat
   [{:transform [{:filter {:field "nm" :equal :NM1}}]
     :mark "bar"
     :height 500
     :width  1500
     :encoding {:x {:field :X
                    :type "nominal"
                    :axis {:title :XTITLE}
                    ;;:sort "none"
                    }
                :y {:field :Y
                    :type "quantitative"
                    :axis {:title :YTITLE}}
                :tooltip {:field "tt" :type "nominal"}
                :color {:field "nm" :type "nominal"
                        :scale {:range ["steelblue" "indianred"]}
                        :legend {:type "symbol"
                                 :offset 5
                                 :title "NM"}}}}
    {:transform [{:filter {:field "nm" :equal :NM2}}]
     :mark "bar"
     :height 500
     :width  1500
     :encoding {:x {:field :X
                    :type "nominal"
                    :axis {:title :XTITLE}
                    ;;:sort "none"
                    }
                :y {:field :Y
                    :type "quantitative"
                    :axis {:title :YTITLE}}
                :tooltip {:field "tt" :type "nominal"}
                :color {:field "nm" :type "nominal"
                        :legend {:type "symbol"
                                 :offset 5
                                 :title "NM"}}}}
    {:transform [{:filter {:field "nm" :equal :NM3}}]
     :mark "bar"
     :height 500
     :width  1500
     :encoding {:x {:field :X
                    :type "nominal"
                    :axis {:title :XTITLE}
                    ;;:sort "none"
                    }
                :y {:field :Y
                    :type "quantitative"
                    :axis {:title :YTITLE}}
                :tooltip {:field "tt" :type "nominal"}
                :color {:field "nm" :type "nominal"
                        :legend {:type "symbol"
                                 :offset 5
                                 :title "NM"}}}}]
   })




(def ident-num-by-lens
  {:title  {:text :TITLE}
   :height :HEIGHT
   :width  :WIDTH
   :background :BACKGROUND
   :layer [{;:transform [{:filter {:field "sz" :range [1,21#_70]}}]
            :selection {:grid
                        {:type "interval",
                         :bind "scales", ; <-- This gives zoom and pan
                         :zoom "wheel!",
                         :resolve "global"}}
            :mark "bar"
            :encoding {:x {:field :X
                           :axis {:title "Seq Length"}
                           :type :XTYPE}
                       :y {:field :Y
                           :axis {:title "Number"}
                           :type :YTYPE}
                       :tooltip {:field "tt" :type "nominal"}
                       }}
           {:mark "rule"
            :encoding {:x {:field :X
                           :type "quantitative"
                           :aggregate "median"}
                       :size {:value 2}
                       :color {:value "red"}}}]

   :data {:values :DATA}

   :config {:bar {:binSpacing 0
                  :discreteBandSize 10}
            :view {:stroke "transparent"},
            :axis {:domainWidth 1}
            :scale {;;:textXRangeStep 10
                    }}})





