(ns adzerk.clj-kinesis-producer.queue
  (:require 
    [durable-queue :as queue]))

(defprotocol IQueue
  (put!   [this topic data timeout])
  (take!  [this topic timeout process])
  (stats  [this]))

(defrecord Queue [queue]
  IQueue
  (stats [this]
    (queue/stats queue))
  (put! [this topic data timeout]
    (when-not (queue/put! queue topic data timeout)
      (throw (ex-info "Timeout enqueueing." {:reason "timeout"}))))
  (take! [this topic timeout process]
    (let [item (queue/take! queue topic timeout ::timeout)]
      (when-not (= item ::timeout)
        (try (let [ret (process @item)]
               (if ret
                 (queue/complete! item)
                 (queue/retry! item))
               ret)
             (catch Throwable t (queue/complete! item) (throw t)))))))

(defn make-queue
  [dir-path & [{:keys [complete? max-queue-size slab-size fsync-put?
                       fsync-take?  fsync-threshold fsync-interval]
                :as queue-options}]]
  (Queue. (queue/queues dir-path queue-options)))

