(ns adzerk.clj-kinesis-producer.core
  (:require
    [cheshire.core :as json]
    [adzerk.clj-kinesis-producer.queue :as q]
    [adzerk.clj-kinesis-producer.worker :as w]
    [adzerk.clj-kinesis-producer.kinesis :as k]))

(defn put-record!
  [worker data]
  (w/put! worker data))

(defn start!
  [worker]
  (w/start! worker))

(defn stop!
  [worker]
  (w/stop! worker))

(defn kinesis-producer
  [stream-name & [{:keys [on-success on-error]}]]
  (let [q (q/make-queue "/tmp/durable-queues" {:fsync-put? false :fsync-interval 100})
        k (k/producer {:region "us-east-1" :request-timeout 500 :record-max-buffered-time 10000})
        p #(let [rec (json/generate-string %)]
             (k/put-record k stream-name (k/random-key) rec))
        s (or on-success #(when % (prn %)))
        e (or on-error #(when % (.printStackTrace %)))]
    (w/worker q :records p s e 1000 100 2)))
