(ns adtile.lambda.core
  (:require [uswitch.lambada.core :refer [deflambdafn]]
            [clojure.string :refer [split]]
            [clojure.set :refer [intersection]]
            [clojure.tools.logging :as log]
            [cheshire.core :refer [parse-stream generate-stream generate-string parse-string]]
            [clojure.java.io :as io])
  (:import [com.amazonaws.services.lambda.runtime Context]
           [org.slf4j LoggerFactory]
           [ch.qos.logback.classic.joran JoranConfigurator]
           [java.io ByteArrayInputStream ByteArrayOutputStream]))

(defn- configure-env []
  (if-let [env (System/getenv "NOMAD_ENV")]
    (when (not= "local" env) (System/setProperty "logback.configurationFile" "logback-production.xml"))
    (throw (RuntimeException. "NOMAD_ENV not configured"))))

(defn handle-invoke [is os context handler-fn]
  (configure-env)
  (with-open [writer (io/writer os)]
    (let [payload (parse-stream (io/reader is :encoding "UTF-8") true)
          output (handler-fn context payload writer)]
      (when output (generate-stream output writer))
      nil)))

(defn mock-context [function-name]
  (reify Context
    (getFunctionName [this]
      function-name)))

(defn local-invoke [handler-fn payload]
  (let [context (mock-context (str "adtile-local-testlambda"))
        is (ByteArrayInputStream. (.getBytes (generate-string payload)))
        os (ByteArrayOutputStream.)]
    (handle-invoke is os context handler-fn)
    (parse-string (String. (.toByteArray os) "UTF-8") true)))

