(ns coendou.protocols)

(defprotocol IConcurrencyControl
  (change-limit! [_ n])
  (in-flight [_]))

(defprotocol ISemaphore
  (acquire! [_])
  (release! [_]))

(defprotocol IQueue
  (unsafe-queue! [_])
  (queue! [_])
  (dequeue! [_]))

(defprotocol IReport
  (report-execution [ctx type report]))

(defprotocol ISubscribeReport
  (report-subscription [_ topic]))

(defprotocol IContext
  (get-context [_]))

(defprotocol ICommand
  (execute-command [ctx cmd args]))

(defprotocol ILifecycle
  (start [component])
  (stop [component]))
