# Coendou

Coendou tries to offer similar functionality as Hystrix i.e. resilience patterns and out of the box monitoring. It is also build with extensibility in mind. Adding new patterns and new monitoring options is possible (see below).

## Usage

### Configuration

Everything that is configurable can be dynamically configured via the registry. To see what is in the registry call `(coendou.registry/registry-snaphot coendou)` on a Coendou record instance.

E.g. if you start the app in the examples/coendou-http project:
```clojure
(go)
(registry/registry-snapshot (:coendou system))
; {:semaphores {:bid-requests {:limit 50, :in-flight 0}}, :queues {:bid-requests {:limit 1000, :in-flight 0}}, :threadpools {}, :commands {:key-value {}, :bid-request {:queue [:queues :bid-requests], :semaphore [:semaphores :bid-requests], :timeout-ms 1000}}}
```

Changing the `timeout-ms` to 0 will timeout all requests
```clojure
(registry/set-registry!  (:coendou system) [:commands :bid-request :timeout-ms] 0)
```

### Monitoring

The Hystrix output is meant to be compatible with the normal Hystrix output so you can use all the tools they provide ([Turbine](https://github.com/Netflix/Turbine/wiki), [Hystrix Dashboard](https://github.com/Netflix/Hystrix/wiki/Dashboard)). Some metrics are not correct or are missing (e.g. Rejected, BadRequest metrics and Threadpool metrics). This is work in progress. 


### Extension points

#### Custom patterns 

Custom patterns can be added by creating wrapper functions (see the commands namespace for examples)

#### Reporting

Coendou provides access to a stream of command sessions. Each session is a collection of metrics around the commands that were executed in one session (the execution of a parent command with subcommands, e.g. an http request). The hystrix namespace is an example of a reporting extension.

## License

Copyright © 2016 AdGoji

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
