(ns coendou.tdigest
  (:require [clojure.spec :as s])
  (:import [com.tdunning.math.stats TDigest]))

(s/def :percentile/digest (fn [x] (instance? TDigest x)))

(defn new-tdigest
  ^com.tdunning.math.stats.TDigest
  [compression]
  (TDigest/createDigest compression))

(defn get-compression
  ^double [^TDigest tdigest]
  (.compression tdigest))

(defn tdigest-add
  ^com.tdunning.math.stats.TDigest
  [^TDigest tdigest value]
  (.add tdigest (double value))
  tdigest)

(defn merge-tdigests!
  "Mutates the first tdigest, the base. Threadsafety not guaranteed"
  ^com.tdunning.math.stats.TDigest
  [^TDigest tdigest-base ^TDigest tdigest-other]
  ;; Assert on compression? (via spec)
  (.add tdigest-base tdigest-other)
  tdigest-base)

(defn combine-tdigests
  "Creates a new tdigest, no mutation"
  ^com.tdunning.math.stats.TDigest
  [tdigests]
  (when-let [first-tdigest (first tdigests)]
    (let [base-tdigest (new-tdigest (get-compression first-tdigest))]
      (reduce merge-tdigests! base-tdigest tdigests))))

(defn quantile ^double [^TDigest tdigest q]
  (.quantile tdigest q))

(defn round-quantile [^TDigest tdigest quantile-value]
  (if tdigest
   ; (quantile tdigest quantile-value)
    (/ (Math/round (* 1000 (quantile tdigest quantile-value))) 1000.0)
    0.0))
