(ns coendou.specs
  (:require [clojure.spec :as s]
            [clojure.future :refer :all]

            ;; For special types
            [coendou.tdigest]

            [coendou
             [queue :refer [queue?]]
             [semaphore :refer [semaphore?]]] ))

(s/def :event/count integer?)

(s/def :event/event (s/keys :req-un [:event/count]))




(s/def :event/type keyword? ;#{:success :error }
  )


(s/def :reporting/nano-time integer?)
(s/def :event/start :reporting/nano-time)
(s/def :event/end :reporting/nano-time)


(s/def :event/prefix any?)
(s/def :event/cmd any?)
(s/def :reporting/event (s/keys :req-un [:event/type
                                         :event/start
                                         :event/end
                                         :event/prefix
                                         :event/cmd]))
(s/def :reporting/events (s/coll-of :reporting/event))

(s/def :event/percentile-digest :percentile/digest)
(s/def :event/counts (s/map-of :event/type :event/count))
(s/def :reporting/aggregated-event (s/keys :req-un [:event/counts
                                                    :event/count
                                                    :event/percentile-digest]))

(s/def :reporting/aggregated-events (s/coll-of :reporting/aggregated-event))

(s/def :coendou/fn fn?)

(defn atom? [x]
  (instance? clojure.lang.Atom x))

(defn integer-state? [x]
  (and (atom? x)
       (integer? @x)))

(s/def :coendou/start-timeout-ns integer?)
(s/def :coendou/timeout-ms integer?)

(s/def :coendou.command/start-timeout-ns integer-state?)
(s/def :coendou.command/timeout-ms integer-state?)

(s/def :coendou/priority? boolean?)
(s/def :coendou/nano-time-fn :coendou/fn)
(s/def :coendou/ms-time-fn :coendou/fn)

(def value? (complement fn?))

(s/def :coendou/fallback-value value?)
(s/def :coendou/fallback fn?)

(s/def :coendou/id keyword?)
(s/def :coendou/name string?)
(s/def :coendou/semaphore-name keyword?)
(s/def :coendou/semaphore semaphore?)
(s/def :coendou/queue-name keyword?)
(s/def :coendou/queue queue?)

(s/def :coendou/action-fn fn?)

(s/def :coendou/action-deferred? boolean?)

(defn spec-keys [& args]
  (eval (list* 'clojure.spec/keys args)))

(s/def :coendou/error-fallback :coendou/fallback)
(s/def :coendou.command/error-handler fn?)

(def error-handling-keys [:coendou/error-fallback
                          :coendou.command/error-handler])

(s/def :command.part/error-handling
  (spec-keys :req-un error-handling-keys))


(s/def :coendou/start-timeout-fallback :coendou/fallback)

(def start-timeout-keys [:coendou/start-timeout-fallback
                         :coendou.command/start-timeout-ns
                         :coendou/nano-time-fn])

(s/def :command.part/start-timeout
  (spec-keys :req-un start-timeout-keys))


(def semaphore-keys [:coendou/semaphore])

(s/def :command.part/semaphore
  (spec-keys :req-un semaphore-keys))

(s/def :command.part/semaphore-priority :command.part/semaphore)


(s/def :coendou/timeout-fallback :coendou/fallback)

(def timeout-keys [:coendou/timeout-fallback
                   :coendou.command/timeout-ms])

(s/def :command.part/timeout
  (spec-keys :req-un timeout-keys))


(s/def :coendou/queue-rejected-fallback :coendou/fallback)

(def queue-keys [:coendou/queue-rejected-fallback
                 :coendou/queue])

(s/def :command.part/queue
  (spec-keys :req-un queue-keys))

(def queue-priority-keys [:coendou/queue])

(s/def :command.part/queue-priority
  (spec-keys :req-un queue-priority-keys))

(def reporting-keys [:coendou/id
                     :coendou/nano-time-fn
                     :coendou/ms-time-fn])

(s/def :command.part/reporting
  (spec-keys :req-un reporting-keys))


(def base-command-keys
  (into []
        (distinct
         (concat
          error-handling-keys
          start-timeout-keys
          semaphore-keys
          timeout-keys
          queue-keys
          queue-priority-keys
          reporting-keys))))

;; ~base-command-keys isn't enougn, needing eval here. Weirdly enough it works for :req-un
(s/def :coendou.command/base-command
  (spec-keys
   :req-un [:coendou/id
            :coendou/name
            :coendou/action-fn
            :coendou/fallback
            :coendou.command/error-handler]

   :opt-un base-command-keys))

(s/def :coendou.command/command
  (s/merge :coendou.command/base-command (s/keys :req-un [:coendou/action-fn])))

(s/def :coendou/error-fallback-value :coendou/fallback-value)
(s/def :coendou/start-timeout-value :coendou/fallback-value)
(s/def :coendou/timeout-fallback-value :coendou/fallback-value)
(s/def :coendou/queue-rejected-fallback-value :coendou/fallback-value)

(s/def :coendou/base-command
  (s/keys
   :req-un [:coendou/id
            :coendou/name
            :coendou.command/error-handler]

   :opt-un
   [:coendou/fallback-value
    :coendou/fallback

    :coendou/error-fallback-value
    :coendou/error-fallback

    :coendou/start-timeout-value
    :coendou/start-timeout-fn
    :coendou/start-timeout-ns
    :coendou/start-timeout-ms
    :coendou/nano-time-fn

    :coendou/semaphore

    :coendou/timeout-fallback-value
    :coendou/timeout-fallback
    :coendou/timeout-ms

    :coendou/queue-rejected-fallback-value
    :coendou/queue-rejected-fallback

    :coendou/queue]))


(s/def :coendou/deferred-command
  (s/merge :coendou/base-command (s/keys :req-un [:coendou/deferred-fn])))

(s/def :coendou/sync-command
  (s/merge :coendou/base-command (s/keys :req-un [:coendou/fn])))


(defn get-command-type [command]
  (cond
    (:fn command) :coendou/sync-command
    (:deferred-fn command) :coendou/deferred-command))

(defmulti command-type #'get-command-type)

(defmethod command-type :coendou/sync-command [_] :coendou/sync-command)
(defmethod command-type :coendou/deferred-command [_] :coendou/deferred-command)

(s/def :coendou/command (s/multi-spec command-type :command/type))
