(ns coendou.reporting.timelines)

(defn create-timeline [session]
  ;; REVIEW Poor and inefficient implementation probably to create a tree
  (let [sorted-sessions (sort-by :start-nanos session)
        tree (loop [timeline {}
                    [{:keys [prefix id type start start-nanos end-nanos] :as f} & t] sorted-sessions]
               (if prefix
                 (let [nested-path (conj (vec (butlast (interleave prefix (repeat :nested)))) :cmd)]
                   (recur (assoc-in timeline nested-path [id type start start-nanos end-nanos]) t))
                 timeline))]
    tree
    (vec (first (vals (clojure.walk/postwalk (fn [{:keys [cmd nested] :as x}]
                                               (if cmd
                                                 (if nested
                                                   [cmd (vec (vals nested))]
                                                   [cmd])
                                                 x))
                                             tree))))))
