/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.StringTokenizer;

public class StringTool
implements Serializable {
    static final long serialVersionUID = -2761264230959133529L;
    String oneslash = String.valueOf('\\');
    String twoslash = String.valueOf(this.oneslash) + this.oneslash;

    public static String convertXMLChars(String rep) {
        return OOXMLAdapter.stripNonAscii(rep).toString();
    }

    public static void main(String[] args) {
        String majorHTML = "<html><body>Testing <b>yes</b><ul><li>item1</li><li>item2</li><li>item3</li></ul><br/>newline<br/>newline2<BR/>newline3 yes no 124<>something <bR>newline4<b>bold</b></body></html>";
        Logger.logInfo(StringTool.stripHTML(majorHTML));
    }

    public static String stripHTML(String rep) {
        rep = rep.replaceAll("<[B,b][R,r]?>", "\r\n");
        rep = rep.replaceAll("<[B,b][R,r]?/>", "\r\n");
        rep = rep.replaceAll("<[L,l][I,i]?>", "\r\n\r\n");
        StringBuffer ret = new StringBuffer();
        char[] cx = rep.toCharArray();
        boolean skipping = false;
        int t = 0;
        while (t < cx.length) {
            char tt = cx[t];
            if (tt == '<') {
                skipping = true;
                ++t;
            } else if (tt == '>') {
                skipping = false;
            }
            if (!skipping && tt != '>') {
                ret.append(cx[t]);
            }
            ++t;
        }
        return ret.toString();
    }

    public static String convertHTML(String rep) {
        rep.replaceAll("&amp;", "&");
        rep.replaceAll("&apos;", "'");
        rep.replaceAll("&quot;", "\"");
        rep.replaceAll("&lt;", "<");
        rep.replaceAll("&gt;", ">");
        rep.replaceAll("&copy;", "");
        return rep;
    }

    public static String stripMatch(String pattern, String matchstr) {
        String upat = pattern.toUpperCase();
        String umat = matchstr.toUpperCase();
        String retval = "";
        if (umat.lastIndexOf(upat) > -1) {
            int pos = umat.lastIndexOf(upat) + upat.length();
            retval = matchstr.substring(pos);
            Logger.logInfo("foundpos: " + pos);
        }
        return retval;
    }

    public static String getVarNameFromGetMethod(String thismethod) {
        int getidx = thismethod.indexOf("get");
        if (getidx < 0) {
            return "";
        }
        String retval = thismethod.substring(getidx + 3);
        retval = retval.substring(0, retval.length() - 2);
        String upcase = retval.substring(0, 1);
        upcase = upcase.toUpperCase();
        retval = retval.substring(1);
        retval = String.valueOf(upcase) + retval;
        return retval;
    }

    public static String convertJavaStyletoDBConvention(String name) {
        char[] chars = name.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            if (Character.isUpperCase(chars[i])) {
                if (i > 0 && i + 1 < chars.length && !Character.isUpperCase(chars[i + 1])) {
                    buf.append("_");
                }
                buf.append(chars[i]);
            } else {
                buf.append(Character.toUpperCase(chars[i]));
            }
            ++i;
        }
        return buf.toString();
    }

    public static String convertJavaStyletoFriendlyConvention(String name) {
        if (name.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] chars = name.toCharArray();
        buf.append(String.valueOf(chars[0]).toUpperCase());
        int i = 1;
        while (i < chars.length) {
            if (chars[i] == '_') {
                chars[i++] = Character.toUpperCase(chars[i + 1]);
                buf.append(" ");
                buf.append(chars[i]);
            } else {
                buf.append(String.valueOf(chars[i]).toLowerCase());
            }
            ++i;
        }
        return buf.toString();
    }

    public static String arrayToString(Object[] objs) {
        StringBuffer ret = new StringBuffer("[");
        int x = 0;
        while (x < objs.length) {
            ret.append(objs[x].toString());
            ret.append(", ");
            ++x;
        }
        ret.setLength(ret.length() - 1);
        ret.append("]");
        return ret.toString();
    }

    public static final String stackTraceToString(Throwable target) {
        StringWriter trace = new StringWriter();
        PrintWriter writer = new PrintWriter(trace);
        target.printStackTrace(writer);
        writer.flush();
        return trace.toString();
    }

    public static String proper(String name) {
        if (name.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] chars = name.toCharArray();
        buf.append(String.valueOf(chars[0]).toUpperCase());
        int i = 1;
        while (i < chars.length) {
            if (chars[i] == ' ') {
                buf.append(" ");
                if (chars[++i] != ' ') {
                    chars[i] = Character.toUpperCase(chars[i]);
                    buf.append(chars[i]);
                }
            } else {
                buf.append(String.valueOf(chars[i]).toLowerCase());
            }
            ++i;
        }
        return buf.toString();
    }

    public static String makeDelimitedList(Object[] list, String delimiter) {
        StringBuffer listBuf = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            if (i != 0) {
                listBuf.append(delimiter);
            }
            listBuf.append(list[i].toString());
            ++i;
        }
        return listBuf.toString();
    }

    public static String[] splitString(String value, String delimeter) {
        StringTokenizer stoken = new StringTokenizer(value, delimeter);
        String[] returnValue = new String[stoken.countTokens()];
        int i = 0;
        while (stoken.hasMoreTokens()) {
            returnValue[i] = stoken.nextToken();
            ++i;
        }
        return returnValue;
    }

    public static String getCompressedUnicode(byte[] input) {
        byte[] output = new byte[input.length / 2];
        int pos = 0;
        int i = 0;
        while (i < input.length) {
            output[pos++] = input[i];
            ++i;
            ++i;
        }
        return new String(output);
    }

    public static String getSetMethodNameFromVar(String thismember) {
        String upcase = thismember.substring(0, 1);
        upcase = upcase.toUpperCase();
        thismember = thismember.substring(1);
        thismember = "set" + upcase + thismember;
        return thismember;
    }

    public static String getGetMethodNameFromVar(String thismember) {
        String upcase = thismember.substring(0, 1);
        upcase = upcase.toUpperCase();
        thismember = thismember.substring(1);
        thismember = "get" + upcase + thismember;
        return thismember;
    }

    public static String convertDBtoJavaStyleConvention(String name) {
        int scoreloc = name.indexOf("_");
        StringBuffer buf = new StringBuffer();
        if (scoreloc < 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '_') {
                chars[i + 1] = Character.toUpperCase(chars[i + 1]);
            } else {
                buf.append(chars[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String convertFilenameToJSPName(String name) {
        StringBuffer buf = new StringBuffer();
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '_') {
                chars[i + 1] = Character.toUpperCase(chars[i + 1]);
            } else if (chars[i] == '-') {
                chars[i + 1] = Character.toUpperCase(chars[i + 1]);
            } else if (chars[i] == ' ') {
                chars[i + 1] = Character.toUpperCase(chars[i + 1]);
            } else {
                buf.append(chars[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String[] getTokensUsingDelim(String instr, String token) {
        String st;
        if (instr.indexOf(token) < 0) {
            String[] ret = new String[]{instr};
            return ret;
        }
        CompatibleVector output = new CompatibleVector();
        new StringBuffer();
        int lastpos = 0;
        int offset = 0;
        int toklen = token.length();
        int pos = instr.indexOf(token);
        while (pos > -1) {
            offset = lastpos > 0 ? lastpos + toklen : 0;
            st = instr.substring(offset, pos);
            output.add(st);
            lastpos = pos;
            pos = instr.indexOf(token, lastpos + 1);
        }
        if (lastpos < instr.length()) {
            st = instr.substring(lastpos + toklen);
            output.add(st);
        }
        String[] retval = new String[output.size()];
        int i = 0;
        while (i < output.size()) {
            retval[i] = (String)output.get(i);
            ++i;
        }
        return retval;
    }

    public static String dbencode(String holder) {
        return StringTool.replaceText(holder, "'", "''", 0);
    }

    public static String allTrim(String holder) {
        holder = holder.trim();
        return StringTool.rTrim(holder);
    }

    public static String stripTrailingSpaces(String s) {
        while (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String strip(String tostrip, String stripstr) {
        StringBuffer stripped = new StringBuffer(tostrip.length());
        while (tostrip.indexOf(stripstr) > -1) {
            stripped.append(tostrip.substring(0, tostrip.indexOf(stripstr)));
            tostrip = tostrip.substring(tostrip.indexOf(stripstr) + stripstr.length());
        }
        stripped.append(tostrip);
        return stripped.toString();
    }

    public static String strip(String tostrip, char stripchar) {
        StringBuffer stripped = new StringBuffer(tostrip.length());
        int i = 0;
        while (i < tostrip.length()) {
            char currentChar = tostrip.charAt(i);
            if (currentChar == stripchar) {
                ++i;
                continue;
            }
            stripped.append(currentChar);
            ++i;
        }
        return stripped.toString();
    }

    public static String replaceText(String originalText, String replaceText, String replacementText, int offset, boolean skipmatch) {
        if (!skipmatch) {
            return StringTool.replaceText(originalText, replaceText, replacementText, offset);
        }
        StringBuffer sb = new StringBuffer();
        if (originalText.indexOf(replaceText) < 0) {
            return originalText;
        }
        int nextidx = 0;
        int lastidx = 0;
        int pos = 0;
        int textlen = replaceText.length();
        int stringlen = originalText.length();
        while (nextidx <= originalText.lastIndexOf(replaceText)) {
            nextidx = originalText.indexOf(replaceText, lastidx);
            sb.append(originalText.substring(lastidx, nextidx));
            if (++pos > offset) {
                sb.append(replacementText);
            } else {
                sb.append(replaceText);
            }
            nextidx += textlen;
            if (textlen == 0) break;
            lastidx = nextidx;
        }
        if (nextidx < stringlen) {
            sb.append(originalText.substring(nextidx));
        }
        return sb.toString();
    }

    public static String replaceText(String originalText, String replaceText, String replacementText, int offset) {
        int newlen = originalText.length() - replaceText.length() + replacementText.length();
        if (newlen < 1) {
            newlen = 0;
        }
        StringBuffer sb = new StringBuffer(newlen);
        if (originalText.indexOf(replaceText) < 0) {
            return originalText;
        }
        if (replaceText != null && replaceText.equals(replacementText)) {
            return originalText;
        }
        int nextidx = 0;
        int lastidx = 0;
        int textlen = replaceText.length();
        int stringlen = originalText.length();
        while (nextidx <= originalText.lastIndexOf(replaceText)) {
            nextidx = originalText.indexOf(replaceText, lastidx);
            sb.append(originalText.substring(lastidx, nextidx + offset));
            sb.append(replacementText);
            nextidx += textlen;
            if (textlen == 0) break;
            lastidx = nextidx;
        }
        if (nextidx < stringlen) {
            sb.append(originalText.substring(nextidx));
        }
        return sb.toString();
    }

    public static String rTrim(String originalText) {
        StringBuffer sb = new StringBuffer(originalText);
        sb.reverse();
        String rstr = sb.toString();
        rstr.trim();
        sb = new StringBuffer(rstr);
        sb.reverse();
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String getTextBetweenNestedDelims(String originalText, String beginDelim, String endDelim) {
        block3: {
            sb = new StringBuffer(originalText.length());
            if (originalText.indexOf(beginDelim) < 0 || originalText.lastIndexOf(endDelim) < 0) {
                return "";
            }
            begidx = originalText.indexOf(beginDelim) + beginDelim.length();
            endidx = originalText.lastIndexOf(endDelim);
            holder = 0;
            if (begidx >= endidx) ** GOTO lbl13
            sb.append(originalText.substring(begidx, endidx));
            break block3;
lbl-1000:
            // 1 sources

            {
                holder = endidx;
                endidx = originalText.lastIndexOf(endDelim, holder + 1);
lbl13:
                // 2 sources

                ** while (begidx > endidx && endidx > -1)
            }
lbl14:
            // 1 sources

            if (begidx < endidx && endidx > -1) {
                sb.append(originalText.substring(begidx, endidx));
            }
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String getTextBetweenDelims(String originalText, String beginDelim, String endDelim) {
        block3: {
            sb = new StringBuffer(originalText.length());
            if (originalText.indexOf(beginDelim) < 0 || originalText.indexOf(endDelim) < 0) {
                return "";
            }
            begidx = originalText.indexOf(beginDelim) + beginDelim.length();
            endidx = originalText.indexOf(endDelim);
            holder = 0;
            if (begidx >= endidx) ** GOTO lbl13
            sb.append(originalText.substring(begidx, endidx));
            break block3;
lbl-1000:
            // 1 sources

            {
                holder = endidx;
                endidx = originalText.indexOf(endDelim, holder + 1);
lbl13:
                // 2 sources

                ** while (begidx > endidx && endidx > -1)
            }
lbl14:
            // 1 sources

            if (begidx < endidx && endidx > -1) {
                sb.append(originalText.substring(begidx, endidx));
            }
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceSection(String originalText, String replaceBegin, String replacementText, String replaceEnd) {
        block3: {
            sb = new StringBuffer(originalText.length());
            if (originalText.indexOf(replaceBegin) < 0 || originalText.indexOf(replaceEnd) < 0) {
                return originalText;
            }
            begidx = originalText.indexOf(replaceBegin);
            endlen = replaceEnd.length();
            endidx = originalText.indexOf(replaceEnd) + endlen;
            holder = 0;
            if (begidx >= endidx) ** GOTO lbl18
            sb.append(originalText.substring(0, begidx));
            sb.append(replacementText);
            sb.append(originalText.substring(endidx));
            break block3;
lbl-1000:
            // 1 sources

            {
                holder = endidx;
                endidx = originalText.indexOf(replaceEnd, holder + 1);
lbl18:
                // 2 sources

                ** while (begidx > endidx && endidx > -1)
            }
lbl19:
            // 1 sources

            if (begidx < endidx && endidx > -1) {
                sb.append(originalText.substring(0, begidx));
                sb.append(replacementText);
                sb.append(originalText.substring(endidx + endlen));
            }
        }
        return sb.toString();
    }

    public static String StripChars(String theFilter, String theString) {
        StringBuffer strOut = new StringBuffer(theString.length());
        int i = 0;
        while (i < theString.length()) {
            char curChar = theString.charAt(i);
            if (theFilter.indexOf(curChar) < 0) {
                strOut.append(curChar);
            }
            ++i;
        }
        return strOut.toString();
    }

    public static String UseOnlyChars(String theFilter, String theString) {
        StringBuffer strOut = new StringBuffer(theString.length());
        int i = 0;
        while (i < theString.length()) {
            char curChar = theString.charAt(i);
            if (theFilter.indexOf(curChar) > -1) {
                strOut.append(curChar);
            }
            ++i;
        }
        return strOut.toString();
    }

    public static String replaceChars(String theFilter, String theString, String replacement) {
        StringBuffer strOut = new StringBuffer(theString.length());
        int i = 0;
        while (i < theString.length()) {
            char curChar = theString.charAt(i);
            if (theFilter.indexOf(curChar) < 0) {
                strOut.append(curChar);
            } else {
                strOut.append(replacement);
            }
            ++i;
        }
        return strOut.toString();
    }

    public static String replaceText(String theString, String theFilter, String replacement) {
        return StringTool.replaceText(theString, theFilter, replacement, 0);
    }

    public static boolean AllInRange(int x, int y, String theString) {
        int i = 0;
        while (i < theString.length()) {
            char curChar = theString.charAt(i);
            if (curChar < x || curChar > y) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String replaceTokenFromArray(String replace, String token, String[] vals) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer toke = new StringTokenizer(replace, token, false);
        int i = 0;
        while (toke.hasMoreTokens()) {
            sb.append(toke.nextToken());
            if (i > vals.length - 1) continue;
            sb.append(vals[i]);
            ++i;
        }
        return String.valueOf(sb);
    }

    public static String qualifyFilePath(String fPath) {
        StringTool.replaceChars("\\", fPath, "/");
        fPath = fPath.trim();
        if (!fPath.endsWith("/")) {
            fPath = String.valueOf(fPath) + "/";
        }
        return fPath;
    }

    public static String[] splitFilepath(String filePath) {
        String[] path = new String[2];
        int lastpath = (filePath = StringTool.replaceText(filePath, "\\", "/")).lastIndexOf("/");
        if (lastpath > -1) {
            path[0] = filePath.substring(0, lastpath + 1);
            path[1] = filePath.substring(lastpath + 1);
        } else {
            path[1] = filePath;
        }
        return path;
    }

    public static String stripPath(String filePath) {
        int lastpath = (filePath = StringTool.replaceText(filePath, "\\", "/")).lastIndexOf("/");
        if (lastpath > -1) {
            return filePath.substring(lastpath + 1);
        }
        return filePath;
    }

    public static String getPath(String filePath) {
        filePath = StringTool.replaceText(filePath, "\\", "/");
        int lastpath = filePath.lastIndexOf("/");
        return filePath.substring(0, lastpath + 1);
    }

    public static String replaceExtension(String filepath, String ext) {
        int i = filepath.lastIndexOf(".");
        String f = filepath;
        f = i > 0 ? String.valueOf(filepath.substring(0, i)) + ext : String.valueOf(filepath) + ext;
        return f;
    }

    public static double getApproximateStringWidth(Font f, String s) {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        double conversion = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
        return (double)fm.stringWidth(s) * conversion;
    }

    public static double getApproximateStringWidthLB(Font f, String s) {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        double conversion = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
        String[] ss = s.split("\n");
        double len = 0.0;
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            len = Math.max(len, (double)fm.stringWidth(st) * conversion);
            ++n2;
        }
        return len;
    }

    public static double getApproximateCharWidth(Font f, Character c) {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        double conversion = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0;
        return (double)fm.charWidth(c.charValue()) * conversion;
    }

    public static double getApproximateHeight(Font f, String s, double w) {
        double len = StringTool.getApproximateStringWidth(f, s);
        while (len > w) {
            int lastSpace = -1;
            int j = s.lastIndexOf("\n") + 1;
            len = 0.0;
            while (len < w && j < s.length()) {
                len += StringTool.getApproximateCharWidth(f, Character.valueOf(s.charAt(j)));
                if (s.charAt(j) == ' ') {
                    lastSpace = j;
                }
                ++j;
            }
            if (len < w) break;
            if (lastSpace == -1) {
                if (s.indexOf(32) == -1) break;
                lastSpace = s.lastIndexOf(32);
            }
            s = String.valueOf(s.substring(0, lastSpace)) + "\n" + s.substring(lastSpace + 1);
        }
        int nl = s.split("\n").length;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        LineMetrics lm = f.getLineMetrics(s, fm.getFontRenderContext());
        float l = lm.getLeading();
        float h = fm.getHeight();
        return Math.ceil(h * (float)nl);
    }

    public static String convertPatternFromExcelToStringFormatter(String pattern, boolean isNegative) {
        String curPattern = pattern;
        String jpattern = "";
        int w = 0;
        int precision = 0;
        String flags = "";
        char conversion = 'f';
        boolean inConversion = false;
        boolean inPrecision = false;
        boolean removeSign = false;
        int i = 0;
        while (i < curPattern.length()) {
            char c = curPattern.charAt(i);
            block0 : switch (c) {
                case '0': {
                    ++w;
                    if (!inConversion) {
                        jpattern = String.valueOf(jpattern) + "%";
                        inConversion = true;
                    }
                    if (!inPrecision || conversion == 69) break;
                    ++precision;
                    break;
                }
                case '?': {
                    break;
                }
                case '#': {
                    if (inConversion) break;
                    jpattern = String.valueOf(jpattern) + "%";
                    inConversion = true;
                    break;
                }
                case ',': {
                    flags = String.valueOf(flags) + ",";
                    break;
                }
                case '.': {
                    inPrecision = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (!inConversion) {
                        jpattern = String.valueOf(jpattern) + "%";
                        inConversion = true;
                    }
                    conversion = 'E';
                    ++i;
                    break;
                }
                case '[': {
                    int j;
                    int k = j = ++i;
                    while (i < curPattern.length()) {
                        c = curPattern.charAt(i);
                        if (c == '-') {
                            k = i;
                        }
                        if (c == ']') break;
                        ++i;
                    }
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    if (k == j) {
                        removeSign = true;
                        break;
                    }
                    jpattern = String.valueOf(jpattern) + curPattern.substring(++j, k);
                    break;
                }
                case '\"': {
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    ++i;
                    while (i < curPattern.length()) {
                        c = curPattern.charAt(i);
                        if (c == '\"') break block0;
                        jpattern = String.valueOf(jpattern) + (char)c;
                        ++i;
                    }
                    break;
                }
                case '@': {
                    jpattern = String.valueOf(jpattern) + "%s";
                    break;
                }
                case '*': {
                    break;
                }
                case '(': 
                case ')': {
                    if (!isNegative) break;
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    jpattern = String.valueOf(jpattern) + (char)c;
                    removeSign = true;
                    break;
                }
                case '_': {
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    ++i;
                    break;
                }
                case '%': {
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    jpattern = String.valueOf(jpattern) + "%%";
                    break;
                }
                case '\\': {
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    int z = i + 1 < curPattern.length() && curPattern.charAt(i + 1) == 'u' ? i + 6 : i + 1;
                    while (i < z && i < curPattern.length()) {
                        jpattern = String.valueOf(jpattern) + curPattern.charAt(i);
                        ++i;
                    }
                    break;
                }
                default: {
                    if (inConversion) {
                        inConversion = false;
                        inPrecision = false;
                        jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
                    }
                    jpattern = String.valueOf(jpattern) + (char)c;
                }
            }
            ++i;
        }
        if (inConversion) {
            jpattern = String.valueOf(jpattern) + flags + (w > 0 ? Integer.valueOf(w) : "") + "." + precision + conversion;
        }
        if (isNegative && !removeSign) {
            jpattern = "-" + jpattern;
        }
        pattern = jpattern;
        return pattern;
    }

    public static String convertDatePatternFromExcelToStringFormatter(String pattern) {
        String jpattern = "";
        String dString = "";
        String mString = "";
        int prev = 0;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c != 'd' && !dString.equals("")) {
                if (dString.length() <= 2) {
                    jpattern = String.valueOf(jpattern) + dString;
                } else if (dString.length() == 3) {
                    jpattern = String.valueOf(jpattern) + "EEE";
                } else if (dString.length() == 4) {
                    jpattern = String.valueOf(jpattern) + "EEEE";
                }
                dString = "";
            } else if (c != 'm' && !mString.equals("")) {
                if (c == ':' || prev == 104) {
                    jpattern = String.valueOf(jpattern) + mString;
                    prev = c;
                } else {
                    jpattern = String.valueOf(jpattern) + mString.toUpperCase();
                }
                mString = "";
            }
            switch (c) {
                case 'y': {
                    jpattern = String.valueOf(jpattern) + (char)c;
                    break;
                }
                case 'h': {
                    jpattern = String.valueOf(jpattern) + 'H';
                    prev = 104;
                    break;
                }
                case '[': 
                case '\\': 
                case ']': {
                    break;
                }
                case 's': {
                    jpattern = String.valueOf(jpattern) + (char)c;
                    break;
                }
                case 'A': {
                    if (!pattern.substring(i, i + 5).equals("AM/PM")) break;
                    jpattern = String.valueOf(jpattern) + "a";
                    i += 5;
                    int z = jpattern.length() - 2;
                    while (z >= 0) {
                        if (jpattern.charAt(z) == 'H') {
                            jpattern = String.valueOf(jpattern.substring(0, z)) + 'h' + jpattern.substring(z + 1);
                        }
                        --z;
                    }
                    break;
                }
                case 'd': {
                    dString = String.valueOf(dString) + (char)c;
                    break;
                }
                case 'm': {
                    mString = String.valueOf(mString) + (char)c;
                    break;
                }
                default: {
                    if (c != ':' && c != 'm') {
                        prev = c;
                    }
                    jpattern = String.valueOf(jpattern) + (char)c;
                }
            }
            ++i;
        }
        if (!mString.equals("")) {
            jpattern = prev == 104 ? String.valueOf(jpattern) + mString : String.valueOf(jpattern) + mString.toUpperCase();
        } else if (!dString.equals("")) {
            if (dString.length() <= 2) {
                jpattern = String.valueOf(jpattern) + dString;
            } else if (dString.length() == 3) {
                jpattern = String.valueOf(jpattern) + "EEE";
            } else if (dString.length() == 4) {
                jpattern = String.valueOf(jpattern) + "EEEE";
            }
            dString = "";
        }
        return jpattern;
    }

    public static String convertPatternExtractBracketedExpression(String pattern) {
        String[] s = pattern.split("\\[");
        if (s.length > 1) {
            pattern = "";
            int i = 0;
            while (i < s.length) {
                int zz = s[i].indexOf("]");
                if (zz != -1) {
                    String term = "";
                    term = s[i].charAt(0) == '$' ? s[i].substring(1, zz) : s[i].substring(0, zz);
                    pattern = term.indexOf("-") != -1 ? String.valueOf(pattern) + term.substring(0, term.indexOf("-")) : String.valueOf(pattern) + term;
                }
                pattern = String.valueOf(pattern) + s[i].substring(zz + 1);
                ++i;
            }
        }
        return pattern;
    }

    public static String qualifyPatternString(String pattern) {
        pattern = StringTool.strip(pattern, "*");
        pattern = StringTool.strip(pattern, "_(");
        pattern = StringTool.strip(pattern, "_)");
        pattern = StringTool.strip(pattern, "_");
        pattern = pattern.replaceAll("\"", "");
        String[] s = (pattern = StringTool.strip(pattern, "?")).split("\\[");
        if (s.length > 1) {
            pattern = "";
            int i = 0;
            while (i < s.length) {
                String term;
                int zz = s[i].indexOf("]");
                if (zz != -1 && (term = s[i].substring(1, zz)).indexOf("-") != -1) {
                    pattern = String.valueOf(pattern) + term.substring(0, term.indexOf("-"));
                }
                pattern = String.valueOf(pattern) + s[i].substring(zz + 1);
                ++i;
            }
        }
        return pattern;
    }

    public static String readString(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(512);
        while (-1 != reader.read(buffer)) {
            buffer.flip();
            builder.append(buffer);
            buffer.clear();
        }
        return builder.toString();
    }
}

