/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

class SpecialArrayList
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    Object[] elementData;
    private int size;

    @Override
    public Iterator iterator() {
        return new Itr();
    }

    public SpecialArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public SpecialArrayList() {
        this(10);
    }

    public SpecialArrayList(Collection c) {
        this.size = c.size();
        this.elementData = new Object[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        c.toArray(this.elementData);
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            int i = 0;
            while (i < this.size) {
                if (this.elementData[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (elem.equals(this.elementData[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.elementData[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = this.size - 1;
            while (i >= 0) {
                if (elem.equals(this.elementData[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            SpecialArrayList v = (SpecialArrayList)super.clone();
            v.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public Object get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public Object set(int index, Object element) {
        this.RangeCheck(index);
        Object oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    public void add(int index, Object element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public Object remove(int index) {
        this.RangeCheck(index);
        ++this.modCount;
        Object oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        int i = 0;
        while (i < this.size) {
            this.elementData[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.elementData = new Object[numNew];
        System.arraycopy(a, 0, this.elementData, 0, numNew);
        this.size += c.size();
        this.modCount += this.size;
        ++this.modCount;
        return numNew != 0;
    }

    public boolean addAll(int index, Collection c) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Object[] a = c.toArray();
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = null;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = SpecialArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != SpecialArrayList.this.size;
        }

        public Object next() {
            try {
                Object next = SpecialArrayList.this.elementData[this.cursor];
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            try {
                SpecialArrayList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = SpecialArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
        }
    }
}

