/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ExtenClassLoader
extends ClassLoader {
    private String targetClassName;
    private String wd = "";

    public ExtenClassLoader(String target) {
        this.targetClassName = target;
    }

    public ExtenClassLoader() {
    }

    public void setDirectory(String _wd) {
        this.wd = _wd;
    }

    protected byte[] loadClassFromFile(String name) {
        byte[] classBytes = null;
        try {
            File file = null;
            FileInputStream stream = null;
            name = String.valueOf(this.wd) + "/" + name;
            name = StringTool.replaceChars(".", name, "/");
            file = new File(String.valueOf(name) + ".class");
            classBytes = new byte[(int)file.length()];
            stream = new FileInputStream(file);
            stream.read(classBytes);
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classBytes;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] bytes;
        if (!name.equals(this.targetClassName)) {
            try {
                Class<?> loadedClass = super.findSystemClass(name);
                return loadedClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((bytes = this.loadClassFromFile(name)) == null) {
            throw new ClassNotFoundException();
        }
        Class<?> loadedClass = this.defineClass(name, bytes, 0, bytes.length);
        if (loadedClass == null) {
            Logger.logInfo("Class cannot be loaded: " + name);
            throw new ClassFormatError();
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }
}

