/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.escher;

import com.extentech.formats.escher.EscherRecord;
import com.extentech.toolkit.ByteTools;

public class MsofbtDgg
extends EscherRecord {
    private static final long serialVersionUID = -7933328640935994167L;
    int spidMax = 1024;
    int numIdClusters;
    int numShapes;
    int numDrawings;

    public MsofbtDgg(int fbt, int inst, int version) {
        super(fbt, inst, version);
    }

    @Override
    protected byte[] getData() {
        byte[] spidMaxBytes = ByteTools.cLongToLEBytes(this.spidMax);
        this.numIdClusters = this.spidMax / 1024 + (this.spidMax % 1024 != 0 ? 1 : 0);
        byte[] cidclBytes = ByteTools.cLongToLEBytes(this.numIdClusters);
        byte[] cspSavedBytes = ByteTools.cLongToLEBytes(this.numShapes);
        byte[] cdgSavedBytes = ByteTools.cLongToLEBytes(this.numDrawings);
        int lenOfFIDCL = this.numIdClusters - 1;
        byte[] retBytes = new byte[16 + lenOfFIDCL * 8];
        System.arraycopy(spidMaxBytes, 0, retBytes, 0, 4);
        System.arraycopy(cidclBytes, 0, retBytes, 4, 4);
        System.arraycopy(cspSavedBytes, 0, retBytes, 8, 4);
        System.arraycopy(cdgSavedBytes, 0, retBytes, 12, 4);
        int pos = 16;
        int i = 0;
        while (i < lenOfFIDCL) {
            System.arraycopy(ByteTools.cLongToLEBytes(1), 0, retBytes, pos, 4);
            System.arraycopy(ByteTools.cLongToLEBytes(i == 0 ? this.numShapes : 1), 0, retBytes, pos + 4, 4);
            pos += 8;
            ++i;
        }
        this.setLength(retBytes.length);
        return retBytes;
    }

    public int getNumDrawings() {
        return this.numDrawings;
    }

    public void setNumDrawings(int numDrawings) {
        this.numDrawings = numDrawings;
    }

    public int getNumIdClusters() {
        return this.numIdClusters;
    }

    public int getNumShapes() {
        return this.numShapes;
    }

    public void setNumShapes(int numShapes) {
        this.numShapes = numShapes;
    }

    public void setSpidMax(int spid) {
        this.spidMax = spid;
    }
}

