/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.escher;

import com.extentech.formats.escher.EscherRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.MD4Digest;

public class MsofbtBSE
extends EscherRecord {
    private static final long serialVersionUID = -9072016434347371029L;
    private byte[] imageData;
    private int imageType;
    private int numShapes;
    private int cRef = 1;

    public MsofbtBSE(int fbt, int inst, int version) {
        super(fbt, inst, version);
    }

    @Override
    protected byte[] getData() {
        byte[] imgHeader = new byte[61];
        imgHeader[0] = (byte)this.imageType;
        imgHeader[1] = (byte)this.imageType;
        if (this.imageType == 0) {
            byte[] retData = new byte[36];
            retData[18] = -1;
            this.setLength(retData.length);
            return retData;
        }
        MD4Digest md4Digest = new MD4Digest();
        byte[] digest = md4Digest.getDigest(this.imageData);
        System.arraycopy(digest, 0, imgHeader, 2, 16);
        imgHeader[18] = -1;
        imgHeader[19] = 0;
        int sz = this.imageData.length + 25;
        byte[] tempBytes = ByteTools.cLongToLEBytes(sz);
        imgHeader[20] = tempBytes[0];
        imgHeader[21] = tempBytes[1];
        imgHeader[22] = tempBytes[2];
        imgHeader[23] = tempBytes[3];
        tempBytes = ByteTools.cLongToLEBytes(this.cRef);
        imgHeader[24] = tempBytes[0];
        imgHeader[25] = tempBytes[1];
        imgHeader[26] = tempBytes[2];
        imgHeader[27] = tempBytes[3];
        tempBytes = ByteTools.cLongToLEBytes(0);
        imgHeader[28] = tempBytes[0];
        imgHeader[29] = tempBytes[1];
        imgHeader[30] = tempBytes[2];
        imgHeader[31] = tempBytes[3];
        imgHeader[32] = 0;
        imgHeader[33] = 0;
        int inst1 = 1130;
        switch (this.imageType) {
            case 0: {
                break;
            }
            case 2: {
                inst1 = 980;
                break;
            }
            case 3: {
                inst1 = 534;
                break;
            }
            case 4: {
                inst1 = 1346;
                break;
            }
            case 5: {
                inst1 = 1130;
                break;
            }
            case 6: {
                inst1 = 1760;
                break;
            }
            case 7: {
                inst1 = 1960;
            }
        }
        int version1 = 0;
        int fbt1 = 61464 + this.imageType;
        int len1 = this.imageData.length + 17;
        imgHeader[36] = (byte)((0xF & inst1) << 4 | 0xF & version1);
        imgHeader[37] = (byte)((0xFF0 & inst1) >> 4);
        imgHeader[38] = (byte)(0xFF & fbt1);
        imgHeader[39] = (byte)((0xFF00 & fbt1) >> 8);
        tempBytes = ByteTools.cLongToLEBytes(len1);
        imgHeader[40] = tempBytes[0];
        imgHeader[41] = tempBytes[1];
        imgHeader[42] = tempBytes[2];
        imgHeader[43] = tempBytes[3];
        System.arraycopy(digest, 0, imgHeader, 44, 16);
        imgHeader[60] = -1;
        int len = 61;
        byte[] retData = new byte[len + this.imageData.length];
        System.arraycopy(imgHeader, 0, retData, 0, len);
        System.arraycopy(this.imageData, 0, retData, len, this.imageData.length);
        this.setLength(retData.length);
        return retData;
    }

    public void setImageData(byte[] d) {
        this.imageData = d;
    }

    public void setRefCount(int cRef) {
        this.cRef = cRef;
    }

    public int getRefCount() {
        return this.cRef;
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int imageType) {
        this.imageType = imageType;
    }

    public int getNumShapes() {
        return this.numShapes;
    }

    public void setNumShapes(int numShapes) {
        this.numShapes = numShapes;
    }
}

