/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.escher;

import com.extentech.toolkit.ByteTools;
import java.io.Serializable;

abstract class EscherRecord
implements Serializable {
    private static final long serialVersionUID = -7987132917889379656L;
    byte[] header;
    byte[] data;
    int length;
    int inst;
    int fbt;
    int version;
    boolean isDirty = false;

    public void EscherRecord() {
    }

    EscherRecord(int fbt, int inst, int version) {
        this.fbt = fbt;
        this.inst = inst;
        this.version = version;
    }

    public int getFbt() {
        return this.fbt;
    }

    public int getInst() {
        return this.inst;
    }

    public int getLength() {
        return this.length;
    }

    public void setFbt(int value) {
        this.fbt = value;
    }

    public void setInst(int value) {
        this.inst = value;
    }

    public void setLength(int value) {
        this.length = value;
    }

    protected abstract byte[] getData();

    private byte[] getHeaderBytes() {
        byte[] headerBytes = new byte[]{(byte)(0xF & this.version | 0xF0 & this.inst << 4), (byte)((0xFF0 & this.inst) >> 4), (byte)(0xFF & this.fbt), (byte)((0xFF00 & this.fbt) >> 8)};
        int version2 = 0xF & headerBytes[0];
        int inst2 = (0xFF & headerBytes[1]) >> 4 | (0xF0 & headerBytes[0]) >> 4;
        byte[] lenBytes = ByteTools.cLongToLEBytes(this.length);
        byte[] retData = new byte[8];
        System.arraycopy(headerBytes, 0, retData, 0, 4);
        System.arraycopy(lenBytes, 0, retData, headerBytes.length, 4);
        return retData;
    }

    public byte[] toByteArray() {
        byte[] dataBytes = this.getData();
        byte[] headerBytes = this.getHeaderBytes();
        byte[] retData = new byte[headerBytes.length + dataBytes.length];
        System.arraycopy(headerBytes, 0, retData, 0, headerBytes.length);
        if (dataBytes.length > 0) {
            System.arraycopy(dataBytes, 0, retData, headerBytes.length, dataBytes.length);
        }
        return retData;
    }
}

