/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.Calculator;
import com.extentech.formats.XLS.formulas.EngineeringCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgMissArg;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Vector;

public class StatisticalCalculator {
    protected static Ptg calcAverage(Ptg[] operands) {
        Vector<Ptg> vect = new Vector<Ptg>();
        int i = 0;
        while (i < operands.length) {
            Ptg[] pthings = operands[i].getComponents();
            if (pthings != null) {
                int z = 0;
                while (z < pthings.length) {
                    vect.add(pthings[z]);
                    ++z;
                }
            } else {
                Ptg p = operands[i];
                vect.add(p);
            }
            ++i;
        }
        int count = 0;
        BigDecimal bd = new BigDecimal(0);
        int i2 = 0;
        while (i2 < vect.size()) {
            Ptg p = (Ptg)vect.elementAt(i2);
            try {
                Object ov;
                if (!p.isBlank() && (ov = p.getValue()) != null) {
                    bd = bd.add(new BigDecimal(Double.parseDouble(String.valueOf(ov))));
                    ++count;
                }
            }
            catch (NumberFormatException ov) {
                // empty catch block
            }
            ++i2;
        }
        bd = bd.setScale(15, RoundingMode.HALF_UP);
        double total = bd.doubleValue();
        if (count == 0) {
            return new PtgErr(PtgErr.ERROR_DIV_ZERO);
        }
        double result = total / (double)count;
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcAverageIf(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_DIV_ZERO);
        }
        Ptg[] range = operands[0].getComponents();
        String criteria = operands[1].getString().trim();
        int i = Calculator.splitOperator(criteria);
        String op = criteria.substring(0, i);
        criteria = criteria.substring(i);
        criteria = Calculator.translateWildcardsInCriteria(criteria);
        Ptg[] average_range = null;
        boolean varyRow = false;
        if (operands.length > 2) {
            int[] rc = null;
            average_range = new Ptg[range.length];
            average_range[0] = operands[2].getComponents()[0];
            String sheet = "";
            try {
                rc = average_range[0].getIntLocation();
                if (range[0].getIntLocation()[0] != range[range.length - 1].getIntLocation()[0]) {
                    varyRow = true;
                }
                sheet = String.valueOf(((PtgRef)average_range[0]).getSheetName()) + "!";
            }
            catch (Exception exception) {
                // empty catch block
            }
            int j = 1;
            while (j < average_range.length) {
                if (varyRow) {
                    rc[0] = rc[0] + 1;
                } else {
                    rc[1] = rc[1] + 1;
                }
                average_range[j] = new PtgRef3d();
                average_range[j].setParentRec(range[0].getParentRec());
                average_range[j].setLocation(String.valueOf(sheet) + ExcelTools.formatLocation(rc));
                ++j;
            }
        }
        int nresults = 0;
        double result = 0.0;
        int j = 0;
        while (j < range.length) {
            block13: {
                Object val = range[j].getValue();
                if (Calculator.compareCellValue(val, criteria, op)) {
                    try {
                        if (average_range != null && (val = average_range[j].getValue()) == null) break block13;
                        result += ((Number)val).doubleValue();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    ++nresults;
                }
            }
            ++j;
        }
        if (nresults == 0) {
            return new PtgErr(PtgErr.ERROR_DIV_ZERO);
        }
        return new PtgNumber(result / (double)nresults);
    }

    protected static Ptg calcAverageIfS(Ptg[] operands) {
        try {
            PtgArea average_range = Calculator.getRange(operands[0]);
            Ptg[] averagerangecells = average_range.getComponents();
            if (averagerangecells.length == 0) {
                return new PtgErr(PtgErr.ERROR_DIV_ZERO);
            }
            String[] ops = new String[(operands.length - 1) / 2];
            String[] criteria = new String[(operands.length - 1) / 2];
            Ptg[][] criteria_cells = new Ptg[(operands.length - 1) / 2][];
            int j = 0;
            int i = 1;
            while (i + 1 < operands.length) {
                PtgArea cr = Calculator.getRange(operands[i]);
                criteria_cells[j] = cr.getComponents();
                if (criteria_cells[j].length != averagerangecells.length) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                criteria[j] = operands[i + 1].toString();
                ops[j] = "=";
                int k = Calculator.splitOperator(criteria[j]);
                if (k > 0) {
                    ops[j] = criteria[j].substring(0, k);
                }
                criteria[j] = criteria[j].substring(k);
                criteria[j] = Calculator.translateWildcardsInCriteria(criteria[j]);
                ++j;
                i += 2;
            }
            ArrayList<Ptg> passesList = new ArrayList<Ptg>();
            int i2 = 0;
            while (i2 < averagerangecells.length) {
                boolean passes = true;
                int k = 0;
                while (k < criteria.length) {
                    try {
                        Object v = criteria_cells[k][i2].getValue();
                        boolean bl = passes = Calculator.compareCellValue(v, criteria[k], ops[k]) && passes;
                        if (!passes) {
                            break;
                        }
                    }
                    catch (Exception v) {
                        // empty catch block
                    }
                    ++k;
                }
                if (passes) {
                    passesList.add(averagerangecells[i2]);
                }
                ++i2;
            }
            if (passesList.size() == 0) {
                return new PtgErr(PtgErr.ERROR_DIV_ZERO);
            }
            double result = 0.0;
            int i3 = 0;
            while (i3 < passesList.size()) {
                Ptg cell = (Ptg)passesList.get(i3);
                try {
                    result += cell.getDoubleVal();
                }
                catch (Exception e) {
                    Logger.logErr("MathFunctionCalculator.calcAverageIfS:  error obtaining cell value: " + e.toString());
                }
                ++i3;
            }
            return new PtgNumber(result / (double)passesList.size());
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
    }

    protected static Ptg calcAveDev(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        PtgNumber av = (PtgNumber)StatisticalCalculator.calcAverage(operands);
        double average = -0.001;
        try {
            Double dd = new Double(String.valueOf(av.getValue()));
            average = dd;
        }
        catch (NumberFormatException dd) {
            // empty catch block
        }
        if (average == -0.001) {
            return PtgCalculator.getError();
        }
        double total = 0.0;
        int count = 0;
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        int i = 0;
        while (i < alloperands.length) {
            Ptg resPtg = alloperands[i];
            try {
                if (resPtg.getValue() != null) {
                    Double d = new Double(String.valueOf(resPtg.getValue()));
                    double dub = d;
                    dub = average - dub;
                    dub = Math.abs(dub);
                    total += dub;
                    ++count;
                }
            }
            catch (NumberFormatException dub) {
                // empty catch block
            }
            ++i;
        }
        double mean = total / (double)count;
        PtgNumber pnum = new PtgNumber(mean);
        return pnum;
    }

    protected static Ptg calcAverageA(Ptg[] operands) {
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        double total = 0.0;
        int i = 0;
        while (i < alloperands.length) {
            Ptg p = alloperands[i];
            try {
                Object ov = p.getValue();
                if (ov != null) {
                    total = String.valueOf(ov) == "true" ? (total += 1.0) : (total += Double.parseDouble(String.valueOf(ov)));
                }
            }
            catch (NumberFormatException ov) {
                // empty catch block
            }
            ++i;
        }
        double result = total / (double)alloperands.length;
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcCorrel(Ptg[] operands) throws CalculationException {
        PtgNumber pnum = (PtgNumber)StatisticalCalculator.calcCovar(operands);
        double covar = pnum.getVal();
        Ptg[] xPtg = new Ptg[]{operands[0]};
        Ptg[] yPtg = new Ptg[]{operands[1]};
        pnum = (PtgNumber)StatisticalCalculator.calcAverage(xPtg);
        double xMean = pnum.getVal();
        pnum = (PtgNumber)StatisticalCalculator.calcAverage(yPtg);
        double yMean = pnum.getVal();
        double[] xVals = PtgCalculator.getDoubleValueArray(xPtg);
        double[] yVals = PtgCalculator.getDoubleValueArray(yPtg);
        if (xVals == null || yVals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double xstat = 0.0;
        int i = 0;
        while (i < xVals.length) {
            xstat += Math.pow(xVals[i] - xMean, 2.0);
            ++i;
        }
        xstat /= (double)xVals.length;
        xstat = Math.sqrt(xstat);
        double ystat = 0.0;
        int i2 = 0;
        while (i2 < yVals.length) {
            ystat += Math.pow(yVals[i2] - yMean, 2.0);
            ++i2;
        }
        ystat /= (double)yVals.length;
        ystat = Math.sqrt(ystat);
        double retval = covar / (ystat * xstat);
        return new PtgNumber(retval);
    }

    protected static Ptg calcCount(Ptg[] operands) {
        int count = 0;
        int i = 0;
        while (i < operands.length) {
            Ptg[] pref = operands[i].getComponents();
            if (pref != null) {
                int z = 0;
                while (z < pref.length) {
                    Object o = pref[z].getValue();
                    if (o != null) {
                        try {
                            Double n = new Double(String.valueOf(o));
                            ++count;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    ++z;
                }
            } else {
                Object o = operands[i].getValue();
                if (o != null) {
                    try {
                        Double n = new Double(String.valueOf(o));
                        ++count;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        PtgInt pint = new PtgInt(count);
        return pint;
    }

    protected static Ptg calcCountA(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        int count = 0;
        int i = 0;
        while (i < allops.length) {
            if (!allops[i].isBlank()) {
                ++count;
            }
            ++i;
        }
        return new PtgInt(count);
    }

    protected static Ptg calcCountBlank(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        int count = 0;
        int i = 0;
        while (i < allops.length) {
            if (allops[i].isBlank()) {
                ++count;
            }
            ++i;
        }
        return new PtgInt(count);
    }

    protected static Ptg calcCountif(Ptg[] operands) throws FunctionNotSupportedException {
        if (operands.length != 2) {
            return PtgCalculator.getError();
        }
        String matchStr = String.valueOf(operands[1].getValue());
        boolean donumber = true;
        double matchDub = 0.0;
        try {
            Double d = new Double(matchStr);
            matchDub = d;
        }
        catch (Exception e) {
            donumber = false;
        }
        double count = 0.0;
        Ptg[] pref = operands[0].getComponents();
        if (pref != null) {
            int z = 0;
            while (z < pref.length) {
                Object o = pref[z].getValue();
                if (o != null) {
                    String match2 = o.toString();
                    if (donumber) {
                        try {
                            Double d = new Double(match2);
                            double matchDub2 = d;
                            if (matchDub == matchDub2) {
                                count += 1.0;
                            }
                        }
                        catch (NumberFormatException d) {}
                    } else if (matchStr.equalsIgnoreCase(match2)) {
                        count += 1.0;
                    }
                }
                ++z;
            }
        } else {
            Object o = operands[0].getValue();
            if (o != null && o != null) {
                String match2 = o.toString();
                if (donumber) {
                    try {
                        Double d = new Double(match2);
                        double matchDub2 = d;
                        if (matchDub == matchDub2) {
                            count += 1.0;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (matchStr.equalsIgnoreCase(match2)) {
                    count += 1.0;
                }
            }
        }
        PtgNumber pnum = new PtgNumber(count);
        return pnum;
    }

    protected static Ptg calcCountIfS(Ptg[] operands) {
        try {
            String[] ops = new String[operands.length / 2];
            String[] criteria = new String[operands.length / 2];
            Ptg[][] criteria_cells = new Ptg[operands.length / 2][];
            int i = 0;
            while (i + 1 < operands.length) {
                PtgArea cr = Calculator.getRange(operands[i]);
                criteria_cells[i / 2] = cr.getComponents();
                if (i > 0 && criteria_cells[i / 2].length != criteria_cells[0].length) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                criteria[i / 2] = operands[i + 1].toString();
                ops[i / 2] = "=";
                int k = Calculator.splitOperator(criteria[i / 2]);
                if (k > 0) {
                    ops[i / 2] = criteria[i / 2].substring(0, k);
                }
                criteria[i / 2] = criteria[i / 2].substring(k);
                criteria[i / 2] = Calculator.translateWildcardsInCriteria(criteria[i / 2]);
                i += 2;
            }
            int count = 0;
            int i2 = 0;
            while (i2 < criteria_cells[0].length) {
                boolean passes = true;
                int k = 0;
                while (k < criteria.length) {
                    try {
                        Object v = criteria_cells[k][i2].getValue();
                        boolean bl = passes = Calculator.compareCellValue(v, criteria[k], ops[k]) && passes;
                        if (!passes) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++k;
                }
                if (passes) {
                    ++count;
                }
                ++i2;
            }
            return new PtgNumber(count);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
    }

    protected static Ptg calcCovar(Ptg[] operands) throws CalculationException {
        int addvals;
        Ptg[] xMeanPtg = new Ptg[]{operands[0]};
        Ptg[] yMeanPtg = new Ptg[]{operands[1]};
        PtgNumber pnum = (PtgNumber)StatisticalCalculator.calcAverage(xMeanPtg);
        double xMean = pnum.getVal();
        pnum = (PtgNumber)StatisticalCalculator.calcAverage(yMeanPtg);
        double yMean = pnum.getVal();
        double[] xVals = PtgCalculator.getDoubleValueArray(xMeanPtg);
        double[] yVals = PtgCalculator.getDoubleValueArray(yMeanPtg);
        if (xVals == null || yVals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double xyMean = 0.0;
        if (xVals.length == yVals.length) {
            addvals = 0;
            int i = 0;
            while (i < xVals.length) {
                addvals = (int)((double)addvals + xVals[i] * yVals[i]);
                ++i;
            }
        } else {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        xyMean = addvals / xVals.length;
        double retval = xyMean - xMean * yMean;
        return new PtgNumber(retval);
    }

    protected static Ptg calcForecast(Ptg[] operands) throws CalculationException {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg[] p = new Ptg[]{operands[0], operands[1]};
        PtgNumber icept = (PtgNumber)StatisticalCalculator.calcIntercept(p);
        double intercept = icept.getVal();
        PtgNumber slp = (PtgNumber)StatisticalCalculator.calcSlope(p);
        double slope = slp.getVal();
        Ptg px = operands[0];
        double knownX = new Double(String.valueOf(px.getValue()));
        double retval = slope * knownX + intercept;
        return new PtgNumber(retval);
    }

    protected static Ptg calcFrequency(Ptg[] operands) throws CalculationException {
        Ptg[] firstArr = PtgCalculator.getAllComponents(operands[0]);
        Ptg[] secondArr = PtgCalculator.getAllComponents(operands[1]);
        CompatibleVector t = new CompatibleVector();
        int i = 0;
        while (i < secondArr.length) {
            Ptg p = secondArr[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                t.addOrderedDouble(d);
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
            ++i;
        }
        Object[] binsArr = new Double[t.size()];
        double[] dataArr = PtgCalculator.getDoubleValueArray(firstArr);
        if (dataArr == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        t.toArray(binsArr);
        int[] retvals = new int[secondArr.length + 1];
        int i2 = 0;
        while (i2 < dataArr.length) {
            int x = 0;
            while (x < binsArr.length) {
                if (dataArr[i2] <= (Double)binsArr[x]) {
                    int n = x;
                    retvals[n] = retvals[n] + 1;
                    x = binsArr.length;
                } else if (dataArr[i2] > (Double)binsArr[binsArr.length - 1]) {
                    int n = binsArr.length;
                    retvals[n] = retvals[n] + 1;
                    x = binsArr.length;
                }
                ++x;
            }
            ++i2;
        }
        String ret = "{";
        int i3 = 0;
        while (i3 < retvals.length) {
            ret = String.valueOf(ret) + retvals[i3] + ",";
            ++i3;
        }
        ret = ret.substring(0, ret.length() - 1);
        ret = String.valueOf(ret) + "}";
        PtgArray returnArr = new PtgArray();
        returnArr.setVal(ret);
        return returnArr;
    }

    protected static Ptg calcIntercept(Ptg[] operands) throws CalculationException {
        double[] yvals = PtgCalculator.getDoubleValueArray(operands[0]);
        double[] xvals = PtgCalculator.getDoubleValueArray(operands[1]);
        if (xvals == null || yvals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double sumXVals = 0.0;
        int i = 0;
        while (i < xvals.length) {
            sumXVals += xvals[i];
            ++i;
        }
        double sumYVals = 0.0;
        int i2 = 0;
        while (i2 < yvals.length) {
            sumYVals += yvals[i2];
            ++i2;
        }
        double sumXYVals = 0.0;
        int i3 = 0;
        while (i3 < yvals.length) {
            sumXYVals += xvals[i3] * yvals[i3];
            ++i3;
        }
        double sqrXVals = 0.0;
        int i4 = 0;
        while (i4 < xvals.length) {
            sqrXVals += xvals[i4] * xvals[i4];
            ++i4;
        }
        double toparg = sumXVals * sumXYVals - sumYVals * sqrXVals;
        double bottomarg = sumXVals * sumXVals - sqrXVals * (double)xvals.length;
        double res = toparg / bottomarg;
        return new PtgNumber(res);
    }

    protected static Ptg calcLarge(Ptg[] operands) throws CalculationException {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg rng = operands[0];
        Ptg[] array = PtgCalculator.getAllComponents(rng);
        if (array.length == 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int k = new Double(PtgCalculator.getDoubleValueArray(operands[1])[0]).intValue();
        if (k <= 0 || k > array.length) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        CompatibleVector sortedValues = new CompatibleVector();
        int i = 0;
        while (i < array.length) {
            Ptg p = array[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                sortedValues.addOrderedDouble(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        Double[] dubRefs = new Double[sortedValues.size()];
        int i2 = 0;
        while (i2 < dubRefs.length) {
            dubRefs[i2] = (Double)sortedValues.last();
            sortedValues.remove(sortedValues.size() - 1);
            ++i2;
        }
        return new PtgNumber(dubRefs[k - 1]);
    }

    protected static Ptg calcLineSt(Ptg[] operands) throws CalculationException {
        boolean b;
        Ptg ps;
        double[] xs;
        double[] ys = PtgCalculator.getDoubleValueArray(operands[0]);
        if (ys == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (operands.length == 1 || operands[1] instanceof PtgMissArg) {
            xs = new double[ys.length];
            int i = 0;
            while (i < ys.length) {
                xs[i] = i;
                ++i;
            }
        } else {
            xs = PtgCalculator.getDoubleValueArray(operands[1]);
            if (xs == null) {
                return new PtgErr(PtgErr.ERROR_NA);
            }
        }
        boolean getIntercept = false;
        if (operands.length > 2 && !(operands[2] instanceof PtgMissArg)) {
            getIntercept = PtgCalculator.getBooleanValue(operands[2]);
        }
        boolean statistics = false;
        if (operands.length > 3 && !(operands[3] instanceof PtgMissArg)) {
            statistics = PtgCalculator.getBooleanValue(operands[3]);
        }
        if ((ps = StatisticalCalculator.calcSlope(operands)) instanceof PtgErr) {
            return ps;
        }
        PtgNumber Pslope = (PtgNumber)StatisticalCalculator.calcSlope(operands);
        double slope = Pslope.getVal();
        PtgNumber Pintercept = (PtgNumber)StatisticalCalculator.calcIntercept(operands);
        double intercept = Pintercept.getVal();
        if (operands.length > 3 && (operands[3] instanceof PtgBool || operands[3] instanceof PtgInt) && !(b = PtgCalculator.getBooleanValue(operands[3]))) {
            String retstr = "{" + slope + "," + intercept + "},";
            retstr = String.valueOf(retstr) + "{" + slope + "," + intercept + "},";
            retstr = String.valueOf(retstr) + "{" + slope + "," + intercept + "},";
            retstr = String.valueOf(retstr) + "{" + slope + "," + intercept + "},";
            retstr = String.valueOf(retstr) + "{" + slope + "," + intercept + "}";
            PtgArray para = new PtgArray();
            para.setVal(retstr);
            return para;
        }
        Ptg[] p = new Ptg[1];
        PtgNumber Psteyx = (PtgNumber)StatisticalCalculator.calcSteyx(operands);
        double steyx = Psteyx.getVal();
        double yError = steyx * steyx;
        p[0] = operands[1];
        PtgNumber vp = (PtgNumber)StatisticalCalculator.calcVarp(p);
        double Sxx = vp.getVal() * (double)ys.length;
        yError /= Sxx;
        yError = Math.sqrt(yError);
        int degFreedom = ys.length - 2;
        double sumXsquared = 0.0;
        double sumSquaredX = 0.0;
        double sumXYsquared = 0.0;
        int i = 0;
        while (i < xs.length) {
            sumSquaredX += xs[i] * xs[i];
            sumXsquared += xs[i];
            sumXYsquared += xs[i] * ys[i];
            ++i;
        }
        sumXsquared *= sumXsquared;
        sumXYsquared *= sumXYsquared;
        double interceptError = 1.0 / ((double)xs.length - sumXsquared / sumSquaredX);
        interceptError = Math.sqrt(interceptError);
        interceptError *= steyx;
        double[] predicted = new double[xs.length];
        double residualSS = 0.0;
        int i2 = 0;
        while (i2 < xs.length) {
            predicted[i2] = intercept + xs[i2] * slope;
            double d = predicted[i2] - ys[i2];
            residualSS += d * d;
            ++i2;
        }
        p[0] = operands[0];
        PtgNumber pnum = (PtgNumber)StatisticalCalculator.calcAverage(p);
        double average = pnum.getVal();
        double regressionSS = 0.0;
        int i3 = 0;
        while (i3 < xs.length) {
            double d = predicted[i3] - average;
            regressionSS += d * d;
            ++i3;
        }
        p = new Ptg[]{operands[0], operands[1]};
        pnum = (PtgNumber)StatisticalCalculator.calcRsq(p);
        double r2 = pnum.getVal();
        double F = regressionSS / 1.0 / (residualSS / (double)degFreedom);
        String retstr = "{" + slope + "," + intercept + "},";
        retstr = String.valueOf(retstr) + "{" + yError + "," + interceptError + "},";
        retstr = String.valueOf(retstr) + "{" + r2 + "," + steyx + "},";
        retstr = String.valueOf(retstr) + "{" + F + "," + degFreedom + "},";
        retstr = String.valueOf(retstr) + "{" + regressionSS + "," + residualSS + "}";
        PtgArray parr = new PtgArray();
        parr.setVal(retstr);
        return parr;
    }

    protected static Ptg calcMax(Ptg[] operands) {
        double result = Double.MIN_VALUE;
        Double d = null;
        int i = 0;
        while (i < operands.length) {
            Ptg[] pthings = operands[i].getComponents();
            if (pthings != null) {
                Ptg resPtg = StatisticalCalculator.calcMax(pthings);
                try {
                    if (resPtg.getValue() != null) {
                        d = new Double(String.valueOf(resPtg.getValue()));
                    }
                    if (d > result) {
                        result = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                Ptg p = operands[i];
                try {
                    Object ov = p.getValue();
                    if (ov != null) {
                        d = new Double(String.valueOf(ov));
                    }
                    if (d > result) {
                        result = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (result == Double.MIN_VALUE) {
            result = 0.0;
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcMaxA(Ptg[] operands) {
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        if (alloperands.length == 0) {
            return new PtgNumber(0.0);
        }
        double max = Double.MIN_VALUE;
        int i = 0;
        while (i < alloperands.length) {
            Object o = alloperands[i].getValue();
            try {
                double d = Double.MIN_VALUE;
                d = o instanceof Number ? ((Number)o).doubleValue() : (o instanceof Boolean ? (double)((Boolean)o != false ? 1 : 0) : new Double(o.toString()));
                max = Math.max(max, d);
            }
            catch (NumberFormatException e) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            ++i;
        }
        return new PtgNumber(max);
    }

    protected static Ptg calcMedian(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        CompatibleVector t = new CompatibleVector();
        double retval = 0.0;
        int i = 0;
        while (i < alloperands.length) {
            Ptg p = alloperands[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                t.addOrderedDouble(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        try {
            int firstValLoc;
            Object[] dub = new Double[t.size()];
            t.toArray(dub);
            double dd = (double)t.size() % 2.0;
            if ((double)t.size() % 2.0 == 0.0) {
                firstValLoc = t.size() / 2 - 1;
                int lastValLoc = firstValLoc + 1;
                double firstVal = (Double)dub[firstValLoc];
                double lastVal = (Double)dub[lastValLoc];
                retval = (firstVal + lastVal) / 2.0;
            } else {
                double firstVal;
                firstValLoc = (t.size() - 1) / 2;
                retval = firstVal = ((Double)dub[firstValLoc]).doubleValue();
            }
            PtgNumber pnum = new PtgNumber(retval);
            return pnum;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcMin(Ptg[] operands) {
        double result = Double.MAX_VALUE;
        Double d = null;
        int i = 0;
        while (i < operands.length) {
            Ptg[] pthings = operands[i].getComponents();
            if (pthings != null) {
                Ptg resPtg = StatisticalCalculator.calcMin(pthings);
                try {
                    if (resPtg instanceof PtgErr) {
                        return resPtg;
                    }
                    if (resPtg.getValue() != null && (d = new Double(String.valueOf(resPtg.getValue()))) < result) {
                        result = d;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                Ptg p = operands[i];
                try {
                    Object ov = p.getValue();
                    if (ov != null) {
                        if (ov.toString().equals(new PtgErr(PtgErr.ERROR_NA).toString())) {
                            return new PtgErr(PtgErr.ERROR_NA);
                        }
                        d = new Double(String.valueOf(ov));
                        if (d < result) {
                            result = d;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (result == Double.MAX_VALUE) {
            result = 0.0;
        }
        return new PtgNumber(result);
    }

    protected static Ptg calcMinA(Ptg[] operands) {
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        if (alloperands.length == 0) {
            return new PtgNumber(0.0);
        }
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < alloperands.length) {
            Object o = alloperands[i].getValue();
            try {
                double d = Double.MAX_VALUE;
                d = o instanceof Number ? ((Number)o).doubleValue() : (o instanceof Boolean ? (double)((Boolean)o != false ? 1 : 0) : new Double(o.toString()));
                min = Math.min(min, d);
            }
            catch (NumberFormatException e) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            ++i;
        }
        return new PtgNumber(min);
    }

    protected static Ptg calcMode(Ptg[] operands) {
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        Vector<Double> vals = new Vector<Double>();
        Vector<Double> occurences = new Vector<Double>();
        double retval = 0.0;
        int i = 0;
        while (i < alloperands.length) {
            Ptg p = alloperands[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                if (vals.contains(d)) {
                    int loc = vals.indexOf(d);
                    Double nums = (Double)occurences.get(loc);
                    Double newnum = new Double(nums + 1.0);
                    occurences.setElementAt(newnum, loc);
                } else {
                    vals.add(d);
                    occurences.add(new Double(1.0));
                }
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
            ++i;
        }
        double biggest = 0.0;
        double numvalues = 0.0;
        int i2 = 0;
        while (i2 < vals.size()) {
            Double size = (Double)occurences.elementAt(i2);
            if (size > biggest) {
                biggest = size;
                Double newhigh = (Double)vals.elementAt(i2);
                retval = newhigh;
            }
            ++i2;
        }
        PtgNumber pnum = new PtgNumber(retval);
        return pnum;
    }

    protected static Ptg calcNormdist(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        try {
            double x = operands[0].getDoubleVal();
            double mean = operands[1].getDoubleVal();
            double stddev = operands[2].getDoubleVal();
            if (stddev <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            boolean cumulative = PtgCalculator.getBooleanValue(operands[3]);
            if (mean == 0.0 && stddev == 1.0 && cumulative) {
                return StatisticalCalculator.calcNormsdist(operands);
            }
            if (!cumulative) {
                double a = Math.sqrt(Math.PI * 2 * Math.pow(stddev, 2.0));
                a = 1.0 / a;
                double exp = Math.pow(x - mean, 2.0);
                double b = Math.exp(-(exp /= 2.0 * Math.pow(stddev, 2.0)));
                return new PtgNumber(a * b);
            }
            Ptg[] o = new Ptg[]{new PtgNumber((x - mean) / (stddev * Math.sqrt(2.0)))};
            Ptg erf = EngineeringCalculator.calcErf(o);
            double cdf = 0.5 * (1.0 + erf.getDoubleVal());
            return new PtgNumber(cdf);
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcNormsdist(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        try {
            double result;
            double t;
            double x = operands[0].getDoubleVal();
            double b1 = 0.31938153;
            double b2 = -0.356563782;
            double b3 = 1.781477937;
            double b4 = -1.821255978;
            double b5 = 1.330274429;
            double p = 0.2316419;
            double c = 0.39894228;
            if (x >= 0.0) {
                t = 1.0 / (1.0 + 0.2316419 * x);
                result = 1.0 - 0.39894228 * Math.exp(-x * x / 2.0) * t * (t * (t * (t * (t * 1.330274429 + -1.821255978) + 1.781477937) + -0.356563782) + 0.31938153);
            } else {
                t = 1.0 / (1.0 - 0.2316419 * x);
                result = 0.39894228 * Math.exp(-x * x / 2.0) * t * (t * (t * (t * (t * 1.330274429 + -1.821255978) + 1.781477937) + -0.356563782) + 0.31938153);
            }
            BigDecimal bd = new BigDecimal(result);
            bd.setScale(15, RoundingMode.HALF_UP);
            return new PtgNumber(bd.doubleValue());
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    private static double expm1(double x) {
        double DBL_EPSILON = 1.0E-7;
        double a = Math.abs(x);
        if (a < 1.0E-7) {
            return x;
        }
        if (a > 0.697) {
            return Math.exp(x) - 1.0;
        }
        double y = a > 1.0E-8 ? Math.exp(x) - 1.0 : (x / 2.0 + 1.0) * x;
        y -= (1.0 + y) * (Math.log(1.0 + y) - x);
        return y;
    }

    private int R_Q_P01_check(int p, boolean log_p) {
        if (log_p && p > 0 || !log_p && (p < 0 || p > 1)) {
            return 0;
        }
        return 1;
    }

    private static double quartile(double p, double mu, double sigma) {
        double val;
        boolean lower_tail = true;
        boolean log_p = false;
        double R_D__0 = 0.0;
        double R_D__1 = 1.0;
        double R_DT_0 = 0.0;
        double R_DT_1 = 1.0;
        if (p == R_DT_0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == R_DT_1) {
            return Double.POSITIVE_INFINITY;
        }
        if (sigma < 0.0) {
            return 0.0;
        }
        if (sigma == 0.0) {
            return mu;
        }
        double d = log_p ? (lower_tail ? Math.exp(p) : -StatisticalCalculator.expm1(p)) : (p = lower_tail ? p : 1.0 - p);
        double p_ = log_p ? (lower_tail ? Math.exp(p) : -StatisticalCalculator.expm1(p)) : (lower_tail ? p : 1.0 - p);
        double q = p_ - 0.5;
        if (Math.abs(q) <= 0.425) {
            double r2 = 0.180625 - q * q;
            val = q * (((((((r2 * 2509.0809287301227 + 33430.57558358813) * r2 + 67265.7709270087) * r2 + 45921.95393154987) * r2 + 13731.69376550946) * r2 + 1971.5909503065513) * r2 + 133.14166789178438) * r2 + 3.3871328727963665) / (((((((r2 * 5226.495278852854 + 28729.085735721943) * r2 + 39307.89580009271) * r2 + 21213.794301586597) * r2 + 5394.196021424751) * r2 + 687.1870074920579) * r2 + 42.31333070160091) * r2 + 1.0);
        } else {
            double r3 = q > 0.0 ? (log_p ? (lower_tail ? -StatisticalCalculator.expm1(p) : Math.exp(p)) : (lower_tail ? 1.0 - p : p)) : p_;
            r3 = Math.sqrt(-(log_p && (lower_tail && q <= 0.0 || !lower_tail && q > 0.0) ? p : Math.log(r3)));
            val = r3 <= 5.0 ? ((((((((r3 += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r3 + 0.2417807251774506) * r3 + 1.2704582524523684) * r3 + 3.6478483247632045) * r3 + 5.769497221460691) * r3 + 4.630337846156546) * r3 + 1.4234371107496835) / (((((((r3 * 1.0507500716444169E-9 + 5.475938084995345E-4) * r3 + 0.015198666563616457) * r3 + 0.14810397642748008) * r3 + 0.6897673349851) * r3 + 1.6763848301838038) * r3 + 2.053191626637759) * r3 + 1.0) : ((((((((r3 += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r3 + 0.0012426609473880784) * r3 + 0.026532189526576124) * r3 + 0.29656057182850487) * r3 + 1.7848265399172913) * r3 + 5.463784911164114) * r3 + 6.657904643501103) / (((((((r3 * 2.0442631033899397E-15 + 1.421511758316446E-7) * r3 + 1.8463183175100548E-5) * r3 + 7.868691311456133E-4) * r3 + 0.014875361290850615) * r3 + 0.1369298809227358) * r3 + 0.599832206555888) * r3 + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }

    public static Ptg calcNormInv(Ptg[] operands) {
        try {
            double p = operands[0].getDoubleVal();
            if (p < 0.0 || p > 1.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double mean = operands[1].getDoubleVal();
            double stddev = operands[2].getDoubleVal();
            if (stddev <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double result = StatisticalCalculator.quartile(p, mean, stddev);
            return new PtgNumber(result);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    public static Ptg calcNormsInv(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getValueError();
        }
        try {
            double x = operands[0].getDoubleVal();
            if (x < 0.0 || x > 1.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double[] a = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
            double[] b = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
            double[] c = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
            double[] d = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
            double plow = 0.02425;
            double phigh = 1.0 - plow;
            if (x < plow) {
                double q = Math.sqrt(-2.0 * Math.log(x));
                BigDecimal r2 = new BigDecimal((((((c[0] * q + c[1]) * q + c[2]) * q + c[3]) * q + c[4]) * q + c[5]) / ((((d[0] * q + d[1]) * q + d[2]) * q + d[3]) * q + 1.0));
                r2.setScale(15, RoundingMode.HALF_UP);
                return new PtgNumber(r2.doubleValue());
            }
            if (phigh < x) {
                double q = Math.sqrt(-2.0 * Math.log(1.0 - x));
                BigDecimal r3 = new BigDecimal(-(((((c[0] * q + c[1]) * q + c[2]) * q + c[3]) * q + c[4]) * q + c[5]) / ((((d[0] * q + d[1]) * q + d[2]) * q + d[3]) * q + 1.0));
                r3.setScale(15, RoundingMode.HALF_UP);
                return new PtgNumber(r3.doubleValue());
            }
            double q = x - 0.5;
            double r4 = q * q;
            BigDecimal rr = new BigDecimal((((((a[0] * r4 + a[1]) * r4 + a[2]) * r4 + a[3]) * r4 + a[4]) * r4 + a[5]) * q / (((((b[0] * r4 + b[1]) * r4 + b[2]) * r4 + b[3]) * r4 + b[4]) * r4 + 1.0));
            rr.setScale(15, RoundingMode.HALF_UP);
            return new PtgNumber(rr.doubleValue());
        }
        catch (Exception e) {
            return PtgCalculator.getValueError();
        }
    }

    public static Ptg calcPearson(Ptg[] operands) throws CalculationException {
        return StatisticalCalculator.calcCorrel(operands);
    }

    protected static Ptg calcQuartile(Ptg[] operands) {
        Ptg[] aveoperands = new Ptg[]{operands[0]};
        Ptg[] allVals = PtgCalculator.getAllComponents(aveoperands);
        CompatibleVector t = new CompatibleVector();
        double retval = 0.0;
        int i = 0;
        while (i < allVals.length) {
            Ptg p = allVals[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                t.addOrderedDouble(d);
            }
            catch (NumberFormatException e) {
                Logger.logErr(e);
            }
            ++i;
        }
        Object[] dub = new Double[t.size()];
        t.toArray(dub);
        Object o = operands[1].getValue();
        Integer quart = o instanceof Integer ? (Integer)operands[1].getValue() : Integer.valueOf(((Double)operands[1].getValue()).intValue());
        float quartile = quart.floatValue();
        if (quart == 0) {
            return new PtgNumber((Double)dub[0]);
        }
        if (quart == 4) {
            return new PtgNumber((Double)dub[t.size() - 1]);
        }
        if (quart > 4 || quart < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        float kk = quartile / 4.0f;
        kk = (float)(dub.length - 1) * kk;
        int k = -1;
        float remainder = 0.0f;
        if ((kk += 1.0f) % 1.0f != 0.0f) {
            remainder = kk % 1.0f;
            String s = String.valueOf(kk);
            String ss = s.substring(s.indexOf("."), s.length());
            ss = "0" + ss;
            remainder = new Float(ss).floatValue();
            s = s.substring(0, s.indexOf("."));
            k = Integer.valueOf(String.valueOf(s));
        } else {
            k = (int)kk / 1;
        }
        if (k >= dub.length) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        double firstVal = (Double)dub[k - 1];
        double secondVal = (Double)dub[k];
        double output = firstVal + (double)remainder * (secondVal - firstVal);
        PtgNumber pn = new PtgNumber(output);
        return pn;
    }

    protected static Ptg calcRank(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg num = operands[0];
        Double theNum = null;
        try {
            Object o = num.getValue();
            theNum = o.equals("") ? new Double(0.0) : new Double(o.toString());
        }
        catch (NumberFormatException nfm) {
            return new PtgErr();
        }
        boolean ascending = true;
        if (operands.length < 3) {
            ascending = false;
        } else if (operands[2] instanceof PtgMissArg) {
            ascending = false;
        } else {
            PtgInt order = (PtgInt)operands[2];
            int i = order.getVal();
            if (i == 0) {
                ascending = false;
            }
        }
        Ptg[] aveoperands = new Ptg[]{operands[1]};
        Ptg[] refs = PtgCalculator.getAllComponents(aveoperands);
        CompatibleVector retList = new CompatibleVector();
        double retval = 0.0;
        int i = 0;
        while (i < refs.length) {
            Ptg p = refs[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                retList.addOrderedDouble(d);
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
            ++i;
        }
        Object[] dubRefs = new Double[retList.size()];
        if (ascending) {
            retList.toArray(dubRefs);
        } else {
            int i2 = 0;
            while (i2 < dubRefs.length) {
                dubRefs[i2] = (Double)retList.last();
                retList.remove(retList.size() - 1);
                ++i2;
            }
        }
        int res = -1;
        int i3 = 0;
        while (i3 < dubRefs.length) {
            if (((Double)dubRefs[i3]).toString().equalsIgnoreCase(theNum.toString())) {
                res = i3 + 1;
                i3 = dubRefs.length;
            }
            ++i3;
        }
        if (res == -1) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        return new PtgInt(res);
    }

    protected static Ptg calcRsq(Ptg[] operands) throws CalculationException {
        PtgNumber p = (PtgNumber)StatisticalCalculator.calcPearson(operands);
        double d = p.getVal();
        d *= d;
        return new PtgNumber(d);
    }

    protected static Ptg calcSlope(Ptg[] operands) throws CalculationException {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        double[] yvals = PtgCalculator.getDoubleValueArray(operands[0]);
        double[] xvals = PtgCalculator.getDoubleValueArray(operands[1]);
        if (xvals == null || yvals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double sumXVals = 0.0;
        int i = 0;
        while (i < xvals.length) {
            sumXVals += xvals[i];
            ++i;
        }
        double sumYVals = 0.0;
        int i2 = 0;
        while (i2 < yvals.length) {
            sumYVals += yvals[i2];
            ++i2;
        }
        double sumXYVals = 0.0;
        int i3 = 0;
        while (i3 < yvals.length) {
            sumXYVals += xvals[i3] * yvals[i3];
            ++i3;
        }
        double sqrXVals = 0.0;
        int i4 = 0;
        while (i4 < xvals.length) {
            sqrXVals += xvals[i4] * xvals[i4];
            ++i4;
        }
        double toparg = sumXVals * sumYVals - sumXYVals * (double)yvals.length;
        double bottomarg = sumXVals * sumXVals - sqrXVals * (double)xvals.length;
        double res = toparg / bottomarg;
        return new PtgNumber(res);
    }

    protected static Ptg calcSmall(Ptg[] operands) throws CalculationException {
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg rng = operands[0];
        Ptg[] array = PtgCalculator.getAllComponents(rng);
        if (array.length == 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int k = new Double(PtgCalculator.getDoubleValueArray(operands[1])[0]).intValue();
        if (k <= 0 || k > array.length) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        CompatibleVector sortedValues = new CompatibleVector();
        int i = 0;
        while (i < array.length) {
            Ptg p = array[i];
            try {
                Double d = new Double(String.valueOf(p.getValue()));
                sortedValues.addOrderedDouble(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        try {
            return new PtgNumber((Double)sortedValues.get(k - 1));
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcStdev(Ptg[] operands) throws CalculationException {
        double[] allVals = PtgCalculator.getDoubleValueArray(operands);
        if (allVals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double sqrDev = 0.0;
        int i = 0;
        while (i < allVals.length) {
            PtgNumber p = (PtgNumber)StatisticalCalculator.calcAverage(operands);
            double ave = p.getVal();
            sqrDev += Math.pow(allVals[i] - ave, 2.0);
            ++i;
        }
        double retval = Math.sqrt(sqrDev / (double)(allVals.length - 1));
        return new PtgNumber(retval);
    }

    public static Ptg calcSteyx(Ptg[] operands) throws CalculationException {
        Ptg[] arr = new Ptg[]{operands[0]};
        PtgNumber pn = (PtgNumber)StatisticalCalculator.calcVarp(arr);
        double yVarp = pn.getVal();
        arr[0] = operands[1];
        pn = (PtgNumber)StatisticalCalculator.calcVarp(arr);
        double xVarp = pn.getVal();
        double[] y = PtgCalculator.getDoubleValueArray(operands[0]);
        if (y == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        pn = (PtgNumber)StatisticalCalculator.calcSlope(operands);
        double slope = pn.getVal();
        double retval = (yVarp *= (double)y.length) - slope * slope * (xVarp *= (double)y.length);
        retval /= (double)(y.length - 2);
        retval = Math.sqrt(retval);
        return new PtgNumber(retval);
    }

    protected static Ptg calcTrend(Ptg[] operands) throws CalculationException {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg calcVar(Ptg[] operands) throws CalculationException {
        double[] allVals = PtgCalculator.getDoubleValueArray(operands);
        if (allVals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double sqrDev = 0.0;
        int i = 0;
        while (i < allVals.length) {
            PtgNumber p = (PtgNumber)StatisticalCalculator.calcAverage(operands);
            double ave = p.getVal();
            sqrDev += Math.pow(allVals[i] - ave, 2.0);
            ++i;
        }
        double retval = sqrDev / (double)(allVals.length - 1);
        return new PtgNumber(retval);
    }

    protected static Ptg calcVarp(Ptg[] operands) throws CalculationException {
        double[] allVals = PtgCalculator.getDoubleValueArray(operands);
        if (allVals == null) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        double sqrDev = 0.0;
        int i = 0;
        while (i < allVals.length) {
            PtgNumber p = (PtgNumber)StatisticalCalculator.calcAverage(operands);
            double ave = p.getVal();
            sqrDev += Math.pow(allVals[i] - ave, 2.0);
            ++i;
        }
        double retval = sqrDev / (double)allVals.length;
        return new PtgNumber(retval);
    }
}

