/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.toolkit.ByteTools;

public class PtgNumber
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -1650136303920724485L;
    double val;
    boolean percentage = false;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public String getString() {
        if (!this.percentage) {
            return String.valueOf(this.val);
        }
        return String.valueOf(String.valueOf(this.val * 100.0)) + "%";
    }

    @Override
    public Object getValue() {
        Double d = new Double(this.val);
        return d;
    }

    public PtgNumber() {
        this.ptgId = (byte)31;
        this.val = 0.0;
        this.updateRecord();
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    public PtgNumber(double d) {
        this.ptgId = (byte)31;
        this.val = d;
        this.updateRecord();
    }

    private void populateVals() {
        byte[] barr = new byte[8];
        System.arraycopy(this.record, 1, barr, 0, 8);
        this.val = ByteTools.eightBytetoLEDouble(barr);
    }

    public double getVal() {
        return this.val;
    }

    @Override
    public double getDoubleVal() {
        return this.val;
    }

    public void setVal(double i) {
        this.val = i;
        this.updateRecord();
    }

    public void setVal(String s) {
        if ((s = s.trim()).indexOf("%") == s.length() - 1) {
            this.percentage = true;
            s = s.substring(0, s.indexOf("%"));
            this.val = new Double(s) / 100.0;
        } else {
            this.val = new Double(s);
        }
    }

    @Override
    public void updateRecord() {
        byte[] tmp = new byte[]{this.ptgId};
        byte[] brow = ByteTools.toBEByteArray(this.val);
        tmp = ByteTools.append(brow, tmp);
        this.record = tmp;
    }

    @Override
    public int getLength() {
        return 9;
    }

    public String toString() {
        return this.getString();
    }
}

