/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.toolkit.Logger;
import java.lang.reflect.Array;

public class PtgEQ
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 5446048862531696036L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    public PtgEQ() {
        this.ptgId = (byte)11;
        this.record = new byte[1];
        this.record[0] = 11;
    }

    @Override
    public String getString() {
        return "=";
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        boolean res = false;
        if (form.length != 2) {
            Logger.logInfo("calculating formula, wrong number of values in PtgEQ");
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Object[] o = GenericPtg.getValuesFromPtgs(form);
        if (o == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (o[1].getClass().isArray() && !o[0].getClass().isArray()) {
            Object tmp = o[0];
            o[0] = o[1];
            o[1] = tmp;
        }
        if (!o[0].getClass().isArray()) {
            if (o.length != 2) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            boolean isDouble = false;
            int i = 0;
            while (i < 2 && !isDouble) {
                isDouble = o[i] instanceof Double;
                ++i;
            }
            i = 0;
            while (i < 2) {
                if (o[i] != null && o[i].toString().equals("")) {
                    o[i] = isDouble ? new Double(0.0) : "";
                }
                ++i;
            }
            if (o[0] == o[1]) {
                res = true;
            } else if (o[0] == null || o[1] == null) {
                res = false;
            } else if (o[0] instanceof Double && o[1] instanceof Double) {
                res = Math.abs((Double)o[0] - (Double)o[1]) < this.doublePrecision;
            } else if (o[0].toString().equalsIgnoreCase(o[1].toString())) {
                res = true;
            }
        } else {
            String retArry = "";
            int nArrays = Array.getLength(o);
            if (nArrays != 2) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            int nVals = Array.getLength(o[0]);
            if (nVals == 0) {
                retArry = "{false}";
                PtgArray pa = new PtgArray();
                pa.setVal(retArry);
                return pa;
            }
            int i = 0;
            while (i < nArrays - 1) {
                res = false;
                Object secondOp = null;
                boolean comparitorIsArray = o[i + 1].getClass().isArray();
                if (!comparitorIsArray) {
                    secondOp = o[i + 1];
                }
                int j = 0;
                while (j < nVals) {
                    Object firstOp = Array.get(o[i], j);
                    if (comparitorIsArray) {
                        secondOp = Array.get(o[i + 1], j);
                    }
                    double fd = 0.0;
                    double sd = 0.0;
                    try {
                        fd = new Double(firstOp.toString());
                        sd = new Double(secondOp.toString());
                        res = Math.abs(fd - sd) <= this.doublePrecision;
                    }
                    catch (Exception e) {
                        res = firstOp.toString().equalsIgnoreCase(secondOp.toString());
                    }
                    retArry = String.valueOf(retArry) + res + ",";
                    ++j;
                }
                i += 2;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        PtgBool pboo = new PtgBool(res);
        return pboo;
    }
}

