/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class PtgArray
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 4416140231168551393L;
    int nc = -1;
    int nr = -1;
    byte[] rgval;
    CompatibleVector arrVals = new CompatibleVector();
    boolean isIntermediary = false;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    public byte[] getPreRecord() {
        return this.record;
    }

    public byte[] getPostRecord() {
        return this.rgval;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    private void populateVals() {
        if (this.record.length > 8) {
            this.rgval = new byte[this.record.length - 8];
            System.arraycopy(this.record, 8, this.rgval, 0, this.rgval.length);
        }
        if (this.rgval != null) {
            byte[] b = new byte[8];
            b[0] = this.record[0];
            this.record = b;
            this.parseArrayComponents();
        }
    }

    public void parseArrayComponents() {
        int nitems = 0;
        this.arrVals.clear();
        if (!this.isIntermediary) {
            this.nc = this.rgval[0] & 0xFF;
        }
        this.nr = ByteTools.readShort(this.rgval[1], this.rgval[2]);
        try {
            int i = 3;
            while (i < this.rgval.length) {
                if (this.rgval[i] == 0) {
                    ++i;
                    i += 8;
                    this.arrVals.add("");
                } else if (this.rgval[i] == 1) {
                    byte[] barr = new byte[8];
                    System.arraycopy(this.rgval, ++i, barr, 0, 8);
                    double val = ByteTools.eightBytetoLEDouble(barr);
                    Double d = new Double(val);
                    this.arrVals.add(d);
                    i += 8;
                } else if (this.rgval[i] == 2) {
                    short strLen = ByteTools.readShort(this.rgval[i + 1], this.rgval[i + 2]);
                    i += 3;
                    byte grbt = this.rgval[i++];
                    byte[] barr = new byte[strLen];
                    System.arraycopy(this.rgval, i, barr, 0, strLen);
                    String strVal = "";
                    try {
                        strVal = (grbt & 1) == 1 ? new String(barr, "UTF-16LE") : new String(barr, "ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException e) {
                        Logger.logInfo("decoding formula string in array failed: " + e);
                    }
                    this.arrVals.add(strVal);
                    i += strLen;
                } else if (this.rgval[i] == 4) {
                    if (this.rgval[++i] == 0) {
                        this.arrVals.add(false);
                    } else {
                        this.arrVals.add(true);
                    }
                    i += 8;
                } else if (this.rgval[i] == 16) {
                    byte errCode = this.rgval[++i];
                    switch (errCode) {
                        case 0: {
                            this.arrVals.add("#NULL!");
                            break;
                        }
                        case 7: {
                            this.arrVals.add("#DIV/0!");
                            break;
                        }
                        case 15: {
                            this.arrVals.add("#VALUE!");
                            break;
                        }
                        case 23: {
                            this.arrVals.add("#REF!");
                            break;
                        }
                        case 29: {
                            this.arrVals.add("#NAME!");
                            break;
                        }
                        case 36: {
                            this.arrVals.add("#NUM!");
                            break;
                        }
                        case 42: {
                            this.arrVals.add("#N/A!");
                        }
                    }
                    i += 8;
                }
                if (++nitems != (this.nc + 1) * (this.nr + 1)) continue;
                int length = i;
                i = this.rgval.length;
                if (this.rgval.length == length) continue;
                byte[] tmp = new byte[length];
                System.arraycopy(this.rgval, 0, tmp, 0, length);
                this.rgval = tmp;
            }
        }
        catch (Exception e) {
            Logger.logErr("Error Processing Array Formula: " + e.toString());
            return;
        }
    }

    public int getVal() {
        return -1;
    }

    @Override
    public Object getValue() {
        return this.getString();
    }

    @Override
    public String getString() {
        String retVal = null;
        Ptg[] p = this.getComponents();
        String retstr = "";
        if (this.nc == 0 && this.nr == 0) {
            int i = 0;
            while (i < p.length) {
                if (i != 0) {
                    retstr = String.valueOf(retstr) + ",";
                }
                retstr = String.valueOf(retstr) + p[i].getValue().toString();
                ++i;
            }
        } else {
            retstr = "";
            int loc = 0;
            int x = 0;
            while (x < this.nr + 1) {
                if (x != 0) {
                    retstr = String.valueOf(retstr) + ";";
                }
                int i = 0;
                while (i < this.nc + 1) {
                    if (i != 0) {
                        retstr = String.valueOf(retstr) + ",";
                    }
                    retstr = String.valueOf(retstr) + p[loc++].getValue().toString();
                    ++i;
                }
                ++x;
            }
        }
        retVal = retstr;
        return "{" + retVal + "}";
    }

    @Override
    public String getTextString() {
        return this.getString();
    }

    public void setVal(String arrStr) {
        if ((arrStr = arrStr.substring(1, arrStr.length() - 1)).indexOf("{") != -1) {
            Logger.logErr("PtgArray.setVal: Multiple Arrays Encountered");
        }
        String[] rows = null;
        String[][] cols = null;
        rows = arrStr.split(";");
        cols = new String[rows.length][];
        int i = 0;
        while (i < rows.length) {
            String[] s = rows[i].split(",", -1);
            cols[i] = s;
            ++i;
        }
        byte[] databytes = new byte[11];
        databytes[0] = 96;
        this.isIntermediary = false;
        if (cols[0].length >= 255) {
            this.isIntermediary = true;
            this.nc = cols[0].length - 1;
        }
        databytes[8] = (byte)(cols[0].length - 1 & 0xFF);
        System.arraycopy(ByteTools.shortToLEBytes((short)(rows.length - 1)), 0, databytes, 9, 2);
        int j = 0;
        while (j < rows.length) {
            int i2 = 0;
            while (i2 < cols[0].length) {
                byte[] valbytes = this.valuesIntoByteArray(cols[j][i2]);
                databytes = ByteTools.append(valbytes, databytes);
                ++i2;
            }
            ++j;
        }
        this.record = databytes;
        this.init(databytes);
    }

    private byte[] valuesIntoByteArray(String constVal) {
        byte[] databytes = new byte[]{};
        byte[] thisElement = new byte[9];
        try {
            Double d = new Double(constVal);
            thisElement[0] = 1;
            byte[] b = ByteTools.toBEByteArray(d);
            System.arraycopy(b, 0, thisElement, 1, b.length);
            databytes = ByteTools.append(thisElement, databytes);
        }
        catch (NumberFormatException ee) {
            try {
                if (constVal.equalsIgnoreCase("true") || constVal.equalsIgnoreCase("false")) {
                    Boolean bb = Boolean.valueOf(constVal);
                    thisElement[0] = 4;
                    thisElement[1] = (byte)(bb != false ? 1 : 0);
                } else if (constVal == null || constVal.equals("")) {
                    thisElement[0] = 0;
                } else if (constVal.charAt(0) == '#') {
                    thisElement[0] = 16;
                    int errCode = 0;
                    if (constVal.equals("#NULL!")) {
                        errCode = 0;
                    } else if (constVal.equals("#DIV/0!")) {
                        errCode = 7;
                    } else if (constVal.equals("#VALUE!")) {
                        errCode = 15;
                    } else if (constVal.equals("#REF!")) {
                        errCode = 23;
                    } else if (constVal.equals("#NAME!")) {
                        errCode = 29;
                    } else if (constVal.equals("#NUM!")) {
                        errCode = 36;
                    } else if (constVal.equals("#N/A!") || constVal.equals("#N/A") || constVal.equals("N/A")) {
                        errCode = 42;
                    }
                    thisElement[1] = (byte)errCode;
                } else {
                    thisElement = new byte[3];
                    try {
                        thisElement = new byte[4];
                        thisElement[0] = 2;
                        byte[] b = constVal.getBytes("UTF-16LE");
                        System.arraycopy(ByteTools.shortToLEBytes((short)b.length), 0, thisElement, 1, 2);
                        thisElement[3] = 1;
                        thisElement = ByteTools.append(b, thisElement);
                    }
                    catch (UnsupportedEncodingException z) {
                        Logger.logWarn("encoding formula array:" + z);
                    }
                }
                databytes = ByteTools.append(thisElement, databytes);
            }
            catch (Exception ex) {
                Logger.logWarn("PtgArray.valuesIntoByteArray:  error parsing array element:" + ex);
            }
        }
        return databytes;
    }

    @Override
    public int getLength() {
        return 8;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public Ptg[] getComponents() {
        Ptg[] retVals = new Ptg[this.arrVals.size()];
        int i = 0;
        while (i < this.arrVals.size()) {
            Object o = this.arrVals.elementAt(i);
            if (o instanceof Double) {
                Double d = (Double)o;
                PtgNumber pnum = new PtgNumber(d);
                retVals[i] = pnum;
            } else if (o instanceof Boolean) {
                PtgBool pb = new PtgBool((Boolean)o);
                retVals[i] = pb;
            } else if (FormulaParser.isRef((String)o) || FormulaParser.isRange((String)o)) {
                PtgArea3d pa = new PtgArea3d();
                pa.setParentRec(this.getParentRec());
                pa.setUseReferenceTracker(true);
                pa.setLocation((String)o);
                Ptg[] pacomps = pa.getComponents();
                Ptg[] temp = new Ptg[retVals.length - 1 + pacomps.length];
                System.arraycopy(retVals, 0, temp, 0, retVals.length - 1);
                System.arraycopy(pacomps, 0, temp, retVals.length - 1, pacomps.length);
                retVals = temp;
            } else {
                PtgStr pstr = new PtgStr((String)o);
                retVals[i] = pstr;
            }
            ++i;
        }
        return retVals;
    }

    public int getNumberOfRows() {
        return this.nr;
    }

    public int getNumberOfColumns() {
        return this.nc;
    }

    public int setArrVals(byte[] by) {
        this.rgval = by;
        if (this.rgval != null) {
            byte[] b = new byte[8];
            b[0] = this.record[0];
            this.record = b;
            this.parseArrayComponents();
        }
        return this.rgval.length;
    }

    public byte[] getArrVals() {
        return this.rgval;
    }

    public Ptg elementAt(int loc) {
        Ptg[] p = this.getComponents();
        return p[loc];
    }

    public Ptg elementAt(int col, int row) {
        Ptg[] p = this.getComponents();
        try {
            int loc = 0;
            int i = 0;
            while (i < row) {
                loc += this.nc;
                ++i;
            }
            return this.elementAt(loc += col);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logger.logErr("PtgArray.elementAt: error retrieving value at [" + row + "," + col + "]: " + e);
            return null;
        }
    }
}

