/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgNumber;
import java.lang.reflect.Array;

public class PtgAdd
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -964400139336259946L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    public PtgAdd() {
        this.ptgId = (byte)3;
        this.record = new byte[1];
        this.record[0] = 3;
    }

    @Override
    public String getString() {
        return "+";
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        try {
            Object[] o = GenericPtg.getValuesFromPtgs(form);
            if (o == null) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            if (!o[0].getClass().isArray()) {
                if (o.length != 2) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                double o0 = 0.0;
                double o1 = 0.0;
                try {
                    o0 = PtgAdd.getDoubleValue(o[0], this.parent_rec);
                    o1 = PtgAdd.getDoubleValue(o[1], this.parent_rec);
                }
                catch (NumberFormatException e) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                double returnVal = o0 + o1;
                PtgNumber n = new PtgNumber(returnVal);
                return n;
            }
            String retArry = "";
            int nArrays = Array.getLength(o);
            if (nArrays != 2) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            int nVals = Array.getLength(o[0]);
            int i = 0;
            while (i < nArrays - 1) {
                Object secondOp = null;
                boolean comparitorIsArray = o[i + 1].getClass().isArray();
                if (!comparitorIsArray) {
                    secondOp = o[i + 1];
                }
                int j = 0;
                while (j < nVals) {
                    block15: {
                        Object firstOp = Array.get(o[i], j);
                        if (comparitorIsArray) {
                            secondOp = Array.get(o[i + 1], j);
                        }
                        double o0 = 0.0;
                        double o1 = 0.0;
                        try {
                            o0 = PtgAdd.getDoubleValue(firstOp, this.parent_rec);
                            o1 = PtgAdd.getDoubleValue(secondOp, this.parent_rec);
                        }
                        catch (NumberFormatException e) {
                            retArry = String.valueOf(retArry) + "#VALUE!" + ",";
                            break block15;
                        }
                        double retVal = o0 + o1;
                        retArry = String.valueOf(retArry) + retVal + ",";
                    }
                    ++j;
                }
                i += 2;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        catch (NumberFormatException e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
        catch (Exception e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
    }
}

