/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.InvalidRecordException;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.XLSRecordFactory;
import com.extentech.formats.XLS.formulas.FunctionConstants;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgAdd;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgAtr;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgConcat;
import com.extentech.formats.XLS.formulas.PtgDiv;
import com.extentech.formats.XLS.formulas.PtgEQ;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgExp;
import com.extentech.formats.XLS.formulas.PtgFunc;
import com.extentech.formats.XLS.formulas.PtgFuncVar;
import com.extentech.formats.XLS.formulas.PtgGE;
import com.extentech.formats.XLS.formulas.PtgGT;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgLE;
import com.extentech.formats.XLS.formulas.PtgLT;
import com.extentech.formats.XLS.formulas.PtgMissArg;
import com.extentech.formats.XLS.formulas.PtgMlt;
import com.extentech.formats.XLS.formulas.PtgNE;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNameX;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgParen;
import com.extentech.formats.XLS.formulas.PtgPercent;
import com.extentech.formats.XLS.formulas.PtgPower;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.formats.XLS.formulas.PtgSub;
import com.extentech.formats.XLS.formulas.PtgUMinus;
import com.extentech.formats.XLS.formulas.PtgUPlus;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

public final class FormulaParser {
    static int DEBUGLEVEL = -1;

    public static Stack getPtgsFromFormulaString(XLSRecord form, String fmla) {
        return FormulaParser.getPtgsFromFormulaString(form, fmla, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Stack getPtgsFromFormulaString(XLSRecord form, String fmla, boolean bMergeWithLast) {
        Object[] operands = new Object[2];
        if ((fmla = fmla.trim()).startsWith("=")) {
            fmla = fmla.substring(1);
        }
        if ((fmla = fmla.trim()).equals("")) {
            Stack<PtgMissArg> s = new Stack<PtgMissArg>();
            s.add(new PtgMissArg());
            return s;
        }
        if (fmla.startsWith("{")) {
            PtgArray pa = new PtgArray();
            pa.setParentRec(form);
            int endarray = FormulaParser.getMatchOperator(fmla, 0, '{', '}');
            pa.setVal(fmla.substring(0, endarray + 1));
            fmla = fmla.substring(endarray + 1);
            Stack<PtgArray> s = new Stack<PtgArray>();
            s.add(pa);
            operands[0] = s;
            bMergeWithLast = false;
        }
        boolean inQuote = false;
        boolean inRange = false;
        boolean inOp = false;
        String prefix = "";
        Stack<String> ops = new Stack<String>();
        String op = "";
        int i = 0;
        while (i < fmla.length()) {
            block49: {
                char c;
                block56: {
                    block53: {
                        block54: {
                            block55: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block48: {
                                                c = fmla.charAt(i);
                                                if (c != '\"' && c != '\'') break block48;
                                                if ((inQuote = inQuote ? c != prefix.trim().charAt(0) : true) && inOp) {
                                                    inOp = false;
                                                    if (!op.equals("")) {
                                                        ops.add(0, op);
                                                    }
                                                    op = "";
                                                    if (operands[0] != null && operands[1] != null) {
                                                        FormulaParser.addOperands(form, operands, ops);
                                                    }
                                                }
                                                prefix = String.valueOf(prefix) + c;
                                                break block49;
                                            }
                                            if (!inQuote) break block50;
                                            prefix = String.valueOf(prefix) + c;
                                            break block49;
                                        }
                                        if (c != ':') break block51;
                                        if (i > 0) {
                                            inRange = true;
                                        }
                                        prefix = String.valueOf(prefix) + c;
                                        break block49;
                                    }
                                    if (c != '(') break block52;
                                    if (inRange) {
                                        prefix = String.valueOf(prefix) + c;
                                    } else {
                                        Stack s;
                                        if (inOp) {
                                            inOp = false;
                                            if (!op.equals("")) {
                                                ops.add(0, op);
                                            }
                                            op = "";
                                            if (!ops.isEmpty() && operands[0] != null && operands[1] != null) {
                                                FormulaParser.addOperands(form, operands, ops);
                                            }
                                        }
                                        String funcName = "";
                                        int k = prefix.length() - 1;
                                        while (k >= 0) {
                                            if (!Character.isLetterOrDigit(prefix.charAt(k)) && !Character.toString(prefix.charAt(k)).equals(".")) break;
                                            funcName = String.valueOf(prefix.charAt(k)) + funcName;
                                            prefix = prefix.substring(0, k);
                                            --k;
                                        }
                                        if (!prefix.trim().equals("")) {
                                            if (operands[0] == null) {
                                                operands[0] = prefix.trim();
                                            } else {
                                                operands[1] = prefix.trim();
                                            }
                                            prefix = "";
                                        }
                                        if (!funcName.equals("")) {
                                            Ptg funcPtg = null;
                                            funcPtg = FormulaParser.getFuncPtg(funcName, form);
                                            if (funcPtg == null) throw new FunctionNotSupportedException(String.valueOf(funcName) + " is not a supported function");
                                            int endparen = FormulaParser.getMatchOperator(fmla, i, '(', ')');
                                            if (endparen < fmla.length() - 1 && fmla.charAt(endparen + 1) == ':') {
                                                inRange = true;
                                                prefix = String.valueOf(funcName) + fmla.substring(i, endparen + 1);
                                                i = endparen;
                                            } else {
                                                if (!ops.isEmpty() && operands[0] != null && operands[1] != null) {
                                                    FormulaParser.addOperands(form, operands, ops);
                                                    inOp = false;
                                                }
                                                s = FormulaParser.parseFunctionPtg(form, funcName, fmla.substring(i + 1, endparen), funcPtg);
                                                if (operands[0] == null) {
                                                    operands[0] = s;
                                                } else {
                                                    operands[1] = s;
                                                }
                                                i = endparen;
                                            }
                                        } else {
                                            int endparen = FormulaParser.getMatchOperator(fmla, i, '(', ')');
                                            if (endparen == -1 || endparen < fmla.length() - 1 && fmla.charAt(endparen + 1) == ':') {
                                                inRange = true;
                                                prefix = "(";
                                            } else {
                                                String f = fmla.substring(i + 1, endparen);
                                                i = endparen;
                                                if (FormulaParser.isComplexRange(String.valueOf('(') + f + ')')) {
                                                    s = new Stack();
                                                    s.push(FormulaParser.parseSinglePtg(form, String.valueOf('(') + f + ')', false));
                                                    s.push(FormulaParser.parseSinglePtg(form, ")", false));
                                                    if (operands[0] == null) {
                                                        operands[0] = s;
                                                    } else {
                                                        operands[1] = s;
                                                    }
                                                } else {
                                                    s = FormulaParser.getPtgsFromFormulaString(form, f, true);
                                                    s.push(new PtgParen());
                                                    if (operands[0] == null) {
                                                        operands[0] = s;
                                                    } else {
                                                        operands[1] = s;
                                                    }
                                                    if (!ops.isEmpty()) {
                                                        FormulaParser.addOperands(form, operands, ops);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    break block49;
                                }
                                if (Character.isJavaIdentifierPart(c) || c == ' ' || c == '%') break block53;
                                if (!inRange) break block54;
                                if (c != ',' && c != ' ' && c != ')' && c != '!') break block55;
                                prefix = String.valueOf(prefix) + c;
                                break block49;
                            }
                            inRange = false;
                            if (!prefix.trim().equals("")) {
                                if (operands[0] == null) {
                                    operands[0] = prefix.trim();
                                } else {
                                    operands[1] = prefix.trim();
                                }
                                prefix = "";
                            }
                        }
                        if (c == '!' || c == '#' || c == '.') break block56;
                        inOp = true;
                        if (!prefix.trim().equals("")) {
                            if (operands[0] == null) {
                                operands[0] = prefix.trim();
                            } else {
                                operands[1] = prefix.trim();
                            }
                            prefix = "";
                        }
                        if (!ops.isEmpty() && operands[0] != null && operands[1] != null) {
                            FormulaParser.addOperands(form, operands, ops);
                        }
                        if (!op.equals("") && c != '=' && c != '>') {
                            ops.add(0, op);
                            op = "";
                        }
                        op = String.valueOf(op) + c;
                        break block49;
                    }
                    if (inOp) {
                        inOp = false;
                        if (!ops.isEmpty() && operands[0] != null && operands[1] != null) {
                            FormulaParser.addOperands(form, operands, ops);
                        }
                        if (!op.equals("")) {
                            ops.add(0, op);
                        }
                        op = "";
                    }
                }
                prefix = String.valueOf(prefix) + c;
            }
            ++i;
        }
        if (!prefix.trim().equals("")) {
            if (operands[0] == null) {
                operands[0] = prefix.trim();
            } else {
                operands[1] = prefix.trim();
            }
            prefix = "";
        }
        if (!op.equals("")) {
            ops.add(0, op);
        }
        FormulaParser.addOperands(form, operands, ops);
        return (Stack)operands[0];
    }

    private static void addOperands(XLSRecord form, Object[] operands, Stack ops) {
        Ptg pOp = null;
        if (!ops.isEmpty()) {
            pOp = FormulaParser.parseSinglePtg(form, (String)ops.pop(), operands[1] == null);
        }
        Stack s = new Stack();
        s.addAll(FormulaParser.handleOperatorPrecedence(form, operands, pOp));
        operands[0] = s;
        if (!ops.isEmpty()) {
            pOp = FormulaParser.parseSinglePtg(form, (String)ops.pop(), true);
            s = new Stack();
            s.addAll(FormulaParser.handleOperatorPrecedence(form, operands, pOp));
            operands[0] = s;
        }
    }

    private static Stack handleOperatorPrecedence(XLSRecord form, Object[] operands, Ptg pOp) {
        Ptg lastOp;
        Stack functionStack = new Stack();
        if (operands[0] instanceof Stack) {
            functionStack = (Stack)operands[0];
            operands[0] = null;
        }
        if (!functionStack.isEmpty() && pOp != null && (lastOp = (Ptg)functionStack.peek()) != null && lastOp.getIsOperator() && lastOp.getIsOperator()) {
            functionStack.pop();
            int group1 = FormulaParser.rankPrecedence(pOp);
            int group2 = FormulaParser.rankPrecedence(lastOp);
            if (group2 >= group1) {
                functionStack.push(lastOp);
            } else {
                if (operands[0] != null) {
                    if (operands[0] instanceof String) {
                        functionStack.push(FormulaParser.parseSinglePtg(form, (String)operands[0], functionStack.isEmpty()));
                    } else {
                        functionStack.addAll((Stack)operands[0]);
                    }
                }
                if (operands[1] != null) {
                    if (operands[1] instanceof String) {
                        functionStack.push(FormulaParser.parseSinglePtg(form, (String)operands[1], functionStack.isEmpty()));
                    } else {
                        functionStack.addAll((Stack)operands[1]);
                    }
                }
                operands[0] = null;
                operands[1] = null;
                functionStack.push(pOp);
                pOp = lastOp;
            }
        }
        if (operands[0] != null) {
            if (operands[0] instanceof String) {
                functionStack.push(FormulaParser.parseSinglePtg(form, (String)operands[0], functionStack.isEmpty()));
            } else {
                functionStack.addAll((Stack)operands[0]);
            }
        }
        if (operands[1] != null) {
            if (operands[1] instanceof String) {
                functionStack.push(FormulaParser.parseSinglePtg(form, (String)operands[1], functionStack.isEmpty()));
            } else {
                functionStack.addAll((Stack)operands[1]);
            }
        }
        operands[0] = null;
        operands[1] = null;
        if (pOp != null) {
            functionStack.push(pOp);
        }
        return functionStack;
    }

    private static Stack mergeStacks(Stack prevStack, Stack curStack, boolean bIsCompleteExpression) {
        if (prevStack.isEmpty()) {
            return curStack;
        }
        Ptg lastOp = (Ptg)prevStack.peek();
        Ptg curOp = curStack.isEmpty() ? null : (Ptg)curStack.peek();
        int group1 = FormulaParser.rankPrecedence(lastOp);
        int group2 = FormulaParser.rankPrecedence(curOp);
        if (group1 >= 0 && (group1 < group2 || group2 == -1)) {
            lastOp = (Ptg)prevStack.pop();
            curStack.push(lastOp);
        }
        prevStack.addAll(curStack);
        return prevStack;
    }

    private static Stack parseFunctionPtg(XLSRecord form, String func, String fmla, Ptg funcPtg) {
        Stack<Ptg> returnStack = new Stack<Ptg>();
        fmla = fmla.trim();
        int nParens = 0;
        boolean enclosing = false;
        if (fmla.length() > 0 && fmla.charAt(0) == '(') {
            if (FormulaParser.getMatchOperator(fmla, 0, '(', ')') == fmla.length() - 1) {
                ++nParens;
                enclosing = true;
            }
            fmla = fmla.trim();
        }
        int funcLen = 1;
        if (enclosing) {
            returnStack.addAll(FormulaParser.getPtgsFromFormulaString(form, fmla, true));
        } else {
            CompatibleVector cv = FormulaParser.splitFunctionOperands(fmla);
            funcLen = cv.size();
            int y = 0;
            while (y < cv.size()) {
                String s = (String)cv.elementAt(y);
                returnStack.addAll(FormulaParser.getPtgsFromFormulaString(form, s, true));
                ++y;
            }
        }
        if (funcPtg instanceof PtgFuncVar) {
            if (((PtgFuncVar)funcPtg).getVal() == 255) {
                PtgNameX pn = new PtgNameX();
                pn.setParentRec(form);
                pn.setName(func);
                returnStack.add(0, pn);
                ++funcLen;
                funcPtg.setParentRec(form);
            }
            ((PtgFuncVar)funcPtg).setNumParams((byte)funcLen);
        }
        returnStack.push(funcPtg);
        return returnStack;
    }

    static int rankPrecedence(Ptg curOp) {
        if (curOp == null) {
            return -1;
        }
        if (curOp instanceof PtgUMinus || curOp instanceof PtgUPlus) {
            return 7;
        }
        if (curOp instanceof PtgPercent) {
            return 6;
        }
        if (curOp instanceof PtgPower) {
            return 5;
        }
        if (curOp instanceof PtgMlt || curOp instanceof PtgDiv) {
            return 4;
        }
        if (curOp instanceof PtgAdd || curOp instanceof PtgSub) {
            return 3;
        }
        if (curOp instanceof PtgConcat) {
            return 2;
        }
        if (curOp instanceof PtgEQ || curOp instanceof PtgNE || curOp instanceof PtgLE || curOp instanceof PtgLT || curOp instanceof PtgGE || curOp instanceof PtgGT) {
            return 1;
        }
        return -1;
    }

    public static int getMatchOperator(String input, int startParenLoc, char matchOpenChar, char matchCloseChar) {
        int openCnt = 0;
        int i = startParenLoc;
        while (i < input.length()) {
            if (input.charAt(i) == '\"' || input.charAt(i) == '\'') {
                char endquote = input.charAt(i);
                while (++i < input.length()) {
                    if (input.charAt(i) == endquote) break;
                }
            }
            if (i == input.length()) {
                return i - 1;
            }
            if (input.charAt(i) == matchOpenChar) {
                ++openCnt;
            } else if (input.charAt(i) == matchCloseChar && --openCnt == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static Ptg getFuncPtg(String func, XLSRecord form) {
        int y;
        GenericPtg funcPtg = null;
        if (Locale.JAPAN.equals(Locale.getDefault())) {
            y = 0;
            while (y < FunctionConstants.jRecArr.length) {
                if (func.equalsIgnoreCase(FunctionConstants.jRecArr[y][0])) {
                    int FID = Integer.parseInt(FunctionConstants.jRecArr[y][1]);
                    int Ftype = Integer.parseInt(FunctionConstants.jRecArr[y][2]);
                    if (Ftype == FunctionConstants.FTYPE_PTGFUNC) {
                        funcPtg = new PtgFunc(FID, form);
                    } else if (Ftype == FunctionConstants.FTYPE_PTGFUNCVAR) {
                        funcPtg = new PtgFuncVar(FID, 0, form);
                    } else if (Ftype == FunctionConstants.FTYPE_PTGFUNCVAR_ADDIN) {
                        funcPtg = new PtgFuncVar(255, 0, form);
                    }
                    return funcPtg;
                }
                ++y;
            }
        }
        y = 0;
        while (y < FunctionConstants.recArr.length) {
            if (func.equalsIgnoreCase(FunctionConstants.recArr[y][0])) {
                int FID = Integer.parseInt(FunctionConstants.recArr[y][1]);
                int Ftype = Integer.parseInt(FunctionConstants.recArr[y][2]);
                if (Ftype == FunctionConstants.FTYPE_PTGFUNC) {
                    funcPtg = new PtgFunc(FID, form);
                } else if (Ftype == FunctionConstants.FTYPE_PTGFUNCVAR) {
                    funcPtg = new PtgFuncVar(FID, 0, form);
                } else if (Ftype == FunctionConstants.FTYPE_PTGFUNCVAR_ADDIN) {
                    funcPtg = new PtgFuncVar(255, 0, form);
                }
                return funcPtg;
            }
            ++y;
        }
        y = 0;
        while (y < FunctionConstants.unimplRecArr.length) {
            if (func.equalsIgnoreCase(FunctionConstants.unimplRecArr[y][0])) {
                int FID = Integer.parseInt(FunctionConstants.unimplRecArr[y][1]);
                int Ftype = Integer.parseInt(FunctionConstants.unimplRecArr[y][2]);
                if (Ftype == FunctionConstants.FTYPE_PTGFUNC) {
                    funcPtg = new PtgFunc(FID, form);
                } else if (Ftype == FunctionConstants.FTYPE_PTGFUNCVAR) {
                    funcPtg = new PtgFuncVar(FID, 0, form);
                } else if (Ftype == FunctionConstants.FTYPE_PTGFUNCVAR_ADDIN) {
                    funcPtg = new PtgFuncVar(255, 0, form);
                }
                return funcPtg;
            }
            ++y;
        }
        return funcPtg;
    }

    private static Ptg parseSinglePtg(XLSRecord form, String fmla, boolean bIsUnary) {
        String val = fmla;
        WorkBook bk = form.getWorkBook();
        String name = FormulaParser.convertString(val, bk);
        if (name.equals("+") && bIsUnary) {
            name = "u+";
        } else if (name.equals("-") && bIsUnary) {
            name = "u-";
        }
        Ptg pthing = null;
        try {
            pthing = XLSRecordFactory.getPtgRecord(name);
            if (pthing == null && name.equals("PtgName")) {
                pthing = form.getOpcode() == 6 || form.getOpcode() == 545 ? new PtgName(67) : new PtgName(35);
            }
        }
        catch (InvalidRecordException e) {
            Logger.logInfo("parsing formula string.  Invalid Ptg: " + name + " error: " + e);
        }
        if (pthing != null) {
            pthing.setParentRec(form);
            if (!pthing.getIsOperator()) {
                if (pthing.getIsReference()) {
                    pthing = PtgRef.createPtgRefFromString(val, form);
                } else if (pthing instanceof PtgStr) {
                    PtgStr pstr = (PtgStr)pthing;
                    val = StringTool.strip(val, '\"');
                    pstr.setVal(val);
                } else if (pthing instanceof PtgNumber) {
                    PtgNumber pnum = (PtgNumber)pthing;
                    if (val.indexOf("%") == -1) {
                        pnum.setVal(new Double(val));
                    } else {
                        pnum.setVal(val);
                    }
                } else if (pthing instanceof PtgInt) {
                    PtgInt pint = (PtgInt)pthing;
                    pint.setVal(Integer.valueOf(val));
                } else if (pthing instanceof PtgBool) {
                    PtgBool pbool = (PtgBool)pthing;
                    pbool.setVal(Boolean.valueOf(val));
                } else if (pthing instanceof PtgArray) {
                    PtgArray parr = (PtgArray)pthing;
                    parr.setVal(val);
                } else if (pthing instanceof PtgName) {
                    PtgName pname = (PtgName)pthing;
                    pname.setName(val);
                    pname.addToRefTracker();
                } else if (pthing instanceof PtgNameX) {
                    PtgNameX pnameX = (PtgNameX)pthing;
                    pnameX.setName(val);
                } else if (pthing instanceof PtgMissArg) {
                    ((PtgMissArg)pthing).init(new byte[]{22});
                } else if (pthing instanceof PtgErr) {
                    pthing = new PtgErr(PtgErr.convertStringToLookupByte(val));
                } else if (pthing instanceof PtgAtr) {
                    pthing = new PtgAtr(64);
                }
            }
        } else {
            PtgMissArg ptgMissArg = new PtgMissArg();
        }
        return pthing;
    }

    private static String findPtg(String fmla, boolean bUnary) {
        String s = StringTool.allTrim(fmla);
        if (s.startsWith("\"") || s.startsWith("'")) {
            return s;
        }
        int i = 0;
        while (i < XLSRecordFactory.ptgOps.length) {
            String ptgOpStr = XLSRecordFactory.ptgOps[i][0];
            int x = s.indexOf(ptgOpStr);
            if (x == 0) {
                if (ptgOpStr.equals("(")) {
                    return s;
                }
                if (bUnary) {
                    if (ptgOpStr.equals("-") && x == 1 && ptgOpStr.length() > 1) break;
                    int j = 0;
                    while (j < XLSRecordFactory.ptgPrefixOperators.length) {
                        if (ptgOpStr.startsWith(XLSRecordFactory.ptgPrefixOperators[j][0].toString())) {
                            ptgOpStr = XLSRecordFactory.ptgPrefixOperators[j][1].toString();
                        }
                        ++j;
                    }
                }
                return XLSRecordFactory.ptgOps[i][1];
            }
            ++i;
        }
        return s;
    }

    private static Stack parseFinalLevel(XLSRecord form, String fmla, boolean bIsComplete) {
        Stack returnStack = new Stack();
        CompatibleVector parseThings = new CompatibleVector();
        CompatibleVector elements = new Vector();
        elements = FormulaParser.splitString(fmla, bIsComplete);
        WorkBook bk = form.getWorkBook();
        int x = 0;
        while (x < elements.size()) {
            String val = (String)elements.elementAt(x);
            String name = FormulaParser.convertString(val, bk);
            Ptg pthing = null;
            try {
                pthing = XLSRecordFactory.getPtgRecord(name);
                if (pthing == null && name.equals("PtgName")) {
                    pthing = form.getOpcode() == 6 || form.getOpcode() == 545 ? new PtgName(67) : new PtgName(35);
                }
            }
            catch (InvalidRecordException e) {
                Logger.logInfo("parsing formula string.  Invalid Ptg: " + name + " error: " + e);
            }
            if (pthing != null) {
                pthing.setParentRec(form);
                if (!pthing.getIsOperator()) {
                    if (pthing.getIsReference()) {
                        pthing = PtgRef.createPtgRefFromString(val, form);
                    } else if (pthing instanceof PtgStr) {
                        PtgStr pstr = (PtgStr)pthing;
                        val = StringTool.strip(val, '\"');
                        pstr.setVal(val);
                    } else if (pthing instanceof PtgNumber) {
                        PtgNumber pnum = (PtgNumber)pthing;
                        if (val.indexOf("%") == -1) {
                            pnum.setVal(new Double(val));
                        } else {
                            pnum.setVal(val);
                        }
                    } else if (pthing instanceof PtgInt) {
                        PtgInt pint = (PtgInt)pthing;
                        pint.setVal(Integer.valueOf(val));
                    } else if (pthing instanceof PtgBool) {
                        PtgBool pbool = (PtgBool)pthing;
                        pbool.setVal(Boolean.valueOf(val));
                    } else if (pthing instanceof PtgArray) {
                        PtgArray parr = (PtgArray)pthing;
                        parr.setVal(val);
                    } else if (pthing instanceof PtgName) {
                        PtgName pname = (PtgName)pthing;
                        pname.setName(val);
                    } else if (pthing instanceof PtgNameX) {
                        PtgNameX pnameX = (PtgNameX)pthing;
                        pnameX.setName(val);
                    } else if (pthing instanceof PtgMissArg) {
                        ((PtgMissArg)pthing).init(new byte[]{22});
                    } else if (pthing instanceof PtgErr) {
                        pthing = new PtgErr(PtgErr.convertStringToLookupByte(val));
                    }
                }
                parseThings.add(pthing);
            } else {
                PtgMissArg ptgMissArg = new PtgMissArg();
            }
            ++x;
        }
        returnStack = FormulaParser.convertToStack(parseThings);
        return returnStack;
    }

    private static Stack convertToStack(CompatibleVector parseThings) {
        Stack<Ptg> returnStack = new Stack<Ptg>();
        Stack pOperators = new Stack();
        int x = 0;
        while (x < parseThings.size()) {
            Ptg pthing = (Ptg)parseThings.elementAt(x);
            returnStack.push(pthing);
            ++x;
        }
        return returnStack;
    }

    private static CompatibleVector splitFunctionOperands(String formStr) {
        CompatibleVector locs = new CompatibleVector();
        if (formStr.equals("")) {
            return locs;
        }
        boolean loop = true;
        int pos = 0;
        CompatibleVector badLocs = new CompatibleVector();
        while (loop) {
            char c = '\"';
            int start = formStr.indexOf(c, pos);
            if (start == -1) {
                c = '\'';
                start = formStr.indexOf(c, pos);
            }
            if (start != -1) {
                int end = formStr.indexOf(c, start + 1);
                if (++end < formStr.length() && formStr.charAt(end) == '!') {
                    ++end;
                    while (end < formStr.length() && loop) {
                        c = formStr.charAt(end);
                        if (!Character.isLetterOrDigit(c) && c != ':' && c != '$' || c == '-' || c == '+') {
                            loop = false;
                            continue;
                        }
                        ++end;
                    }
                }
                int y = start;
                while (y < end) {
                    badLocs.add(y);
                    ++y;
                }
                if (end == 0) {
                    end = formStr.length() - 1;
                    loop = false;
                    continue;
                }
                pos = end;
                loop = true;
                continue;
            }
            loop = false;
        }
        if (formStr.indexOf(",") == -1) {
            locs.add(formStr);
        } else {
            int closeparen;
            int openparen;
            int i = 0;
            while (i < formStr.length()) {
                openparen = formStr.indexOf("(", i);
                if (openparen == -1) break;
                if (!badLocs.contains(openparen)) {
                    closeparen = FormulaParser.getMatchOperator(formStr, openparen, '(', ')');
                    if (closeparen == -1) {
                        closeparen = formStr.length();
                    }
                    i = openparen;
                    while (i < closeparen) {
                        Integer in = i;
                        badLocs.add(in);
                        ++i;
                    }
                } else {
                    i = openparen + 1;
                }
                ++i;
            }
            i = 0;
            while (i < formStr.length()) {
                openparen = formStr.indexOf("{", i);
                if (openparen == -1) break;
                if (!badLocs.contains(openparen)) {
                    closeparen = FormulaParser.getMatchOperator(formStr, openparen, '{', '}');
                    if (closeparen == -1) {
                        closeparen = formStr.length();
                    }
                    i = openparen;
                    while (i < closeparen) {
                        Integer in = i;
                        badLocs.add(in);
                        ++i;
                    }
                } else {
                    i = openparen + 1;
                }
                ++i;
            }
            int placeholder = 0;
            int holder = 0;
            while (holder != -1) {
                int i2 = formStr.indexOf(",", holder);
                if (i2 != -1) {
                    Integer ing = i2;
                    if (!badLocs.contains(ing)) {
                        String s = formStr.substring(placeholder, i2);
                        locs.add(s);
                        placeholder = i2 + 1;
                    }
                    holder = i2 + 1;
                    continue;
                }
                String s = formStr.substring(placeholder, formStr.length());
                locs.add(s);
                return locs;
            }
        }
        return locs;
    }

    private static CompatibleVector parsePtgOperators(String s, boolean bUnary) {
        CompatibleVector ret = new CompatibleVector();
        s = StringTool.allTrim(s);
        int i = 0;
        while (i < XLSRecordFactory.ptgOps.length) {
            String ptgOpStr = XLSRecordFactory.ptgOps[i][0];
            if (s.startsWith("\"") || s.startsWith("'")) {
                int end = s.substring(1).indexOf(s.charAt(0));
                if (++end < s.length() && s.charAt(end) == '!') {
                    ++end;
                    boolean loop = true;
                    while (end < s.length() && loop) {
                        char c = s.charAt(end);
                        if (c == '#' && s.endsWith("#REF!")) {
                            end += 5;
                            loop = false;
                            continue;
                        }
                        if (!Character.isLetterOrDigit(c) && c != ':' && c != '$' || c == '-' || c == '+') {
                            loop = false;
                            continue;
                        }
                        ++end;
                    }
                }
                ret.add(s.substring(0, end + 1));
                s = s.substring(end + 1);
                bUnary = false;
                if (s.equals("")) break;
                ret.addAll(FormulaParser.parsePtgOperators(s, bUnary));
                break;
            }
            int x = s.indexOf(ptgOpStr);
            if (x > -1) {
                if (ptgOpStr.equals("(")) {
                    int end = FormulaParser.getMatchOperator(s, x, '(', ')');
                    ret.add(s);
                    break;
                }
                if (!ptgOpStr.equals(")")) {
                    if (x > 0) {
                        if (!XLSRecordFactory.ptgLookup[i][1].equals("PtgErr") || s.charAt(x - 1) != '!') {
                            ret.addAll(FormulaParser.parsePtgOperators(s.substring(0, x), bUnary));
                            bUnary = false;
                        } else {
                            ptgOpStr = s;
                        }
                    }
                    x += ptgOpStr.length();
                    if (bUnary) {
                        if (ptgOpStr.equals("-") && x == 1 && ptgOpStr.length() > 1) break;
                        int j = 0;
                        while (j < XLSRecordFactory.ptgPrefixOperators.length) {
                            if (ptgOpStr.startsWith(XLSRecordFactory.ptgPrefixOperators[j][0].toString())) {
                                ptgOpStr = XLSRecordFactory.ptgPrefixOperators[j][1].toString();
                            }
                            ++j;
                        }
                    }
                    ret.add(ptgOpStr);
                    if (x >= s.length()) break;
                    ret.addAll(FormulaParser.parsePtgOperators(s.substring(x), true));
                    break;
                }
            }
            ++i;
        }
        if (ret.isEmpty()) {
            ret.add(s);
        }
        return ret;
    }

    private static CompatibleVector splitString(String formStr, boolean bIsComplete) {
        CompatibleVector locs = new CompatibleVector();
        CompatibleVector retVect = new CompatibleVector();
        if ((formStr = StringTool.allTrim(formStr)).equals("")) {
            retVect.add(formStr);
            return retVect;
        }
        retVect.addAll(FormulaParser.parsePtgOperators(formStr, bIsComplete));
        bIsComplete = false;
        return retVect;
    }

    private static String convertString(String ptg, WorkBook bk) {
        int i = 0;
        while (i < XLSRecordFactory.ptgLookup.length) {
            if (ptg.equalsIgnoreCase(XLSRecordFactory.ptgLookup[i][0])) {
                return ptg;
            }
            ++i;
        }
        if (StringTool.allTrim(ptg).equals("")) {
            return "PtgAtr";
        }
        if (ptg.substring(0, 1).equalsIgnoreCase("\"")) {
            return "PtgStr";
        }
        if (ptg.substring(0, 1).equalsIgnoreCase("{")) {
            return "PtgArray";
        }
        if (ptg.indexOf(".") == -1) {
            try {
                Integer i2 = Integer.valueOf(ptg);
                if (i2 >= 0 && i2 <= 65535) {
                    return "PtgInt";
                }
                return "PtgNumber";
            }
            catch (NumberFormatException i2) {
                // empty catch block
            }
        }
        if (ptg.indexOf("%") == ptg.length() - 1) {
            try {
                Double d = new Double(ptg.substring(0, ptg.indexOf("%")));
                return "PtgNumber";
            }
            catch (NumberFormatException d) {
                // empty catch block
            }
        }
        try {
            Double d = new Double(ptg);
            return "PtgNumber";
        }
        catch (NumberFormatException d) {
            if (ptg.indexOf(":") != -1 || ptg.indexOf(44) != -1 || ptg.indexOf("!") != -1) {
                return "PtgArea";
            }
            try {
                if (bk.getName(ptg) == null) {
                    ExcelTools.getRowColFromString(ptg);
                    return "PtgRef";
                }
                return "PtgName";
            }
            catch (IllegalArgumentException e) {
                return "PtgName";
            }
        }
    }

    private static String cleanString(String dirtystring) {
        String cleanstring = StringTool.allTrim(dirtystring);
        cleanstring = StringTool.strip(cleanstring, "(");
        cleanstring = StringTool.strip(cleanstring, ",");
        return cleanstring;
    }

    protected static Stack getPtgsFromFormulaString(String fmla) {
        return null;
    }

    public static Formula setFormula(Formula form, String fmla, int[] rc) {
        if (fmla.charAt(0) != '{') {
            try {
                Stack newptgs = FormulaParser.getPtgsFromFormulaString(form, fmla);
                FormulaParser.adjustParameterIds(newptgs);
                form.setExpression(newptgs);
            }
            catch (FunctionNotSupportedException e) {
                Logger.logErr("Adding new Formula at " + form.getSheet() + "!" + ExcelTools.formatLocation(rc) + " failed: " + e.toString() + ".");
                Stack<PtgErr> newptgs = new Stack<PtgErr>();
                newptgs.push(new PtgErr(PtgErr.ERROR_NA));
                form.setExpression(newptgs);
            }
        } else {
            PtgExp pe = new PtgExp();
            pe.setParentRec(form);
            Object o = form.getSheet().getArrayFormulaParent(rc);
            if (o != null) {
                rc = (int[])o;
            } else {
                String addr = ExcelTools.formatLocation(rc);
                form.getSheet().addParentArrayRef(addr, addr);
            }
            pe.init(rc[0], rc[1]);
            Stack<PtgExp> e = new Stack<PtgExp>();
            e.push(pe);
            FormulaParser.adjustParameterIds(e);
            form.setExpression(e);
            Array a = new Array();
            a.setSheet(form.getSheet());
            a.setWorkBook(form.getWorkBook());
            a.init(fmla, rc[0], rc[1]);
            form.addInternalRecord(a);
        }
        return form;
    }

    public static String getFormulaString(Formula form) {
        Stack expression = form.getExpression();
        return FormulaParser.getExpressionString(expression);
    }

    public static String getExpressionString(Stack expression) {
        StringBuffer retval = new StringBuffer("");
        int sz = expression.size();
        Ptg[] stck = new Ptg[sz];
        stck = expression.toArray(stck);
        Stack<Ptg> newstck = new Stack<Ptg>();
        int t = 0;
        while (t < sz) {
            newstck.add(0, stck[t]);
            ++t;
        }
        Stack vals = new Stack();
        while (!newstck.isEmpty()) {
            FormulaParser.handlePtg(newstck, vals);
        }
        String s = "";
        while (!vals.isEmpty()) {
            Ptg topP = (Ptg)vals.pop();
            s = String.valueOf(topP.getTextString()) + s;
        }
        retval = new StringBuffer("=" + s);
        return retval.toString();
    }

    public static void adjustParameterIds(Stack expression) {
        StringBuffer retval = new StringBuffer("");
        int sz = expression.size();
        Ptg[] stck = new Ptg[sz];
        stck = expression.toArray(stck);
        Stack<Ptg> newstck = new Stack<Ptg>();
        int t = 0;
        while (t < sz) {
            newstck.add(0, stck[t]);
            ++t;
        }
        Stack<Ptg> params = new Stack<Ptg>();
        while (!newstck.isEmpty()) {
            Ptg[] vx;
            Ptg p = (Ptg)newstck.pop();
            boolean x = false;
            int t2 = 0;
            if (p.getIsControl()) {
                if (p.getOpcode() != 21) continue;
                if (t2 > 0) {
                    vx = new Ptg[]{(Ptg)params.pop()};
                    p.setVars(vx);
                    params.push(p);
                    continue;
                }
                params.push(p);
                continue;
            }
            if (p.getIsOperator() || p.getIsFunction()) {
                if (p.getIsBinaryOperator()) {
                    t2 = 2;
                }
                if (p.getIsUnaryOperator()) {
                    t2 = 1;
                }
                if (p.getIsStandAloneOperator()) {
                    t2 = 0;
                }
                if (p.getOpcode() == 34 || p.getOpcode() == 66 || p.getOpcode() == 98) {
                    t2 = p.getNumParams();
                }
                if (p.getOpcode() == 33 || p.getOpcode() == 65 || p.getOpcode() == 97) {
                    t2 = p.getNumParams();
                }
                if (t2 > params.size()) {
                    t2 = params.size();
                }
                vx = new Ptg[t2];
                while (t2 > 0) {
                    vx[--t2] = (Ptg)params.pop();
                }
                p.setVars(vx);
                if (p.getOpcode() == 34 || p.getOpcode() == 66 || p.getOpcode() == 98) {
                    ((PtgFuncVar)p).adjustParameterIds();
                } else if (p.getOpcode() == 33 || p.getOpcode() == 65 || p.getOpcode() == 97) {
                    ((PtgFunc)p).adjustParameterIds();
                }
                params.push(p);
                continue;
            }
            if (!p.getIsOperand()) continue;
            params.push(p);
        }
    }

    static void handlePtg(Stack newstck, Stack vals) {
        Ptg p = (Ptg)newstck.pop();
        boolean x = false;
        int t = 0;
        if (p.getIsOperator() || p.getIsControl() || p.getIsFunction()) {
            t = vals.size();
            if (p.getIsControl() && p.getOpcode() == 21) {
                if (t > 0) {
                    Ptg[] vx = new Ptg[]{(Ptg)vals.pop()};
                    p.setVars(vx);
                    vals.push(p);
                } else {
                    vals.push(p);
                }
                return;
            }
            if (t > 0) {
                if (p.getIsBinaryOperator()) {
                    t = 2;
                }
                if (p.getIsUnaryOperator()) {
                    t = 1;
                }
                if (p.getIsStandAloneOperator()) {
                    t = 0;
                }
                if (p.getOpcode() == 34 || p.getOpcode() == 66 || p.getOpcode() == 98) {
                    t = p.getNumParams();
                }
                if (p.getOpcode() == 33 || p.getOpcode() == 65 || p.getOpcode() == 97) {
                    t = p.getNumParams();
                }
                if (t > vals.size()) {
                    if (DEBUGLEVEL > 0) {
                        Logger.logWarn("FormulaParser.handlePtg: number of parameters " + t + " is greater than available " + vals.size());
                    }
                    t = vals.size();
                }
                Ptg[] vx = new Ptg[t];
                while (t > 0) {
                    vx[--t] = (Ptg)vals.pop();
                }
                p.setVars(vx);
            }
            vals.push(p);
        } else if (p.getIsOperand()) {
            vals.push(p);
        } else if (!(p instanceof PtgAtr) && DEBUGLEVEL > -1) {
            Logger.logInfo("FormulaParser Error - Ptg Type: " + p.getOpcode() + " " + p.getString());
        }
    }

    public static Formula getFormulaFromString(String formStr, Boundsheet st, int[] rc) throws Exception {
        Formula f = new Formula();
        if (st != null) {
            f.setSheet(st);
            f.setWorkBook(st.getWorkBook());
        }
        f.setData(new byte[6]);
        f.setRowCol(rc);
        f = FormulaParser.setFormula(f, formStr, rc);
        return f;
    }

    public static Formula setFormulaString(String formStr, int[] rc) throws Exception {
        Formula f = new Formula();
        f = FormulaParser.setFormula(f, formStr, rc);
        return f;
    }

    public static boolean isRef(String s) {
        if (s == null) {
            return false;
        }
        String simpleOne = "(([ ]*[']?([a-zA-Z0-9 _]*[']*[!])?[$]*[a-zA-Z]{1,2}[$]*[0-9]+){1})";
        return s.matches(simpleOne);
    }

    public static boolean isRange(String s) {
        if (s == null) {
            return false;
        }
        String one = "(([(]*[ ]*[']?([a-zA-Z0-9 _]*[']*[!])?[$]*[a-zA-Z]{1,2}[$]*[0-9]+[)]*){1})";
        String aRange = String.valueOf(one) + "(:" + one + ")?";
        String rangeop = "([ ]*[: ,][ ]*)";
        String rangeMatchString = String.valueOf(aRange) + rangeop + aRange + "(" + rangeop + aRange + ")*";
        String simpleOne = "(([ ]*[']?([a-zA-Z0-9 ]*[']*[!])?[$]*[a-zA-Z]{1,2}[$]*[0-9]+){1})";
        String simpleRangeMatchString = "(" + simpleOne + "[ ]*[:][ ]*" + simpleOne + ")";
        return s.matches(rangeMatchString);
    }

    public static boolean isComplexRange(String s) {
        String one = "(([(]*[ ]*[']?([a-zA-Z0-9 _]*[']*[!])?[$]*[a-zA-Z]{1,2}[$]*[0-9]+[)]*){1})";
        String aRange = String.valueOf(one) + "(:" + one + ")?";
        String rangeop = "([ ]*[: ,][ ]*)";
        String rangeMatchString = String.valueOf(aRange) + rangeop + aRange + "(" + rangeop + aRange + ")*";
        String simpleOne = "(([ ]*[']?([a-zA-Z0-9 _]*[']*[!])?[$]*[a-zA-Z]{1,2}[$]*[0-9]+){1})";
        String simpleRangeMatchString = "(" + simpleOne + "[ ]*[:][ ]*" + simpleOne + ")";
        return FormulaParser.isRange(s) && !s.matches(simpleRangeMatchString);
    }
}

