/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.ReferenceTracker;
import com.extentech.formats.XLS.formulas.Criteria;
import com.extentech.formats.XLS.formulas.DB;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgStr;
import java.util.ArrayList;

public class DatabaseCalculator {
    public static boolean DEBUG = false;

    private static DB getDb(Ptg operands) {
        ReferenceTracker DBcache = operands.getParentRec().getWorkBook().getRefTracker();
        if (DBcache.getListDBs().get(operands.toString()) != null) {
            return (DB)DBcache.getListDBs().get(operands.toString());
        }
        Ptg[] dbrange = PtgCalculator.getAllComponents(operands);
        DB ret = DB.parseList(dbrange);
        DBcache.getListDBs().put(operands.toString(), ret);
        return ret;
    }

    private static Criteria getCriteria(Ptg operands) {
        ReferenceTracker DBcache = operands.getParentRec().getWorkBook().getRefTracker();
        if (DBcache.getCriteriaDBs().get(operands.toString()) != null) {
            return (Criteria)DBcache.getCriteriaDBs().get(operands.toString());
        }
        Ptg[] criteria = PtgCalculator.getAllComponents(operands);
        Criteria ret = Criteria.parseCriteria(criteria);
        DBcache.getCriteriaDBs().put(operands.toString(), ret);
        return ret;
    }

    protected static Ptg calcDAverage(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double average = 0.0;
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.rows.length) {
            Ptg vx;
            Ptg[] rwz = db.getRow(i);
            if (crit.passes(colname, rwz, db) && (vx = rwz[fNum]) != null) {
                try {
                    average += Double.parseDouble(vx.getValue().toString());
                    ++count;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (count > 0) {
            average /= (double)count;
        }
        return new PtgNumber(average);
    }

    protected static Ptg calcDCount(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int count = 0;
        int nrow = db.getNRows();
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < nrow) {
            try {
                Ptg cx;
                String vtx;
                Ptg[] rr = db.getRow(i);
                if (crit.passes(colname, rr, db) && (vtx = (cx = db.getCell(i, fNum)).getValue().toString()) != null) {
                    Double.parseDouble(vtx);
                    ++count;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return new PtgNumber(count);
    }

    protected static Ptg calcDCountA(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            String s;
            if (crit.passes(colname, db.getRow(i), db) && (s = db.getCell(i, fNum).getValue().toString()) != null && !s.trim().equals("")) {
                ++count;
            }
            ++i;
        }
        return new PtgNumber(count);
    }

    protected static Ptg calcDGet(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        String val = "";
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            if (crit.passes(colname, db.getRow(i), db)) {
                val = db.getCell(i, fNum).getValue().toString();
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (count > 1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        return new PtgStr(val);
    }

    protected static Ptg calcDMax(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double max = Double.MIN_VALUE;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            String vtx;
            if (crit.passes(colname, db.getRow(i), db) && (vtx = db.getCell(i, fNum).getValue().toString()) != null) {
                try {
                    if (vtx.length() > 0) {
                        max = Math.max(max, Double.parseDouble(vtx));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (max == Double.MIN_VALUE) {
            max = 0.0;
        }
        return new PtgNumber(max);
    }

    protected static Ptg calcDMin(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double min = Double.MAX_VALUE;
        String colnamx = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            block10: {
                try {
                    Ptg[] rwz = db.getRow(i);
                    if (!crit.passes(colnamx, rwz, db)) break block10;
                    try {
                        String dnb;
                        Ptg dbx = db.getCell(i, fNum);
                        if (dbx != null && (dnb = dbx.getValue().toString()) != null && dnb.length() > 0) {
                            min = Math.min(min, Double.parseDouble(dnb));
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
        }
        return new PtgNumber(min);
    }

    protected static Ptg calcDProduct(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double product = 1.0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            try {
                String fnx;
                if (crit.passes(colname, db.getRow(i), db) && (fnx = db.getCell(i, fNum).getValue().toString()) != null) {
                    product *= Double.parseDouble(fnx);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return new PtgNumber(product);
    }

    protected static Ptg calcDStdDev(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        ArrayList<String> vals = new ArrayList<String>();
        double sum = 0.0;
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            if (crit.passes(colname, db.getRow(i), db)) {
                try {
                    String fnx = db.getCell(i, fNum).getValue().toString();
                    if (fnx != null) {
                        double x = Double.parseDouble(fnx);
                        sum += x;
                        ++count;
                        vals.add(Double.toString(x));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        double stdev = 0.0;
        if (count > 0) {
            double average = sum / (double)count;
            int i2 = 0;
            while (i2 < count) {
                double x = Double.parseDouble((String)vals.get(i2));
                stdev += Math.pow(x - average, 2.0);
                ++i2;
            }
            if (count > 1) {
                --count;
            }
            stdev = Math.sqrt(stdev / (double)count);
        }
        return new PtgNumber(stdev);
    }

    protected static Ptg calcDStdDevP(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        ArrayList<String> vals = new ArrayList<String>();
        double sum = 0.0;
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            if (crit.passes(colname, db.getRow(i), db)) {
                try {
                    String fnx = db.getCell(i, fNum).getValue().toString();
                    if (fnx != null) {
                        double x = Double.parseDouble(fnx);
                        sum += x;
                        ++count;
                        vals.add(Double.toString(x));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        double stdevp = 0.0;
        if (count > 0) {
            double average = sum / (double)count;
            int i2 = 0;
            while (i2 < count) {
                double x = Double.parseDouble((String)vals.get(i2));
                stdevp += Math.pow(x - average, 2.0);
                ++i2;
            }
            stdevp = Math.sqrt(stdevp / (double)count);
        }
        return new PtgNumber(stdevp);
    }

    protected static Ptg calcDSum(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        boolean count = false;
        double sum = 0.0;
        int nrow = db.getNRows();
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < nrow) {
            block9: {
                try {
                    Ptg[] rr = db.getRow(i);
                    if (!crit.passes(colname, rr, db)) break block9;
                    try {
                        String fnx = db.getCell(i, fNum).getValue().toString();
                        if (fnx != null) {
                            sum += Double.parseDouble(fnx);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return new PtgNumber(sum);
    }

    protected static Ptg calcDVar(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        ArrayList<String> vals = new ArrayList<String>();
        double sum = 0.0;
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            if (crit.passes(colname, db.getRow(i), db)) {
                try {
                    String fnx = db.getCell(i, fNum).getValue().toString();
                    if (fnx != null) {
                        double x = Double.parseDouble(db.getCell(i, fNum).toString());
                        sum += x;
                        ++count;
                        vals.add(Double.toString(x));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        double variance = 0.0;
        if (count > 0) {
            double average = sum / (double)count;
            int i2 = 0;
            while (i2 < count) {
                double x = Double.parseDouble((String)vals.get(i2));
                variance += Math.pow(x - average, 2.0);
                ++i2;
            }
            if (count > 1) {
                --count;
            }
            variance /= (double)count;
        }
        return new PtgNumber(variance);
    }

    protected static Ptg calcDVarP(Ptg[] operands) {
        if (operands.length != 3) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        DB db = DatabaseCalculator.getDb(operands[0]);
        Criteria crit = DatabaseCalculator.getCriteria(operands[2]);
        if (db == null || crit == null) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int fNum = db.findCol(operands[1].getString().trim());
        if (fNum == -1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        ArrayList<String> vals = new ArrayList<String>();
        double sum = 0.0;
        int count = 0;
        String colname = operands[1].getValue().toString();
        int i = 0;
        while (i < db.getNRows()) {
            if (crit.passes(colname, db.getRow(i), db)) {
                try {
                    String fnx = db.getCell(i, fNum).getValue().toString();
                    if (fnx != null) {
                        double x = Double.parseDouble(fnx);
                        sum += x;
                        ++count;
                        vals.add(Double.toString(x));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        double varP = 0.0;
        if (count > 0) {
            double average = sum / (double)count;
            int i2 = 0;
            while (i2 < count) {
                double x = Double.parseDouble((String)vals.get(i2));
                varP += Math.pow(x - average, 2.0);
                ++i2;
            }
            varP /= (double)count;
        }
        return new PtgNumber(varP);
    }
}

