/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Tick
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 3363212452589555220L;
    byte tktMajor;
    byte tktMinor;
    byte tit;
    short grbit;
    short rot;
    private byte[] PROTOTYPE_BYTES;

    public Tick() {
        byte[] byArray = new byte[30];
        byArray[0] = 2;
        byArray[2] = 3;
        byArray[3] = 1;
        byArray[24] = 35;
        byArray[26] = 77;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.tktMajor = this.getByteAt(0);
        this.tktMinor = this.getByteAt(1);
        this.tit = this.getByteAt(2);
        this.grbit = ByteTools.readShort(this.getByteAt(24), this.getByteAt(25));
        this.rot = (short)((this.grbit & 0x1C) >> 2);
    }

    public static XLSRecord getPrototype() {
        Tick t = new Tick();
        t.setOpcode((short)4126);
        t.setData(t.PROTOTYPE_BYTES);
        t.init();
        return t;
    }

    private void updateRecord() {
        this.getData()[0] = this.tktMajor;
        this.getData()[1] = this.tktMinor;
        this.getData()[2] = this.tit;
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[24] = b[0];
        this.getData()[25] = b[1];
    }

    public void setOption(String op, String val) {
        if (op.equals("tickLblPos")) {
            if (val.equals("high")) {
                this.tit = (byte)2;
            } else if (val.equals("low")) {
                this.tit = 1;
            } else if (val.equals("none")) {
                this.tit = 0;
            } else if (val.equals("nextTo")) {
                this.tit = (byte)3;
            }
        } else if (op.equals("majorTickMark")) {
            if (val.equals("cross")) {
                this.tktMajor = (byte)3;
            } else if (val.equals("in")) {
                this.tktMajor = 1;
            } else if (val.equals("out")) {
                this.tktMajor = (byte)2;
            } else if (val.equals("none")) {
                this.tktMajor = 0;
            }
        } else if (op.equals("minorTickMark")) {
            if (val.equals("cross")) {
                this.tktMinor = (byte)3;
            } else if (val.equals("in")) {
                this.tktMinor = 1;
            } else if (val.equals("out")) {
                this.tktMinor = (byte)2;
            } else if (val.equals("none")) {
                this.tktMinor = 0;
            }
        }
        this.updateRecord();
    }

    public String getOption(String op) {
        if (op.equals("tickLblPos")) {
            switch (this.tit) {
                case 0: {
                    return "none";
                }
                case 1: {
                    return "low";
                }
                case 2: {
                    return "high";
                }
                case 3: {
                    return "nextTo";
                }
            }
        } else if (op.equals("majorTickMark")) {
            switch (this.tktMajor) {
                case 0: {
                    return "none";
                }
                case 1: {
                    return "in";
                }
                case 2: {
                    return "out";
                }
                case 3: {
                    return "cross";
                }
            }
        } else if (op.equals("minorTickMark")) {
            switch (this.tktMinor) {
                case 0: {
                    return "none";
                }
                case 1: {
                    return "in";
                }
                case 2: {
                    return "out";
                }
                case 3: {
                    return "cross";
                }
            }
        }
        return null;
    }

    public boolean showMinorTicks() {
        return this.tktMinor != 0;
    }

    public boolean showMajorTicks() {
        return this.tktMajor != 0;
    }

    public short getRotation() {
        return this.rot;
    }
}

